/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.util.ModifyState;
import com.ejianc.business.scene.util.OperationState;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.business.scene.util.ReviewState;
import com.ejianc.business.scene.util.SubmitState;
import com.ejianc.business.scene.vo.SceneCheckDetailVO;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"review"})
@Api(value="\u5f85\u590d\u68c0", tags={"\u68c0\u67e5\u5355\u4e3b\u5b50\u8868"})
public class ReviewController {
    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ApiOperation(value="\u5f85\u590d\u68c0\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SceneCheckVO> queryDetail(@RequestParam Long id) {
        SceneCheckEntity entity = (SceneCheckEntity)((Object)this.service.selectById(id));
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails, SceneCheckDetailVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetailVOList.forEach(item -> item.setBaseImgUrl(this.baseHost));
        }
        SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)entity), SceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f85\u590d\u68c0\u5355\u636e")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SceneCheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("reform_status", new Parameter("in", Arrays.asList(ReformState.REVIEW_STATE.getCode(), ReformState.REVIEW_FAILED_STATE.getCode())));
        param.getParams().put("review_id", new Parameter("like", (Object)this.sessionManager.getUserContext().getUserId().toString()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SceneCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u63d0\u4ea4\u590d\u67e5\u4fe1\u606f")
    @RequestMapping(value={"/submitReviewNews"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SceneCheckVO> submitReviewNews(@ApiParam(name="submitReviewNews", required=true) @RequestBody SceneCheckVO param) {
        int size;
        SceneCheckEntity entity = (SceneCheckEntity)((Object)BeanMapper.map((Object)param, SceneCheckEntity.class));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            List reviewResults = sceneCheckDetails.stream().map(SceneCheckDetailEntity::getReviewResult).collect(Collectors.toList());
            ArrayList list = new ArrayList();
            List<SceneCheckDetailEntity> sceneCheckDetailList = null;
            if (reviewResults.contains(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                updateWrapper.set(SceneCheckEntity::getReformStatus, (Object)Integer.parseInt(ReformState.REVIEW_FAILED_STATE.getCode()));
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).collect(Collectors.toList());
            }
            if ((size = reviewResults.stream().filter(reviewResult -> reviewResult == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList()).size()) == sceneCheckDetails.size()) {
                updateWrapper.set(SceneCheckEntity::getReformStatus, (Object)Integer.parseInt(ReformState.REVIEW_FINISHED_STATE.getCode()));
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList());
            }
            sceneCheckDetailList.forEach(item -> {
                SceneCheckRecordEntity sceneCheckRecord = new SceneCheckRecordEntity();
                sceneCheckRecord.setPid(item.getId());
                sceneCheckRecord.setCheckId(item.getPid());
                sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.REVIEW_STATE.getCode()));
                sceneCheckRecord.setReviewPerson(item.getActualReviewer());
                sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                sceneCheckRecord.setReviewResult(item.getReviewResult());
                sceneCheckRecord.setImgIds(item.getReviewImgIds());
                sceneCheckRecord.setImgUrl(item.getReviewImgUrl());
                sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                sceneCheckRecord.setCheckItem(item.getCheckItem());
                sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
                sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                list.add(sceneCheckRecord);
            });
            this.sceneCheckRecordService.saveBatch(list, list.size());
            sceneCheckDetails.forEach(sceneCheckitem -> {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("pid", new Parameter("eq", (Object)sceneCheckitem.getId()));
                queryParam.getOrderMap().put("createTime", "desc");
                queryParam.getParams().put("operation_type", new Parameter("eq", (Object)Integer.parseInt(OperationState.REFORM_STATE.getCode())));
                List sceneCheckRecords = this.sceneCheckRecordService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty((Collection)sceneCheckRecords)) {
                    System.out.println(sceneCheckRecords);
                    SceneCheckRecordEntity sceneCheckRecordEntity = (SceneCheckRecordEntity)((Object)((Object)sceneCheckRecords.get(0)));
                    if (sceneCheckRecordEntity.getImgIds() != null) {
                        List<String> imgids = Arrays.asList(sceneCheckRecordEntity.getImgIds().split(","));
                        ArrayList attachIds = new ArrayList();
                        imgids.forEach(item -> attachIds.add(Long.parseLong(item)));
                        this.iAttachmentApi.updateAttachRef(sceneCheckRecordEntity.getId(), attachIds);
                    }
                }
            });
            sceneCheckDetails.forEach(item -> {
                LambdaUpdateWrapper updateReviewMsgWrapper = new LambdaUpdateWrapper();
                updateReviewMsgWrapper.eq(BaseEntity::getId, (Object)item.getId());
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                String dateTime = df.format(new Date());
                String reviewDescribe = "";
                if (StringUtils.isNotEmpty((String)item.getReviewDescribe())) {
                    reviewDescribe = item.getReviewDescribe();
                }
                updateReviewMsgWrapper.set(SceneCheckDetailEntity::getReviewMsg, (Object)(item.getActualReviewer() + "-" + dateTime + "-" + reviewDescribe));
                Integer reviewResult = item.getReviewResult();
                this.sceneCheckDetailService.update((Wrapper)updateReviewMsgWrapper);
            });
        }
        sceneCheckDetails.forEach(item -> {
            if (item.getReviewResult() != Integer.parseInt(ReviewState.REVIEW_STATE.getCode())) {
                LambdaUpdateWrapper isModifyWrapper = new LambdaUpdateWrapper();
                isModifyWrapper.eq(BaseEntity::getId, (Object)item.getId());
                isModifyWrapper.set(SceneCheckDetailEntity::getIsModify, (Object)Integer.parseInt(ModifyState.MODIFIED_STATE.getCode()));
                this.sceneCheckDetailService.update((Wrapper)isModifyWrapper);
            }
        });
        System.out.println("=============");
        System.out.println(sceneCheckDetails);
        sceneCheckDetails.forEach(item -> {
            if (item.getReviewResult() != null && item.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())) {
                LambdaUpdateWrapper sceneUpdateWrapper = new LambdaUpdateWrapper();
                sceneUpdateWrapper.eq(BaseEntity::getId, (Object)item.getId());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getReformImgIds, null);
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getReformImgUrl, null);
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getReformNews, null);
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getReviewDescribe, null);
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getReviewImgUrl, null);
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getReviewImgIds, null);
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getReviewDate, (Object)new Date());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getBillState, (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getTaskState, (Object)CheckItemReformState.REFORM_FAILED_STATE.getDescription());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getIsReform, (Object)Integer.parseInt(CheckItemReformState.REFORM_FAILED_STATE.getCode()));
                this.sceneCheckDetailService.update((Wrapper)sceneUpdateWrapper);
            }
            if (item.getReviewResult() != null && item.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())) {
                LambdaUpdateWrapper successWrapper = new LambdaUpdateWrapper();
                successWrapper.eq(BaseEntity::getId, (Object)item.getId());
                successWrapper.set(SceneCheckDetailEntity::getTaskState, (Object)CheckItemReformState.REFORM_SUCCESS_STATE.getDescription());
                successWrapper.set(SceneCheckDetailEntity::getIsReform, (Object)Integer.parseInt(CheckItemReformState.REFORM_SUCCESS_STATE.getCode()));
                if (item.getReviewDate() == null) {
                    successWrapper.set(SceneCheckDetailEntity::getReviewDate, (Object)new Date());
                }
                this.sceneCheckDetailService.update((Wrapper)successWrapper);
            }
        });
        Map<Integer, List<SceneCheckDetailEntity>> reviewMap = sceneCheckDetails.stream().filter(reviewItem -> reviewItem.getReviewResult() != null).collect(Collectors.groupingBy(SceneCheckDetailEntity::getReviewResult));
        if (!reviewMap.isEmpty()) {
            int reviewFinished = 0;
            if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode()))) {
                LambdaUpdateWrapper revieweFinishedWrapper = new LambdaUpdateWrapper();
                reviewFinished = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).size();
                revieweFinishedWrapper.set(SceneCheckEntity::getReviewPass, (Object)reviewFinished);
                revieweFinishedWrapper.eq(BaseEntity::getId, (Object)entity.getId());
                size = this.service.update((Wrapper)revieweFinishedWrapper) ? 1 : 0;
            }
            if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                LambdaUpdateWrapper revieweFailedWrapper = new LambdaUpdateWrapper();
                int reviewFailed = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).size();
                int size2 = reviewFinished + reviewFailed;
                revieweFailedWrapper.set(SceneCheckEntity::getReviewedNum, (Object)size2);
                revieweFailedWrapper.eq(BaseEntity::getId, (Object)entity.getId());
                boolean bl = this.service.update((Wrapper)revieweFailedWrapper);
            }
        }
        updateWrapper.set(SceneCheckEntity::getReviewStatus, (Object)Integer.parseInt(SubmitState.IS_SUBMITTED.getCode()));
        boolean update = this.service.update((Object)entity, (Wrapper)updateWrapper);
        if (update) {
            Long id = entity.getId();
            SceneCheckEntity checkenEntity = (SceneCheckEntity)((Object)this.service.selectById(id));
            SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)checkenEntity), SceneCheckVO.class);
            return CommonResponse.success((String)"\u63d0\u4ea4\u6210\u529f\uff01", (Object)vo);
        }
        return CommonResponse.error((String)"\u63d0\u4ea4\u5931\u8d25\uff01");
    }

    @ApiOperation(value="\u4fdd\u5b58\u590d\u67e5\u4fe1\u606f")
    @RequestMapping(value={"/saveReviewNews"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SceneCheckVO> saveReviewNews(@ApiParam(name="saveReviewNews", required=true) @RequestBody SceneCheckVO param) {
        SceneCheckEntity entity = (SceneCheckEntity)((Object)BeanMapper.map((Object)param, SceneCheckEntity.class));
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetails.forEach(sceneCheckDetail -> {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                String userName = this.sessionManager.getUserContext().getUserName();
                updateWrapper.set(SceneCheckDetailEntity::getActualReviewer, (Object)userName);
                updateWrapper.eq(BaseEntity::getId, (Object)sceneCheckDetail.getId());
                updateWrapper.set(SceneCheckDetailEntity::getReviewResult, (Object)sceneCheckDetail.getReviewResult());
                updateWrapper.set(SceneCheckDetailEntity::getReviewDescribe, (Object)sceneCheckDetail.getReviewDescribe());
                updateWrapper.set(SceneCheckDetailEntity::getReviewImgIds, (Object)sceneCheckDetail.getReviewImgIds());
                updateWrapper.set(SceneCheckDetailEntity::getReviewImgUrl, (Object)sceneCheckDetail.getReviewImgUrl());
                this.sceneCheckDetailService.update((Wrapper)updateWrapper);
            });
        }
        Long id = entity.getId();
        SceneCheckEntity sceneCheck = (SceneCheckEntity)((Object)this.service.selectById(id));
        SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)sceneCheck), SceneCheckVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

