package com.ejianc.business.scene.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.*;
import com.ejianc.business.scene.vo.SceneCheckDetailVO;
import com.ejianc.business.scene.vo.SceneCheckRecordVO;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scene.mapper.SceneCheckDetailMapper;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * 检查单待检复检子表
 *
 * @author generator
 *
 */
@Service("sceneCheckDetailService")
public class SceneCheckDetailServiceImpl extends BaseServiceImpl<SceneCheckDetailMapper, SceneCheckDetailEntity> implements ISceneCheckDetailService{

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ISceneCheckService service;
    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;

    @Autowired
    private JedisPool jedisPool;

    @Autowired
    private ICommenQueryFieldsService commenQueryFieldsService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private CheckMessageService checkMessageService;

    private static final String BILL_CODE = "SCENE_CHECK_DETAIL_CODE";//此处需要根据实际修改

    /**
     * 保存整改单
     * @param saveorUpdateVO
     * @return
     */
    @Override
    public CommonResponse<SceneCheckDetailVO> insertOrUpdate(SceneCheckDetailVO saveorUpdateVO) {

        SceneCheckDetailEntity entity = BeanMapper.map(saveorUpdateVO, SceneCheckDetailEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setIsReform(Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode()));
        }

        if(saveorUpdateVO.getVersion() !=null && saveorUpdateVO.getVersion()!=0){
            Jedis jedis = jedisPool.getResource();
            boolean locked = false;
            try{
                locked = RedisTool.tryLock(jedis, String.valueOf(saveorUpdateVO.getId()), "saveOrUpdate", 1000);
                logger.info("判断单据单据锁结果------"+locked);
                if(locked){
                    JSONObject checkDetailEntity = commenQueryFieldsService.queryBillDetail(String.valueOf(saveorUpdateVO.getId()),"BT211018000000001");
                    String objVersion = checkDetailEntity.getJSONObject("data").get("version").toString();
                    Integer version =checkDetailEntity.getJSONObject("data").get("version")==null?0:Integer.parseInt(objVersion.substring(0,objVersion.indexOf(".")));
                    Integer conVersion = saveorUpdateVO.getVersion();
                    if(version!=conVersion){
                        return CommonResponse.error("该检查项已被更新，请刷新后重新整改！");
                    }
                }else{
                    return CommonResponse.error("出现并发操作,请稍后重试！");
                }
            }catch (Exception e) {
                e.printStackTrace();
            } finally {
                if(locked) {
                    RedisTool.releaseLock(jedis, String.valueOf(saveorUpdateVO.getId()), "saveOrUpdate");
                }
                jedis.close();
            }
        }

        super.saveOrUpdate(entity, false);
        //新增或修改后，需要查询当前检查项的检查记录回显
        QueryParam param = new QueryParam();
        param.getParams().put("pid",new Parameter(QueryParam.EQ, entity.getId()));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        List<SceneCheckRecordEntity> sceneCheckRecordList = sceneCheckRecordService.queryList(param, false);
        SceneCheckDetailVO vo = BeanMapper.map(entity, SceneCheckDetailVO.class);
        List<SceneCheckRecordVO> sceneCheckRecordVO = BeanMapper.mapList(sceneCheckRecordList, SceneCheckRecordVO.class);
        vo.setSceneCheckRecords(sceneCheckRecordVO);

        return CommonResponse.success("保存或修改单据成功！",BeanMapper.map(vo, SceneCheckDetailVO.class));
    }

    @Override
    public void checkDetailSubmitHandler(Long billId) {
        if(billId != null){
            //提交后，检查项的整改次数+1
            SceneCheckDetailEntity sceneCheckDetail = this.selectById(billId);
            LambdaUpdateWrapper<SceneCheckDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(SceneCheckDetailEntity::getId,billId);
            updateWrapper.set(SceneCheckDetailEntity::getReformNumber,sceneCheckDetail.getReformNumber()+1);
            updateWrapper.set(SceneCheckDetailEntity::getIsReform, Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode()));
            updateWrapper.set(SceneCheckDetailEntity::getTaskState, CheckItemReformState.REVIEW_REFORM_STATE.getDescription());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            //整改信息，最新的当前整改人-整改时间-整改描述
            String reformNews = sceneCheckDetail.getCurrentRectificationPerson()+"-"+sdf.format(sceneCheckDetail.getReformDate())+"-"+sceneCheckDetail.getReformMsg();
            updateWrapper.set(SceneCheckDetailEntity::getReformNews,reformNews);
            //待整改每次提交，都需要把复查状态设置为待复查，
            updateWrapper.set(SceneCheckDetailEntity::getReviewResult, Integer.parseInt(ReviewState.REVIEW_STATE.getCode()));
            // 能否编辑 设置为能编辑（此字段前端组件判断）
            updateWrapper.set(SceneCheckDetailEntity::getIsModify,Integer.parseInt(ModifyState.NOT_MODIFIED_STATE.getCode()));


            Date finishDate = sceneCheckDetail.getFinishDate();
            Date nowDate = new Date();
            String nowDateStr = sdf.format(nowDate);
            String finishDateStr = sdf.format(finishDate);
            //当前时间大于完成时间 逾期状态设置为1
            if(nowDateStr.compareTo(finishDateStr) > 0){
                updateWrapper.set(SceneCheckDetailEntity::getIsOverdue, Integer.parseInt(OverdueState.OVERDUE_STATE.getCode()));
            }else if(sceneCheckDetail.getIsOverdue()==null){
                //当前整改未逾期，且逾期状态为空时，设置默认逾期状态
                updateWrapper.set(SceneCheckDetailEntity::getIsOverdue, Integer.parseInt(OverdueState.NOTOVERDUE_STATE.getCode()));
            }

            this.update(updateWrapper);

            //生成整改信息
            SceneCheckRecordEntity sceneCheckRecord=new SceneCheckRecordEntity();
            sceneCheckRecord.setPid(sceneCheckDetail.getId());
            sceneCheckRecord.setCheckId(sceneCheckDetail.getPid());
            //设置操作状态
            sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.REFORM_STATE.getCode()));
            sceneCheckRecord.setReviewPerson(sceneCheckDetail.getReviewPerson());
            sceneCheckRecord.setReviewDescribe(sceneCheckDetail.getReviewDescribe());
            sceneCheckRecord.setReviewResult(sceneCheckDetail.getReviewResult());
            sceneCheckRecord.setImgIds(sceneCheckDetail.getReformImgIds());
            sceneCheckRecord.setCheckPerson(sceneCheckDetail.getCheckPerson());
            sceneCheckRecord.setCheckItem(sceneCheckDetail.getCheckItem());
            sceneCheckRecord.setRectificationPerson(sceneCheckDetail.getCurrentRectificationPerson());
            sceneCheckRecord.setRectificationDescribe(sceneCheckDetail.getReformMsg());
            sceneCheckRecordService.save(sceneCheckRecord);

            //提交时要判断子表是否已经全部提交了，全部提交后把主表的复查状态设置为待复查
            int count = 0;
            QueryParam param = new QueryParam();
            param.getParams().put("pid",new Parameter(QueryParam.EQ,sceneCheckDetail.getPid()));
            List<SceneCheckDetailEntity> detailList = this.queryList(param);
            for (SceneCheckDetailEntity detailEntity:detailList) {
                if(detailEntity.getIsReform()==Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode())){
                    count+=1;
                }
            }
            if(count == detailList.size()){
                LambdaUpdateWrapper<SceneCheckEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.eq(SceneCheckEntity::getId,sceneCheckDetail.getPid());
                wrapper.set(SceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.REVIEW_STATE.getCode()));
                wrapper.set(SceneCheckEntity::getReviewStatus,Integer.parseInt(SubmitState.NO_SUBMITTED.getCode()));
                wrapper.set(SceneCheckEntity::getReformFinishDate ,sdf.format(new Date()));
                service.update(wrapper);
                //全部都提交后，向复查人发送消息
                SceneCheckEntity sceneCheckEntity = service.selectById(sceneCheckDetail.getPid());
                SceneCheckVO vo = BeanMapper.map(sceneCheckEntity, SceneCheckVO.class);
                String reviewId = vo.getReviewId();
                if(StringUtils.isNotBlank(reviewId)){
                    String[] review = reviewId.split(",");
                    vo.setMsgId(sceneCheckDetail.getId());
                    vo.setMsgBillCode(sceneCheckDetail.getBillCode());
                    checkMessageService.sendMsg(vo,review,NoticeEnum.REFORM_COMMIT);
                }
            }

        }

    }
}
