/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.FilterOrgIdVo;
import com.ejianc.business.progress.api.IProgressApi;
import com.ejianc.business.progress.vo.ProgressFilterVO;
import com.ejianc.business.scene.service.ISceneInspectionService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dryingManage/"})
public class DryingManageController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private ISceneInspectionService sceneInspectionService;
    @Autowired
    private IProgressApi progressApi;

    @PostMapping(value={"pageList"})
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam queryParam) throws Exception {
        Map params = queryParam.getParams();
        LinkedHashMap orderMap = queryParam.getOrderMap();
        JSONObject resp = new JSONObject();
        resp.put("size", (Object)queryParam.getPageSize());
        resp.put("current", (Object)queryParam.getPageIndex());
        SimpleDateFormat yyyyMM = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");
        if (null == params.get("checkMonth")) {
            params.put("checkMonth", new Parameter("eq", (Object)yyyyMM.format(DateUtil.subMonths((Date)new Date(), (int)1))));
        }
        FilterOrgIdVo filterOrgIdVo = new FilterOrgIdVo(InvocationInfoProxy.getOrgId(), null, null != params.get("projectStatus") ? ((Parameter)params.get("projectStatus")).getValue().toString() : null, queryParam.getSearchText(), null);
        List projects = null;
        if (null == params.get("project")) {
            CommonResponse projectMapListResp = this.projectApi.queryFilterProjects(filterOrgIdVo);
            if (!projectMapListResp.isSuccess()) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            projects = BeanMapper.mapList((Iterable)((Iterable)projectMapListResp.getData()), Map.class);
        } else {
            projects = new ArrayList<Object>();
            projects.add(JSONObject.parseObject((String)((Parameter)params.get("project")).getValue().toString(), Map.class));
        }
        if (CollectionUtils.isEmpty(projects)) {
            resp.put("total", (Object)0);
            resp.put("records", new ArrayList());
            return CommonResponse.success((Object)resp);
        }
        resp.put("total", (Object)projects.size());
        String checkDate = yyyyMMdd.format(DateUtil.endOfMonth((Date)yyyyMM.parse(((Parameter)params.get("checkMonth")).getValue().toString()))) + " 23:59:59";
        List projectIds = projects.stream().map(item -> Long.valueOf(item.get("id").toString())).collect(Collectors.toList());
        if (orderMap.containsKey("nodeArchiveRateInMonth")) {
            CommonResponse projectProgressInfoResp = this.progressApi.getProjectProgress(new ProgressFilterVO(projectIds, checkDate));
            if (!projectProgressInfoResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u9879\u76ee\u8fbe\u6210\u7387\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)projectProgressInfoResp));
            } else {
                List projectProgressInfo = (List)projectProgressInfoResp.getData();
                HashMap<String, Object> projectArchiveRateMap = new HashMap<String, Object>();
                if (CollectionUtils.isNotEmpty((Collection)projectProgressInfo)) {
                    projectArchiveRateMap.putAll(projectProgressInfo.stream().collect(Collectors.toMap(item -> item.get((Object)"projectId").toString(), item -> item.get((Object)"rate"))));
                }
                projects.stream().forEach(item -> {
                    if (projectArchiveRateMap.containsKey(item.get("id").toString())) {
                        item.put("nodeArchiveRateInMonth", new BigDecimal(projectArchiveRateMap.get(item.get("id").toString()).toString()));
                    } else {
                        item.put("nodeArchiveRateInMonth", BigDecimal.ZERO);
                    }
                });
            }
        }
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("checkMonth", ((Parameter)params.get("checkMonth")).getValue().toString());
        queryParams.put("month", Integer.valueOf(((Parameter)params.get("checkMonth")).getValue().toString().split("-")[1]));
        queryParams.put("checkDate", checkDate);
        queryParams.put("projects", projects);
        queryParams.put("pageSize", queryParam.getPageSize());
        queryParams.put("startLine", (queryParam.getPageIndex() < 1 ? 0 : queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        queryParams.put("projectIds", projectIds);
        if (!orderMap.isEmpty()) {
            StringBuilder sp = new StringBuilder();
            for (String key : orderMap.keySet()) {
                sp.append(key).append(" ").append((String)orderMap.get(key)).append(",");
            }
            queryParams.put("order", sp.substring(0, sp.length() - 1));
        }
        List<Map> pageList = this.sceneInspectionService.queryDryingList(queryParams);
        if (!orderMap.containsKey("nodeArchiveRateInMonth")) {
            CommonResponse projectProgressInfoResp = this.progressApi.getProjectProgress(new ProgressFilterVO(pageList.stream().map(item -> Long.valueOf(item.get("projectId").toString())).collect(Collectors.toList()), checkDate));
            if (!projectProgressInfoResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u9879\u76ee\u8fbe\u6210\u7387\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)projectProgressInfoResp));
            } else {
                List projectProgressInfo = (List)projectProgressInfoResp.getData();
                HashMap<String, Object> projectArchiveRateMap = new HashMap<String, Object>();
                if (CollectionUtils.isNotEmpty((Collection)projectProgressInfo)) {
                    projectArchiveRateMap.putAll(projectProgressInfo.stream().collect(Collectors.toMap(item -> item.get((Object)"projectId").toString(), item -> item.get((Object)"rate"))));
                }
                pageList.stream().forEach(item -> {
                    if (projectArchiveRateMap.containsKey(item.get("projectId").toString())) {
                        item.put("nodeArchiveRateInMonth", projectArchiveRateMap.get(item.get("projectId").toString()));
                    } else {
                        item.put("nodeArchiveRateInMonth", 0);
                    }
                });
            }
        }
        resp.put("records", pageList);
        return CommonResponse.success((Object)resp);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) throws Exception {
        Map params = queryParam.getParams();
        LinkedHashMap orderMap = queryParam.getOrderMap();
        SimpleDateFormat yyyyMM = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");
        List<Object> pageList = new ArrayList();
        if (null == params.get("checkMonth")) {
            params.put("checkMonth", new Parameter("eq", (Object)yyyyMM.format(DateUtil.subMonths((Date)new Date(), (int)1))));
        }
        FilterOrgIdVo filterOrgIdVo = new FilterOrgIdVo(InvocationInfoProxy.getOrgId(), null, null != params.get("projectStatus") ? ((Parameter)params.get("projectStatus")).getValue().toString() : null, queryParam.getSearchText(), null);
        List projects = null;
        if (null == params.get("project")) {
            CommonResponse projectMapListResp = this.projectApi.queryFilterProjects(filterOrgIdVo);
            if (!projectMapListResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            projects = BeanMapper.mapList((Iterable)((Iterable)projectMapListResp.getData()), Map.class);
        } else {
            projects = new ArrayList<Object>();
            projects.add(JSONObject.parseObject((String)((Parameter)params.get("project")).getValue().toString(), Map.class));
        }
        if (CollectionUtils.isNotEmpty(projects)) {
            String checkDate = yyyyMMdd.format(DateUtil.endOfMonth((Date)yyyyMM.parse(((Parameter)params.get("checkMonth")).getValue().toString()))) + " 23:59:59";
            List projectIds = projects.stream().map(item -> Long.valueOf(item.get("id").toString())).collect(Collectors.toList());
            if (orderMap.containsKey("nodeArchiveRateInMonth")) {
                CommonResponse projectProgressInfoResp = this.progressApi.getProjectProgress(new ProgressFilterVO(projectIds, checkDate));
                if (!projectProgressInfoResp.isSuccess()) {
                    this.logger.error("\u67e5\u8be2\u9879\u76ee\u8fbe\u6210\u7387\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)projectProgressInfoResp));
                } else {
                    List projectProgressInfo = (List)projectProgressInfoResp.getData();
                    HashMap<String, Object> projectArchiveRateMap = new HashMap<String, Object>();
                    if (CollectionUtils.isNotEmpty((Collection)projectProgressInfo)) {
                        projectArchiveRateMap.putAll(projectProgressInfo.stream().collect(Collectors.toMap(item -> item.get((Object)"projectId").toString(), item -> item.get((Object)"rate"))));
                    }
                    projects.stream().forEach(item -> {
                        if (projectArchiveRateMap.containsKey(item.get("id").toString())) {
                            item.put("nodeArchiveRateInMonth", new BigDecimal(projectArchiveRateMap.get(item.get("id").toString()).toString()));
                        } else {
                            item.put("nodeArchiveRateInMonth", BigDecimal.ZERO);
                        }
                    });
                }
            }
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("checkMonth", ((Parameter)params.get("checkMonth")).getValue().toString());
            queryParams.put("month", Integer.valueOf(((Parameter)params.get("checkMonth")).getValue().toString().split("-")[1]));
            queryParams.put("checkDate", checkDate);
            queryParams.put("projects", projects);
            queryParams.put("projectIds", projectIds);
            if (!orderMap.isEmpty()) {
                StringBuilder sp = new StringBuilder();
                for (String key : orderMap.keySet()) {
                    sp.append(key).append(" ").append((String)orderMap.get(key)).append(",");
                }
                queryParams.put("order", sp.substring(0, sp.length() - 1));
            }
            pageList = this.sceneInspectionService.queryDryingList(queryParams);
            if (!orderMap.containsKey("nodeArchiveRateInMonth")) {
                CommonResponse projectProgressInfoResp = this.progressApi.getProjectProgress(new ProgressFilterVO(pageList.stream().map(item -> Long.valueOf(item.get("projectId").toString())).collect(Collectors.toList()), checkDate));
                if (!projectProgressInfoResp.isSuccess()) {
                    this.logger.error("\u67e5\u8be2\u9879\u76ee\u8fbe\u6210\u7387\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)projectProgressInfoResp));
                } else {
                    List projectProgressInfo = (List)projectProgressInfoResp.getData();
                    HashMap<String, Object> projectArchiveRateMap = new HashMap<String, Object>();
                    if (CollectionUtils.isNotEmpty((Collection)projectProgressInfo)) {
                        projectArchiveRateMap.putAll(projectProgressInfo.stream().collect(Collectors.toMap(item -> item.get((Object)"projectId").toString(), item -> item.get((Object)"rate"))));
                    }
                    pageList.stream().forEach(item -> {
                        if (projectArchiveRateMap.containsKey(item.get("projectId").toString())) {
                            item.put("nodeArchiveRateInMonth", projectArchiveRateMap.get(item.get("projectId").toString()));
                        } else {
                            item.put("nodeArchiveRateInMonth", 0);
                        }
                    });
                }
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", pageList);
        ExcelExport.getInstance().exportWithTrans("SceneDryingManage-export.xlsx", beans, response);
    }
}

