package com.ejianc.business.scene.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.scene.bean.SceneInspectionDetailEntity;
import com.ejianc.business.scene.service.ISceneInspectionDetailService;
import com.ejianc.business.scene.vo.SceneInspectionDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.scene.bean.SceneInspectionEntity;
import com.ejianc.business.scene.service.ISceneInspectionService;
import com.ejianc.business.scene.vo.SceneInspectionVO;

/**
 * 巡检表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sceneInspection")
public class SceneInspectionController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SCENE_INSPECTION";//此处需要根据实际修改

    @Autowired
    private ISceneInspectionService service;
    @Autowired
    private ISceneInspectionDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneInspectionVO> saveOrUpdate(@RequestBody SceneInspectionVO saveOrUpdateVO) {
        Long id = saveOrUpdateVO.getId();
        ArrayList<Integer> billState = new ArrayList<>();
        billState.add(0);
        billState.add(2);
        billState.add(5);
        LambdaQueryWrapper<SceneInspectionEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SceneInspectionEntity::getTenantId, InvocationInfoProxy.getTenantid());
        queryWrapper.eq(SceneInspectionEntity::getProjectId, saveOrUpdateVO.getProjectId());
        queryWrapper.in(SceneInspectionEntity::getBillState, billState);
        queryWrapper.ne(id != null, SceneInspectionEntity::getId, id);
        int count = service.count(queryWrapper);
        if (count > 0) {
            throw new BusinessException("该项目存在自由态或审批中的单据，不可新增！");
        }
    	SceneInspectionEntity entity = BeanMapper.map(saveOrUpdateVO, SceneInspectionEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SceneInspectionVO vo = BeanMapper.map(entity, SceneInspectionVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneInspectionVO> queryDetail(Long id) {
    	SceneInspectionEntity entity = service.selectById(id);
    	SceneInspectionVO vo = BeanMapper.map(entity, SceneInspectionVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SceneInspectionVO> vos) {
        service.removeByIds(vos.stream().map(SceneInspectionVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SceneInspectionVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("inspectionUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<SceneInspectionEntity> page = service.queryPage(param,false);
        IPage<SceneInspectionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneInspectionVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * 校验该组织是否已做单据
     * @param
     * @return
     */
    @GetMapping(value = "projectCheck")
    @ResponseBody
    public CommonResponse<String> projectCheck(@RequestParam(value = "projectId") Long projectId,
                                           @RequestParam(value = "billId", required = false) Long billId) {
        QueryWrapper<SceneInspectionEntity> query = new QueryWrapper<>();
        ArrayList<Integer> billState = new ArrayList<>();
        billState.add(0);
        billState.add(2);
        billState.add(5);
        if(billId!=null){
            query.notIn("id", billId);
        }
        query.eq("project_id", projectId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.in("bill_state", billState);
        List<SceneInspectionEntity> inspectionEntities = service.list(query);
        if(CollectionUtils.isNotEmpty(inspectionEntities)) {
            return CommonResponse.error("该项目存在自由态或审批中的单据，不可新增！");
        }
        return CommonResponse.success("该项目可以制单！");
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("inspectionUserName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SceneInspectionEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<SceneInspectionVO> sceneInspectionVOS = BeanMapper.mapList(list, SceneInspectionVO.class);
        if (CollectionUtils.isNotEmpty(sceneInspectionVOS)) {
            sceneInspectionVOS.forEach(t -> {
                t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", sceneInspectionVOS);
        ExcelExport.getInstance().export("SceneInspection-export.xlsx", beans, response);
    }

    /**
     * 导出巡检内容
     * @param sceneInspectionVO
     * @param response
     */
    @PostMapping("exportInspectionDetailList")
    public void exportInspectionDetailList(@RequestBody SceneInspectionVO sceneInspectionVO, HttpServletResponse response) {
        QueryWrapper<SceneInspectionDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("inspection_id", sceneInspectionVO.getId());
        List<SceneInspectionDetailEntity> list = detailService.list(queryWrapper);
        Map<String, Object> beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("inspection-detail-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refSceneInspectionData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SceneInspectionVO>> refSceneInspectionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SceneInspectionEntity> page = service.queryPage(param,false);
        IPage<SceneInspectionVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneInspectionVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
