package com.ejianc.business.scene.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.scene.bean.SceneSafetyCheckCategoryEntity;
import com.ejianc.business.scene.service.ISceneSafetyCheckCategoryService;
import com.ejianc.business.scene.service.ISceneSafetyCheckItemService;
import com.ejianc.business.scene.vo.SceneSafetyCheckCategoryVO;
import com.ejianc.business.scene.vo.SceneSafetyCheckItemVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 资源管理-安全检查分类表
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("sceneSafetyCheckCategory")
public class SceneSafetyCheckCategoryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SCENE_SAFETY_CHECK_CATEGORY";

    @Autowired
    private ISceneSafetyCheckCategoryService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISceneSafetyCheckItemService checkItemService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<SceneSafetyCheckCategoryVO> saveOrUpdate(@RequestBody SceneSafetyCheckCategoryVO saveOrUpdateVO) {
        SceneSafetyCheckCategoryEntity entity = null;
        if(saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0){
            saveOrUpdateVO.setId(IdWorker.getId());
            entity = BeanMapper.map(saveOrUpdateVO, SceneSafetyCheckCategoryEntity.class);
            if(StringUtils.isBlank(saveOrUpdateVO.getCode())) {
                //编码为空
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setCode(billCode.getData());
                }else{
                    return CommonResponse.success("网络异常， 编码生成失败， 请稍后再试");
                }
            } else {
                SceneSafetyCheckCategoryEntity codeData = service.queryByCode(saveOrUpdateVO.getCode());
                if(codeData != null ){
                    return CommonResponse.error("分类编码已存在,请重新填写");
                }
            }
            if(null == saveOrUpdateVO.getEnabled()) {
                //默认启用
                entity.setEnabled(1);
            }
            //设置内码
            if(null != saveOrUpdateVO.getParentId()) {
                SceneSafetyCheckCategoryEntity parent = service.selectById(saveOrUpdateVO.getParentId());
                entity.setInnerCode(parent.getInnerCode() + "|" + saveOrUpdateVO.getId());
            } else {
                entity.setInnerCode(saveOrUpdateVO.getId().toString());
            }
        } else {
            SceneSafetyCheckCategoryEntity codeData = service.queryByCode(saveOrUpdateVO.getCode());
            if(codeData != null && !codeData.getId().equals(saveOrUpdateVO.getId())){
                return CommonResponse.error("分类编码已存在,请重新填写");
            }
            entity = service.selectById(saveOrUpdateVO.getId());
            entity.setEnabled(saveOrUpdateVO.getEnabled());
            entity.setCode(saveOrUpdateVO.getCode());
            entity.setName(saveOrUpdateVO.getName());
            entity.setDescription(saveOrUpdateVO.getDescription());
            entity.setSequence(saveOrUpdateVO.getSequence());
        }
        service.saveOrUpdate(entity, false);
        SceneSafetyCheckCategoryVO vo = BeanMapper.map(entity, SceneSafetyCheckCategoryVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneSafetyCheckCategoryVO> queryDetail(Long id) {
    	SceneSafetyCheckCategoryEntity entity = service.selectById(id);
    	SceneSafetyCheckCategoryVO vo = BeanMapper.map(entity, SceneSafetyCheckCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if(ListUtil.isNotEmpty(ids)){
            //分类下有档案项了不允许删除
            List<SceneSafetyCheckItemVO> materialList = checkItemService.queryListByCategoryId(ids);
            if(CollectionUtils.isNotEmpty(materialList)) {
                Set<String> categoryNames = materialList.stream().map(SceneSafetyCheckItemVO::getCategoryName).collect(Collectors.toSet());
                return CommonResponse.error("分类【" + StringUtils.join(categoryNames, ",") + "】下检查项，不允许删除");
            }

            //如果分类有子节点并且所有子节点也包含在删除项内，允许删除
            List<SceneSafetyCheckCategoryEntity> children = service.queryListByPid(ids);
            if(CollectionUtils.isNotEmpty(children)) {
                List<SceneSafetyCheckCategoryEntity> childIds = children.stream().filter(item -> !ids.contains(item.getId())).collect(Collectors.toList());
                if(CollectionUtils.isNotEmpty(childIds)) {
                    return CommonResponse.error("待删除分类下有子分类不允许删除");
                }
            }
        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        Map<String,Object> condition = new HashMap<>();
        for(Map.Entry<String, Parameter> entry:param.getParams().entrySet()) {
            condition.put(entry.getKey(), entry.getValue().getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<SceneSafetyCheckCategoryVO> dataList = service.queryList(condition);
        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l-> {
            if(l.get("leafFlag").equals(false)){
                l.put("children", new ArrayList<>());
            }
        });

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success(jsonObject);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 更新父节点状态，同时更新子节点状态
     *
     * @return
     */
    @RequestMapping(value = "/updateEnabledStatus", method = RequestMethod.POST)
    public CommonResponse<String> updateEnabled(@RequestBody SceneSafetyCheckCategoryVO saveOrUpdateVO) {
        SceneSafetyCheckCategoryEntity dbEntity = service.selectById(saveOrUpdateVO.getId());
        dbEntity.setEnabled(saveOrUpdateVO.getEnabled());
        service.saveOrUpdate(dbEntity, false);
        return CommonResponse.success("更新成功");
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SceneSafetyCheckCategoryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SceneSafetyCheckCategory-export.xlsx", beans, response);
    }

    @GetMapping(value = "/lazyCategoryTree")
    public List<Map<String, Object>> lazyCategoryTree(@RequestParam(required = false) String condition,
                                                      @RequestParam(required = false) Long pid,
                                                      @RequestParam(required = false) String searchText) {

        Map<String,Object> params = new HashMap<>();
        params.put("tenantId", InvocationInfoProxy.getTenantid());
        if(StringUtils.isNotBlank(searchText)) {
            params.put("searchText", searchText);
        }
        if(null != pid) {
            params.put("parentId", pid);
        }

        List<SceneSafetyCheckCategoryVO> dataList = service.queryList(params);
        List<Long> parentIds = dataList.stream().map(SceneSafetyCheckCategoryVO::getId).collect(Collectors.toList());
        List<Map> map = BeanMapper.mapList(dataList, Map.class);
        map.forEach(l-> {
            if(l.get("leafFlag").equals(false)){
                l.put("children", new ArrayList<>());
            } else {
                l.put("children", null);
            }
        });
        if (null != pid && parentIds.size()>0){
            params.remove("parentId");
            params.put("parentIds", parentIds);
            List<SceneSafetyCheckCategoryVO> dataLists = service.queryList(params);
            List<Map> map2 = BeanMapper.mapList(dataLists, Map.class);
            map.addAll(map2);
        }
        return ResultAsTree.createTreeData(map);
    }

    @RequestMapping(value = "/download")
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "safety-check-category-import.xlsx", "安全检查分类导入模板");
    }

    @PostMapping(value = "/excelImport")
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request ) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;

        List<SceneSafetyCheckCategoryVO> successList = new ArrayList<>();
        List<SceneSafetyCheckCategoryVO> processList = new ArrayList<>();
        List<SceneSafetyCheckCategoryVO> errorList = new ArrayList<>();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("分类数据超过10000条，请分批上传！");
            }
            Map<String, SceneSafetyCheckCategoryVO> codeMapCache = new HashMap<>();
            SceneSafetyCheckCategoryVO importVo = null;
            for(int i = 0;i < result.size(); i++) {
                List<String> datas = result.get(i);
                importVo = new SceneSafetyCheckCategoryVO();
                importVo.setId(com.ejianc.support.idworker.util.IdWorker.getId());
                importVo.setCode(datas.get(0));
                importVo.setParentCode(datas.get(1));
                importVo.setName(datas.get(2));
                if(StringUtils.isBlank(datas.get(0))){
                    importVo.setDescription("分类编码为空！");
                    errorList.add(importVo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(2))){
                    importVo.setDescription("分类名称为空！");
                    errorList.add(importVo);
                    continue;
                }
                if(codeMapCache.containsKey(importVo.getCode())) {
                    importVo.setDescription("分类名称重复！");
                    errorList.add(importVo);
                    continue;
                }

                importVo.setId(IdWorker.getId());
                importVo.setEnabled(1);
                importVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                importVo.setCreateTime(new Date());
                importVo.setTenantId(InvocationInfoProxy.getTenantid());
                processList.add(importVo);
                codeMapCache.put(importVo.getCode(), importVo);
            }

            if(ListUtil.isNotEmpty(processList)){
                //检查编码是否重复
                List<SceneSafetyCheckCategoryEntity> codeList = service.queryByCodes(new ArrayList<>(codeMapCache.keySet()));
                Set<String> pCodes = processList.stream().map(SceneSafetyCheckCategoryVO::getParentCode).collect(Collectors.toSet());
                Map<String, SceneSafetyCheckCategoryEntity> parentCodeMap = new HashMap<>();
                if(CollectionUtils.isNotEmpty(pCodes)) {
                    List<SceneSafetyCheckCategoryEntity> parentListByCode = service.queryByCodes(new ArrayList<>(pCodes));
                    if(CollectionUtils.isNotEmpty(parentListByCode)) {
                        parentCodeMap = parentListByCode.stream().collect(Collectors.toMap(SceneSafetyCheckCategoryEntity::getCode, item -> item));
                    }
                }

                if(CollectionUtils.isNotEmpty(codeList)) {
                    for(SceneSafetyCheckCategoryEntity repeatCode : codeList) {
                        importVo = codeMapCache.get(repeatCode.getCode());
                        codeMapCache.remove(repeatCode.getCode());
                        processList.remove(importVo);
                        importVo.setDescription("分类名称重复！");
                        errorList.add(importVo);
                        continue;
                    }
                }

                for(SceneSafetyCheckCategoryVO item : processList) {
                    if(StringUtils.isNotBlank(item.getParentCode())) {
                        if(parentCodeMap.containsKey(item.getParentCode())) {
                            item.setInnerCode(parentCodeMap.get(item.getParentCode()).getInnerCode() + "|" + item.getId());
                            item.setParentId(parentCodeMap.get(item.getParentCode()).getId());
                        } else if(codeMapCache.containsKey(item.getParentCode())) {
                            item.setInnerCode(codeMapCache.get(item.getParentCode()).getInnerCode() + "|" + item.getId());
                            item.setParentId(codeMapCache.get(item.getParentCode()).getId());
                        }

                        if(null == item.getParentId()) {
                            item.setDescription("父分类编码对应分类不存在！");
                            errorList.add(importVo);
                            continue;
                        }
                    } else {
                        item.setInnerCode(item.getId().toString());
                    }

                    successList.add(item);
                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @PostMapping(value = "/saveImportExcelCategory")
    public CommonResponse<String> saveImportExcelCategory(@RequestBody List<SceneSafetyCheckCategoryVO> saveImportVos) {
        if(ListUtil.isEmpty(saveImportVos)){
            return CommonResponse.error("导入的数据为空！");
        }
        List<SceneSafetyCheckCategoryEntity> saveList = BeanMapper.mapList(saveImportVos, SceneSafetyCheckCategoryEntity.class);
        service.saveOrUpdateBatch(saveList, saveList.size(), false);
        return CommonResponse.success("保存成功！");
    }
}
