package com.ejianc.business.scientific.result;


import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 工法管理-待评审
 * 
 * @author generator
 * 
 */
public class MethodApproveVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Integer billState; // 单据状态（审批必须字段）
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private String memo; // 评审意见
    private String methodName; // 工法名称
    private Long methodId; // 工法id
    private Long methodPersonId; //  工法完成人id
    private String methodPersonName; // methodPersonName
    private Long parentOrgId; // 责任单位id
    private String parentOrgName; // parentOrgName
    private Integer methodType; // 类别  1- 土木工程 2-房屋建筑工程 3-工业安装工程
    private String approveId; // 评审专家id
    private String approveName; // 评审专家name
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date approveDate; // 评审日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date expirationDate; // 评审截止日期
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // orgName
    private String billStateName; // 单据状态（审批必须字段）
    private String methodTypeName; // 类别  1- 土木工程 2-房屋建筑工程 3-工业安装工程
    private Integer approveStatus; //  1-未评审 2- 已评审
    private Integer approveStatusPc; //  1-未评审 2- 已评审 3-未评审(还有X天到期) 4-未评审(已到期)
    private String approveStatusName; //  1-未评审 2- 已评审
    private Long methodApproveDetailId; // 工法评审详情id

    public Integer getApproveStatusPc() {
        return approveStatusPc;
    }

    public void setApproveStatusPc(Integer approveStatusPc) {
        this.approveStatusPc = approveStatusPc;
    }

    public Long getMethodApproveDetailId() {
        return methodApproveDetailId;
    }

    public void setMethodApproveDetailId(Long methodApproveDetailId) {
        this.methodApproveDetailId = methodApproveDetailId;
    }
    public String getApproveStatusName() {
        return approveStatusName;
    }

    public void setApproveStatusName(String approveStatusName) {
        this.approveStatusName = approveStatusName;
    }

    public Integer getApproveStatus() {
        return approveStatus;
    }

    public void setApproveStatus(Integer approveStatus) {
        this.approveStatus = approveStatus;
    }

    public String getMethodTypeName() {
        return methodTypeName;
    }

    public void setMethodTypeName(String methodTypeName) {
        this.methodTypeName = methodTypeName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getMethodName() {
        return methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }
    public Long getMethodId() {
        return methodId;
    }

    public void setMethodId(Long methodId) {
        this.methodId = methodId;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getMethodPersonId() {
        return methodPersonId;
    }
    @ReferDeserialTransfer
    public void setMethodPersonId(Long methodPersonId) {
        this.methodPersonId = methodPersonId;
    }
    public String getMethodPersonName() {
        return methodPersonName;
    }

    public void setMethodPersonName(String methodPersonName) {
        this.methodPersonName = methodPersonName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getMethodType() {
        return methodType;
    }

    public void setMethodType(Integer methodType) {
        this.methodType = methodType;
    }
    public String getApproveId() {
        return approveId;
    }

    public void setApproveId(String approveId) {
        this.approveId = approveId;
    }
    public String getApproveName() {
        return approveName;
    }

    public void setApproveName(String approveName) {
        this.approveName = approveName;
    }
    public Date getApproveDate() {
        return approveDate;
    }

    public void setApproveDate(Date approveDate) {
        this.approveDate = approveDate;
    }
    public Date getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }
    
}
