package com.ejianc.business.scientific.result.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scientific.result.MethodApproveVO;
import com.ejianc.business.scientific.result.bean.MethodApproveEntity;
import com.ejianc.business.scientific.result.service.IMethodApproveService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 工法管理-待评审
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("methodApprove")
public class MethodApproveController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "METHOD_APPROVE";//此处需要根据实际修改

    @Autowired
    private IMethodApproveService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MethodApproveVO> saveOrUpdate(@RequestBody MethodApproveVO saveOrUpdateVO) {
    	MethodApproveEntity entity = BeanMapper.map(saveOrUpdateVO, MethodApproveEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	MethodApproveVO vo = BeanMapper.map(entity, MethodApproveVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MethodApproveVO> queryDetail(Long id) {
    	MethodApproveEntity entity = service.selectById(id);
    	MethodApproveVO vo = BeanMapper.map(entity, MethodApproveVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MethodApproveVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MethodApproveVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MethodApproveVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    @GetMapping("queryMethodApproveList")
    @ResponseBody
    public CommonResponse<List<MethodApproveVO>> queryMethodApproveList(@RequestParam("methodApproveDetailId")Long methodApproveDetailId){

        LambdaQueryWrapper<MethodApproveEntity> lambda = new LambdaQueryWrapper();
        lambda.eq(MethodApproveEntity::getMethodApproveDetailId, methodApproveDetailId);
        List<MethodApproveEntity> methodApproveEntities = service.list(lambda);
        List<MethodApproveVO> methodApproveVOS = BeanMapper.mapList(methodApproveEntities, MethodApproveVO.class);
        return CommonResponse.success("查询成功",methodApproveVOS);
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MethodApproveVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("methodName");
        fuzzyFields.add("methodPersonName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        Long userId = userContextCache.getUserId();
        param.getParams().put("approveId", new Parameter(QueryParam.EQ, userId));

        IPage<MethodApproveEntity> page = service.queryPage(param,false);
        IPage<MethodApproveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<MethodApproveVO> methodApproveVOS = BeanMapper.mapList(page.getRecords(), MethodApproveVO.class);
        for (MethodApproveVO e : methodApproveVOS){
            long days = getDays(new Date(), e.getExpirationDate());
            if (e.getApproveStatus().equals(1)){
                e.setApproveStatusName("未评审");
                e.setApproveStatusPc(1);
            }
            if (e.getApproveStatus().equals(2)){
                e.setApproveStatusName("已评审");
                e.setApproveStatusPc(2);
            }
            if (e.getApproveStatus().equals(1) && days <= 10 && days >0){
                String s = "未评审"+ "(还有" + days + "天到期)";
                e.setApproveStatusName(s);
                e.setApproveStatusPc(3);
            }
            if (e.getApproveStatus().equals(1) && days <= 0){
                String s = "未评审(已到期)";
                e.setApproveStatusName(s);
                e.setApproveStatusPc(4);
            }

        }
        pageData.setRecords(methodApproveVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    private long getDays(Date date, Date date2) {
        LocalDate localDate1 = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = date2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

        long diffDays = Math.abs(localDate2.toEpochDay() - localDate1.toEpochDay());
        return diffDays;
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("methodName");
        fuzzyFields.add("methodPersonName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MethodApproveEntity> list = service.queryList(param);

        Map<String, Object> beans = new HashMap<>();
        List<MethodApproveVO> methodApplyVOS = BeanMapper.mapList(list, MethodApproveVO.class);
        methodApplyVOS.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
//            1- 土木工程 2-房屋建筑工程 3-工业安装工程
            if (e.getMethodType().equals(1)) {
                e.setMethodTypeName("土木工程");
            }
            if (e.getMethodType().equals(2)) {
                e.setMethodTypeName("房屋建筑工程");
            }
            if (e.getMethodType().equals(3)) {
                e.setMethodTypeName("工业安装工程");
            }
            long days = getDays(new Date(), e.getExpirationDate());
            if (e.getApproveStatus().equals(1)){
                e.setApproveStatusName("未评审");
            }
            if (e.getApproveStatus().equals(2)){
                e.setApproveStatusName("已评审");
            }
            if (e.getApproveStatus().equals(1) && days <= 10){
                String s = "未评审"+ "(还有" + days + "天到期)";
                e.setApproveStatusName(s);
            }


        });
        beans.put("records", methodApplyVOS);
        ExcelExport.getInstance().export("MethodApprove-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refMethodApproveData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MethodApproveVO>> refMethodApproveData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MethodApproveEntity> page = service.queryPage(param,false);
        IPage<MethodApproveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MethodApproveVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
