package com.ejianc.business.scientific.result.service.impl;

import com.ejianc.business.scientific.result.MethodApproveVO;
import com.ejianc.business.scientific.result.bean.MethodApproveEntity;
import com.ejianc.business.scientific.result.bean.MethodReviewDetailEntity;
import com.ejianc.business.scientific.result.bean.MethodReviewEntity;
import com.ejianc.business.scientific.result.service.IMethodApproveService;
import com.ejianc.business.scientific.result.service.IMethodReviewService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;
import java.util.stream.Collectors;

@Service("methodReview") 
public class MethodReviewBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IMethodApproveService methodApproveService;
	@Autowired
	private IMethodReviewService methodReviewService;

	private static final String BILL_CODE = "METHOD_APPROVE";//此处需要根据实际修改

	@Autowired
	private IBillCodeApi billCodeApi;





	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//推送待评审数据
		MethodReviewEntity methodReviewEntity = methodReviewService.selectById(billId);
		methodReviewEntity.setReviewStatus(1);
		List<MethodReviewDetailEntity> methodReviewDetailList = methodReviewEntity.getMethodReviewDetailList();
		List<MethodApproveEntity> methodApproveEntityList = new ArrayList<>();
		for (MethodReviewDetailEntity methodReviewDetailEntity : methodReviewDetailList){
			List<Long> approveIds = Optional.ofNullable(methodReviewDetailEntity.getApproveId())
					.map(str -> Arrays.stream(str.split(","))
							.map(String::trim)
							.filter(s -> !s.isEmpty())
							.map(s -> {
								try {
									return Long.parseLong(s);
								} catch (NumberFormatException e) {
									// 静默忽略非法字符
									return null;
								}
							})
							.filter(Objects::nonNull)
							.collect(Collectors.toList()))
					.orElse(Collections.emptyList());

			for (Long approveId : approveIds){
				MethodApproveEntity methodApproveEntity = BeanMapper.map(methodReviewDetailEntity, MethodApproveEntity.class);
				methodApproveEntity.setId(IdWorker.getId());
				methodApproveEntity.setCreateTime(new Date());
				methodApproveEntity.setEmployeeId(methodReviewEntity.getEmployeeId());
				methodApproveEntity.setEmployeeName(methodReviewEntity.getEmployeeName());
				methodApproveEntity.setApproveId(approveId.toString());
				methodApproveEntity.setMethodApproveDetailId(methodReviewDetailEntity.getId());
//				methodApproveEntity.setApproveName();
				methodApproveEntity.setApproveStatus(1);
				MethodApproveVO methodApproveVO = BeanMapper.map(methodApproveEntity, MethodApproveVO.class);

				BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),methodApproveVO);
				CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
				if(billCode.isSuccess()) {
					methodApproveEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
				}else{
					throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
				}

				methodApproveEntityList.add(methodApproveEntity);
			}
		}
		methodApproveService.saveBatch(methodApproveEntityList);

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("已生成下游单据,不能弃审");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
