package com.ejianc.business.scientific.sci.service.impl;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scientific.sci.mapper.CheckAcceptMapper;
import com.ejianc.business.scientific.sci.bean.CheckAcceptEntity;
import com.ejianc.business.scientific.sci.service.ICheckAcceptService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 科研项目验收
 * 
 * @author generator
 * 
 */
@Service("checkAcceptService")
public class CheckAcceptServiceImpl extends BaseServiceImpl<CheckAcceptMapper, CheckAcceptEntity> implements ICheckAcceptService{

    @Override
    public String validateProjectId(Long projectId, Long id, String operation) {
        //同一个项目只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        if(id != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<CheckAcceptEntity> list = super.queryList(queryParam, false);
        List<CheckAcceptEntity> freeList = list.stream().filter(x->1 !=x.getBillState() && 3 !=x.getBillState()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(freeList)) {
            throw new BusinessException("该科研项目存在非生效态的验收单，不允许" + operation + "!");
        }
        return "校验成功！";
    }
}
