package com.ejianc.business.scientific.sci.service.impl;

import com.ejianc.business.scientific.sci.bean.SciProjectChangeEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectHistoryEntity;
import com.ejianc.business.scientific.sci.cons.CommonConstant;
import com.ejianc.business.scientific.sci.service.ISciProjectChangeService;
import com.ejianc.business.scientific.sci.service.ISciProjectHistoryService;
import com.ejianc.business.scientific.sci.service.ISciProjectService;
import com.ejianc.business.scientific.sci.utils.EntityUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("sciProjectChange") 
public class SciProjectChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ISciProjectChangeService service;

	@Autowired
	private ISciProjectService oldService;

	@Autowired
	private ISciProjectHistoryService historyService;

	@Autowired
	private IAttachmentApi attachmentApi;

    @Autowired
    private IBillTypeApi billTypeApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("--------------变更审批通过，处理业务");
		SciProjectChangeEntity change = service.selectById(billId);
		SciProjectEntity old = oldService.selectById(change.getSourceId());

		logger.info("--------------同步原单据到历史表");
		SciProjectHistoryEntity history = BeanMapper.map(old, SciProjectHistoryEntity.class);
		Long historyId = IdWorker.getId();
		history = EntityUtil.clearInvalidEntity(history, SciProjectHistoryEntity.class);
		history.setId(historyId);
		historyService.saveOrUpdate(history, false);

		// 将原单据附件复制到历史记录
		attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(old.getId()), CommonConstant.IN_SCI_PROJECT, CommonConstant.FILE_TYPE,
				String.valueOf(history.getId()), CommonConstant.IN_SCI_PROJECT, CommonConstant.FILE_TYPE);

		logger.info("--------------同步变更到原单据");
		old.setChangeStatus(CommonConstant.CHANGE_OVER);
		old.setChangeVersion(change.getChangeVersion());
		old.setChangeReason(change.getChangeReason());
		old.setChangeDate(change.getChangeDate());
		// 表头变更字段需回写到原单据
		old.setName(change.getName());
		old.setManagerId(change.getManagerId());
		old.setManagerName(change.getManagerName());
		old.setPeriod(change.getPeriod());
		old.setBudgetMny(change.getBudgetMny());
		old.setPlanHour(change.getPlanHour());
		old.setEmployeeId(change.getEmployeeId());
		old.setEmployeeName(change.getEmployeeName());
		old.setDeptId(change.getDeptId());
		old.setDeptName(change.getDeptName());

		// 全量替换子表
		EntityUtil.syncDetail(old, change, "sourceId");
		oldService.saveOrUpdate(old, false);

		logger.info("--------------处理变更附件");
		// 变更附件复制到原单据，同步删除附件
		attachmentApi.copyFiles(String.valueOf(billId), billTypeCode, CommonConstant.FILE_TYPE,
				String.valueOf(old.getId()), CommonConstant.IN_SCI_PROJECT, CommonConstant.FILE_TYPE, true);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("变更单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
