package com.ejianc.business.scientific.sci.service.impl;

import com.ejianc.business.scientific.sci.bean.SciProjectEntity;
import com.ejianc.business.scientific.sci.cons.CommonConstant;
import com.ejianc.business.scientific.sci.service.ISciProjectService;
import com.ejianc.business.scientific.sci.utils.EntityUtil;
import com.ejianc.business.scientific.sci.vo.SciProjectChangeBudgetVO;
import com.ejianc.business.scientific.sci.vo.SciProjectChangeTargetVO;
import com.ejianc.business.scientific.sci.vo.SciProjectChangeUserVO;
import com.ejianc.business.scientific.sci.vo.SciProjectChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scientific.sci.mapper.SciProjectChangeMapper;
import com.ejianc.business.scientific.sci.bean.SciProjectChangeEntity;
import com.ejianc.business.scientific.sci.service.ISciProjectChangeService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 科研项目立项-变更
 * 
 * @author generator
 * 
 */
@Service("sciProjectChangeService")
public class SciProjectChangeServiceImpl extends BaseServiceImpl<SciProjectChangeMapper, SciProjectChangeEntity> implements ISciProjectChangeService{

    @Autowired
    private ISciProjectService projectService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public SciProjectChangeVO queryDetailChange(Long id) {
        SciProjectEntity entity = projectService.selectById(id);
        SciProjectChangeVO vo = BeanMapper.map(entity, SciProjectChangeVO.class);
        for (SciProjectChangeUserVO detail : vo.getUserList()) {
            detail.setSourceId(detail.getId());
            detail.setRowState("add");
            EntityUtil.clearInvalidData(detail);
        }
        for (SciProjectChangeBudgetVO detail : vo.getBudgetList()) {
            detail.setSourceId(detail.getId());
            detail.setRowState("add");
            EntityUtil.clearInvalidData(detail);
        }
        for (SciProjectChangeTargetVO detail : vo.getTargetList()) {
            detail.setSourceId(detail.getId());
            detail.setRowState("add");
            EntityUtil.clearInvalidData(detail);
        }
        vo.setSourceId(vo.getId());
        vo.setBillState(null);
        vo.setChangeReason(null);
        vo.setCode(null);
        vo.setChangeVersion(vo.getChangeVersion() == null ? 1 : vo.getChangeVersion() + 1);
        vo.setChangeDate(new Date());
        EntityUtil.clearInvalidData(vo);

        // 拷贝附件到变更单
        vo.setId(IdWorker.getId());
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), CommonConstant.IN_SCI_PROJECT, CommonConstant.FILE_TYPE,
                String.valueOf(vo.getId()), CommonConstant.IN_SCI_PROJECT_CHANGE, CommonConstant.FILE_TYPE);
        return vo;
    }

    @Override
    public List<SciProjectChangeVO> queryChangeHistory(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("sourceId", new Parameter(QueryParam.EQ, id));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getOrderMap().put("changeVersion", QueryParam.DESC);
        List<SciProjectChangeEntity> list = super.queryList(param);
        if(CollectionUtils.isEmpty(list)){
            return new ArrayList<>();
        }
        List<SciProjectChangeVO> result = BeanMapper.mapList(list, SciProjectChangeVO.class);
        for (SciProjectChangeVO vo : result) {
            String historyBillCode = vo.getCode() + "-" + (vo.getChangeVersion() - 1);
            vo.setHistoryBillCode(historyBillCode);
        }
        return result;
    }

}
