package com.ejianc.business.scientific.sci.service.impl;

import com.ejianc.business.scientific.sci.vo.SciProjectHistoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scientific.sci.mapper.SciProjectHistoryMapper;
import com.ejianc.business.scientific.sci.bean.SciProjectHistoryEntity;
import com.ejianc.business.scientific.sci.service.ISciProjectHistoryService;

import java.util.List;

/**
 * 科研项目立项-历史
 * 
 * @author generator
 * 
 */
@Service("sciProjectHistoryService")
public class SciProjectHistoryServiceImpl extends BaseServiceImpl<SciProjectHistoryMapper, SciProjectHistoryEntity> implements ISciProjectHistoryService{

    @Override
    public SciProjectHistoryVO queryDetailByChangeId(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("changeId", new Parameter(QueryParam.EQ, id));
        List<SciProjectHistoryEntity> list = super.queryList(param);
        if(CollectionUtils.isEmpty(list)){
            return new SciProjectHistoryVO();
        }
        SciProjectHistoryEntity entity = super.selectById(list.get(0).getId());
        return BeanMapper.map(entity, SciProjectHistoryVO.class);
    }
}
