package com.ejianc.business.scientific.sci.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scientific.sci.mapper.ExecuteMapper;
import com.ejianc.business.scientific.sci.bean.ExecuteEntity;
import com.ejianc.business.scientific.sci.service.IExecuteService;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 科研项目执行
 * 
 * @author generator
 * 
 */
@Service("executeService")
public class ExecuteServiceImpl extends BaseServiceImpl<ExecuteMapper, ExecuteEntity> implements IExecuteService{

    @Override
    public String validateProjectId(Long projectId, Long id, String operation) {
        //同一个项目只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        if(id != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<ExecuteEntity> list = super.queryList(queryParam, false);
        List<ExecuteEntity> freeList = list.stream().filter(x->1 !=x.getBillState() && 3 !=x.getBillState()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(freeList)) {
            throw new BusinessException("该科研项目存在非生效态的执行单，不允许" + operation + "!");
        }
        return "校验成功！";
    }
}
