/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.sci.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scientific.result.MethodApplyVO;
import com.ejianc.business.scientific.result.MethodRegisterVO;
import com.ejianc.business.scientific.result.PaperRegisterVO;
import com.ejianc.business.scientific.result.PatentRegisterVO;
import com.ejianc.business.scientific.result.ResultEvaluateVO;
import com.ejianc.business.scientific.result.SoftRegisterVO;
import com.ejianc.business.scientific.result.service.IMethodApplyService;
import com.ejianc.business.scientific.result.service.IMethodRegisterService;
import com.ejianc.business.scientific.result.service.IPaperRegisterService;
import com.ejianc.business.scientific.result.service.IPatentRegisterService;
import com.ejianc.business.scientific.result.service.IResultEvaluateService;
import com.ejianc.business.scientific.result.service.ISoftRegisterService;
import com.ejianc.business.scientific.sci.bean.SciProjectEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectUserEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectUserHourEntity;
import com.ejianc.business.scientific.sci.service.ICheckAcceptService;
import com.ejianc.business.scientific.sci.service.IExecuteService;
import com.ejianc.business.scientific.sci.service.IFeeConfirmService;
import com.ejianc.business.scientific.sci.service.ISciProjectChangeService;
import com.ejianc.business.scientific.sci.service.ISciProjectService;
import com.ejianc.business.scientific.sci.service.ISciProjectUserHourService;
import com.ejianc.business.scientific.sci.service.ISciProjectUserService;
import com.ejianc.business.scientific.sci.utils.DateUtil;
import com.ejianc.business.scientific.sci.utils.JSONUtils;
import com.ejianc.business.scientific.sci.utils.ListCallable;
import com.ejianc.business.scientific.sci.vo.CheckAcceptVO;
import com.ejianc.business.scientific.sci.vo.ExecuteVO;
import com.ejianc.business.scientific.sci.vo.FeeConfirmVO;
import com.ejianc.business.scientific.sci.vo.SciProjectChangeVO;
import com.ejianc.business.scientific.sci.vo.SciProjectVO;
import com.ejianc.business.scientific.sci.work.service.IWorkTimeService;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sciProject"})
public class SciProjectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE_IN = "IN_SCI_PROJECT";
    private static final String BILL_CODE_OUT = "OUT_SCI_PROJECT";
    @Autowired
    private ISciProjectService service;
    @Autowired
    private ISciProjectUserService userService;
    @Autowired
    private ISciProjectUserHourService hourService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISciProjectChangeService changeService;
    @Autowired
    private IExecuteService executeService;
    @Autowired
    private ICheckAcceptService checkService;
    @Autowired
    private IFeeConfirmService feeService;
    @Autowired
    private IWorkTimeService workTimeService;
    @Autowired
    private IMethodApplyService methodApplyService;
    @Autowired
    private IPatentRegisterService patentRegisterService;
    @Autowired
    private ISoftRegisterService softRegisterService;
    @Autowired
    private IPaperRegisterService paperRegisterService;
    @Autowired
    private IResultEvaluateService resultEvaluateService;
    @Autowired
    private IMethodRegisterService methodRegisterService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SciProjectVO> saveOrUpdate(@RequestBody SciProjectVO saveOrUpdateVO) {
        SciProjectVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SciProjectVO> queryDetail(Long id) {
        SciProjectEntity entity = (SciProjectEntity)((Object)this.service.selectById(id));
        if (CollectionUtils.isNotEmpty(entity.getUserList())) {
            List ids = entity.getUserList().stream().map(x -> x.getId()).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("pid", new Parameter("in", ids));
            List hourList = this.hourService.queryList(param);
            Map<Long, List<SciProjectUserHourEntity>> hourMap = hourList.stream().collect(Collectors.groupingBy(x -> x.getPid()));
            for (SciProjectUserEntity user : entity.getUserList()) {
                user.setHourList(hourMap.get(user.getId()));
            }
        }
        SciProjectVO vo = (SciProjectVO)BeanMapper.map((Object)((Object)entity), SciProjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SciProjectVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SciProjectVO sciProjectVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SciProjectVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "orgName", "name", "managerName", "employeeName", "deptName", "entrustOrg", "executeOrg"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SciProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("code", "orgName", "name", "managerName", "employeeName", "deptName", "entrustOrg", "executeOrg"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List records = BeanMapper.mapList((Iterable)list, SciProjectVO.class);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", records);
        String sourceType = null;
        if (param.getParams().containsKey("sourceType")) {
            sourceType = String.valueOf(((Parameter)param.getParams().get("sourceType")).getValue());
        }
        if ("1".equals(sourceType)) {
            ExcelExport.getInstance().exportWithTrans("SciProject-export.xlsx", beans, response);
        } else {
            ExcelExport.getInstance().exportWithTrans("OutSciProject-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/queryTypeTree"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONArray queryTypeTree() {
        JSONArray result = new JSONArray();
        JSONObject parent1 = new JSONObject();
        parent1.put("id", (Object)"1,2");
        parent1.put("name", (Object)"\u5916\u90e8\u79d1\u7814\u9879\u76ee");
        JSONArray child1 = new JSONArray();
        JSONObject child11 = new JSONObject();
        child11.put("id", (Object)"1");
        child11.put("name", (Object)"\u6a2a\u5411\u79d1\u7814\u9879\u76ee");
        child11.put("parentId", (Object)parent1.getString("id"));
        child1.add((Object)child11);
        JSONObject child12 = new JSONObject();
        child12.put("id", (Object)"2");
        child12.put("name", (Object)"\u7eb5\u5411\u79d1\u7814\u9879\u76ee");
        child12.put("parentId", (Object)parent1.getString("id"));
        child1.add((Object)child12);
        parent1.put("children", (Object)child1);
        result.add((Object)parent1);
        JSONObject parent2 = new JSONObject();
        parent2.put("id", (Object)"3,4");
        parent2.put("name", (Object)"\u5185\u90e8\u79d1\u7814\u9879\u76ee");
        JSONArray child2 = new JSONArray();
        JSONObject child21 = new JSONObject();
        child21.put("id", (Object)"3");
        child21.put("name", (Object)"\u5efa\u8bbe\u516c\u53f8\u79d1\u7814\u9879\u76ee");
        child21.put("parentId", (Object)parent2.getString("id"));
        child2.add((Object)child21);
        JSONObject child22 = new JSONObject();
        child22.put("id", (Object)"4");
        child22.put("name", (Object)"\u4e8c\u7ea7\u5355\u4f4d\u79d1\u7814\u9879\u76ee");
        child22.put("parentId", (Object)parent2.getString("id"));
        child2.add((Object)child22);
        parent2.put("children", (Object)child2);
        result.add((Object)parent2);
        return result;
    }

    @RequestMapping(value={"/refSciProjectData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SciProjectVO>> refSciProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String relyNode, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"orgId")) {
                orgId = _con.getLong("orgId");
                param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
            }
            if (_con.containsKey((Object)"range") && "up".equals(_con.getString("range"))) {
                List orgIds = ((List)this.iOrgApi.findParentsByOrgId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
                param.getParams().put("orgId", new Parameter("in", orgIds));
            }
            if (_con.containsKey((Object)"sourceType")) {
                param.getParams().put("sourceType", new Parameter("eq", (Object)_con.getString("sourceType")));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            String projectType = relyCondition.split("=")[1];
            param.getParams().put("projectType", new Parameter("in", (Object)projectType));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SciProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateProjectCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SciProjectVO> updateProjectCode(@RequestParam(value="id") Long id, @RequestParam(value="projectCode") String projectCode) {
        SciProjectEntity entity = (SciProjectEntity)((Object)this.service.selectById(id));
        entity.setProjectCode(projectCode);
        this.service.saveOrUpdate((Object)entity, false);
        SciProjectVO vo = (SciProjectVO)BeanMapper.map((Object)((Object)entity), SciProjectVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/queryAllDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryAllDetail(Long id) {
        JSONObject vo;
        JSONObject obj;
        JSONObject result = new JSONObject();
        SciProjectVO projectVO = (SciProjectVO)this.queryDetail(id).getData();
        result.put("projectVO", (Object)projectVO);
        List<SciProjectChangeVO> changeList = this.changeService.queryChangeHistory(id);
        result.put("changeList", changeList);
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)id));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        QueryParam resultParam = new QueryParam();
        resultParam.getParams().put("scientificProjectId", new Parameter("eq", (Object)id));
        resultParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        Future<JSONArray> future1 = ListCallable.excute(threadPool, param, this.executeService);
        Future<JSONArray> future2 = ListCallable.excute(threadPool, param, this.checkService);
        Future<JSONArray> future3 = ListCallable.excute(threadPool, param, this.feeService);
        Future<JSONArray> future4 = ListCallable.excute(threadPool, param, this.workTimeService);
        Future<JSONArray> future5 = ListCallable.excute(threadPool, resultParam, this.methodApplyService);
        Future<JSONArray> future6 = ListCallable.excute(threadPool, resultParam, this.patentRegisterService);
        Future<JSONArray> future7 = ListCallable.excute(threadPool, resultParam, this.softRegisterService);
        Future<JSONArray> future8 = ListCallable.excute(threadPool, resultParam, this.paperRegisterService);
        Future<JSONArray> future9 = ListCallable.excute(threadPool, resultParam, this.resultEvaluateService);
        Future<JSONArray> future10 = ListCallable.excute(threadPool, resultParam, this.methodRegisterService);
        JSONArray executeList = new JSONArray();
        JSONArray checkList = new JSONArray();
        JSONArray feeList = new JSONArray();
        JSONArray workTimeList = new JSONArray();
        JSONArray methodApplyList = new JSONArray();
        JSONArray patentRegisterList = new JSONArray();
        JSONArray softRegisterList = new JSONArray();
        JSONArray paperRegisterList = new JSONArray();
        JSONArray resultEvaluateList = new JSONArray();
        JSONArray methodRegisterList = new JSONArray();
        try {
            executeList = future1.get();
            checkList = future2.get();
            feeList = future3.get();
            workTimeList = future4.get();
            methodApplyList = future5.get();
            patentRegisterList = future6.get();
            softRegisterList = future7.get();
            paperRegisterList = future8.get();
            resultEvaluateList = future9.get();
            methodRegisterList = future10.get();
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        result.put("executeList", JSONUtils.mapList(executeList, ExecuteVO.class));
        result.put("checkList", JSONUtils.mapList(checkList, CheckAcceptVO.class));
        result.put("feeList", JSONUtils.mapList(feeList, FeeConfirmVO.class));
        result.put("workTimeList", JSONUtils.mapList(workTimeList, WorkTimeVO.class));
        result.put("methodApplyList", JSONUtils.mapList(methodApplyList, MethodApplyVO.class));
        result.put("patentRegisterList", JSONUtils.mapList(patentRegisterList, PatentRegisterVO.class));
        result.put("softRegisterList", JSONUtils.mapList(softRegisterList, SoftRegisterVO.class));
        result.put("paperRegisterList", JSONUtils.mapList(paperRegisterList, PaperRegisterVO.class));
        result.put("resultEvaluateList", JSONUtils.mapList(resultEvaluateList, ResultEvaluateVO.class));
        result.put("methodRegisterList", JSONUtils.mapList(methodRegisterList, MethodRegisterVO.class));
        BigDecimal sumApplyMny = feeList.stream().map(x -> ((JSONObject)x).getBigDecimal("applyMny")).filter(Objects::nonNull).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        result.put("budgetMny", (Object)projectVO.getBudgetMny());
        result.put("sumApplyMny", (Object)sumApplyMny);
        BigDecimal sumHour = workTimeList.stream().map(x -> ((JSONObject)x).getBigDecimal("billTotalWorkTime")).filter(Objects::nonNull).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        result.put("planHour", (Object)projectVO.getPlanHour());
        result.put("sumHour", (Object)sumHour);
        JSONArray resultList = new JSONArray();
        for (Object o : methodApplyList) {
            obj = (JSONObject)o;
            vo = new JSONObject();
            vo.put("billCode", (Object)obj.getString("billCode"));
            vo.put("id", (Object)obj.getString("id"));
            vo.put("billType", (Object)"\u5de5\u6cd5\u7533\u8bf7");
            vo.put("billName", (Object)obj.getString("methodName"));
            vo.put("employeeName", (Object)obj.getString("employeeName"));
            vo.put("createTime", (Object)DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add((Object)vo);
        }
        for (Object o : patentRegisterList) {
            obj = (JSONObject)o;
            vo = new JSONObject();
            vo.put("billCode", (Object)obj.getString("billCode"));
            vo.put("id", (Object)obj.getString("id"));
            vo.put("billType", (Object)"\u4e13\u5229");
            vo.put("billName", (Object)obj.getString("patentName"));
            vo.put("employeeName", (Object)obj.getString("employeeName"));
            vo.put("createTime", (Object)DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add((Object)vo);
        }
        for (Object o : softRegisterList) {
            obj = (JSONObject)o;
            vo = new JSONObject();
            vo.put("billCode", (Object)obj.getString("billCode"));
            vo.put("id", (Object)obj.getString("id"));
            vo.put("billType", (Object)"\u8f6f\u8457");
            vo.put("billName", (Object)obj.getString("softName"));
            vo.put("employeeName", (Object)obj.getString("employeeName"));
            vo.put("createTime", (Object)DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add((Object)vo);
        }
        for (Object o : paperRegisterList) {
            obj = (JSONObject)o;
            vo = new JSONObject();
            vo.put("billCode", (Object)obj.getString("billCode"));
            vo.put("id", (Object)obj.getString("id"));
            vo.put("billType", (Object)"\u8bba\u6587");
            vo.put("billName", (Object)obj.getString("paperName"));
            vo.put("employeeName", (Object)obj.getString("employeeName"));
            vo.put("createTime", (Object)DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add((Object)vo);
        }
        for (Object o : resultEvaluateList) {
            obj = (JSONObject)o;
            vo = new JSONObject();
            vo.put("billCode", (Object)obj.getString("billCode"));
            vo.put("id", (Object)obj.getString("id"));
            vo.put("billType", (Object)"\u6210\u679c\u8bc4\u4ef7");
            vo.put("billName", (Object)obj.getString("resultName"));
            vo.put("employeeName", (Object)obj.getString("employeeName"));
            vo.put("createTime", (Object)DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add((Object)vo);
        }
        for (Object o : methodRegisterList) {
            obj = (JSONObject)o;
            vo = new JSONObject();
            vo.put("billCode", (Object)obj.getString("billCode"));
            vo.put("id", (Object)obj.getString("id"));
            vo.put("billType", (Object)"\u7701\u5e02\u7ea7\u5de5\u6cd5\u767b\u8bb0");
            vo.put("billName", (Object)obj.getString("methodName"));
            vo.put("employeeName", (Object)obj.getString("employeeName"));
            vo.put("createTime", (Object)DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add((Object)vo);
        }
        result.put("resultList", (Object)resultList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }
}

