package com.ejianc.business.scientific.sci.work.controller;

import java.io.Serializable;

import com.ejianc.business.scientific.sci.bean.SciProjectUserEntity;
import com.ejianc.business.scientific.sci.service.ISciProjectUserService;
import com.ejianc.business.scientific.sci.work.bean.WorkTimeDetailEntity;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeDetailVO;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeReportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.scientific.sci.work.bean.WorkTimeEntity;
import com.ejianc.business.scientific.sci.work.service.IWorkTimeService;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeVO;

/**
 * 科研管理-科研工时填报
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("workTime")
public class WorkTimeController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IWorkTimeService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISciProjectUserService projectUserService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkTimeVO> saveOrUpdate(@RequestBody WorkTimeVO saveOrUpdateVO) {
    	WorkTimeVO resp = service.saveOrUpdate(saveOrUpdateVO);
        if(StringUtils.isNotBlank(resp.getCheckMsg())) {
            return CommonResponse.error(resp.getCheckMsg());
        }
    	return CommonResponse.success("保存或修改单据成功！", resp);
    }

    @PostMapping(value = "/checkProject")
    @ResponseBody
    public CommonResponse<List<WorkTimeDetailVO>> checkProject(@RequestBody WorkTimeVO saveOrUpdateVO) {
       String msg = service.checkProject(saveOrUpdateVO);
       return StringUtils.isNotBlank(msg) ? CommonResponse.error(msg) : CommonResponse.success("该项目下当前月份未制单，项目可选！");
    }

    @PostMapping(value = "/checkUserWorkTime")
    @ResponseBody
    public CommonResponse<List<WorkTimeDetailVO>> checkUserWorkTime(@RequestBody WorkTimeVO saveOrUpdateVO) {
        List<WorkTimeDetailVO> resp = service.checkUserWorkTime(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！", resp);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WorkTimeVO> queryDetail(Long id) {
    	WorkTimeEntity entity = service.selectById(id);
    	WorkTimeVO vo = BeanMapper.map(entity, WorkTimeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkTimeVO> vos) {
        service.removeByIds(vos.stream().map(WorkTimeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkTimeVO>> queryList(@RequestBody QueryParam param) {

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("managerName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }

        IPage<WorkTimeEntity> page = service.queryPage(param,false);
        IPage<WorkTimeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkTimeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<WorkTimeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("WorkTime-export.xlsx", beans, response);
    }



    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refWorkTimeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkTimeVO>> refWorkTimeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WorkTimeEntity> page = service.queryPage(param,false);
        IPage<WorkTimeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkTimeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 查询科研项目下所有成员及成员当前月份累计工时
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/queryUserWorkTime", method = RequestMethod.POST)
    @ResponseBody
     public CommonResponse<List<WorkTimeDetailVO>> queryUserWorkTime(@RequestBody WorkTimeVO workTimeVO) {
        List<WorkTimeDetailVO> resp = new ArrayList<>();
        List<SciProjectUserEntity> projectUserList = projectUserService.getAllByPid(workTimeVO.getProjectId());
        Map<Long, BigDecimal> userWorkTimeMap = service.getUserWorkTime(new ArrayList<>(projectUserList.stream()
                        .map(item -> item.getUserId()).collect(Collectors.toSet())),
                null);

        WorkTimeDetailVO tmp = null;
        for(SciProjectUserEntity user : projectUserList) {
            tmp = new WorkTimeDetailVO();
            tmp.setUserId(user.getUserId());
            tmp.setUserName(user.getUserName());
            tmp.setUserMobile(user.getUserMobile());
            tmp.setDuty(user.getDuty());
            tmp.setPostId(user.getPostId());
            tmp.setPostName(user.getPostName());
            tmp.setProfessional(user.getProfessional());
            tmp.setUserPlanTotalHour(user.getPlanHour());
            tmp.setUserTotalHour(new BigDecimal("0"));
            tmp.setUserHour(new BigDecimal("0"));
            tmp.setSourceId(user.getPid());
            tmp.setSourceDetailId(user.getId());
            if(userWorkTimeMap.containsKey(tmp.getUserId())) {
                tmp.setUserTotalHour(userWorkTimeMap.get(tmp.getUserId()));
            }
            tmp.setUserTotalHourContainsSelf(tmp.getUserTotalHour());
            resp.add(tmp);
        }

        return CommonResponse.success("查询成功！", resp);
     }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/pageReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkTimeReportVO>> pageReport(@RequestBody QueryParam param) {

        Map<String, Object> params = new HashMap<>();

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            params.put("orgIds", commonOrgIds);
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            params.put("orgIds", departmentIds);
        }

        for(String key : param.getParams().keySet()) {
            params.put(key, param.getParams().get(key));
        }

        if(StringUtils.isNotBlank(param.getSearchText())) {
            params.put("searchText", param.getSearchText());
        }

        IPage<WorkTimeReportVO> page = service.pageReport(params);

        return CommonResponse.success("查询列表数据成功！", page);
    }
}
