package com.ejianc.business.scientific.sci.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author yqls
 * @date 2024-03-15 15:55:40
 */
@Component
public class EntityUtil<T> {
    private static Logger logger = LoggerFactory.getLogger(EntityUtil.class);

    private static IBillCodeApi billCodeApi;

    @Autowired
    private void setBillCodeApi (IBillCodeApi billCodeApi){
        this.billCodeApi = billCodeApi;
    }

//    /**
//     * 生成单据编码
//     * @param t
//     */
//    public static <T> void saveBillCode(T t, String codeName, String ruleCode) {
//        String code = String.valueOf(getValue(t, codeName));
//        if(StringUtils.isNotEmpty(code)){
//            return;
//        }
//        JSONObject paramJson = JSONObject.parseObject(JSONObject.toJSONString(t));
//        BillCodeParam billCodeParam = BillCodeParam.build(ruleCode, InvocationInfoProxy.getTenantid(), paramJson);
//        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//        if(!billCode.isSuccess()) {
//            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//        }
//        setValue(t, codeName, billCode.getData());
//        saveOrUpdate(t);
//    }

    /**
     * 生成单据编码
     * @param t
     */
    public static <T> String createBillCode(T t, String ruleCode) {
        JSONObject paramJson = JSONObject.parseObject(JSONObject.toJSONString(t));
        BillCodeParam billCodeParam = BillCodeParam.build(ruleCode, InvocationInfoProxy.getTenantid(), paramJson);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if(!billCode.isSuccess()) {
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        return billCode.getData();
    }

    /**
     * 保存
     * @param entity 待保存对象
     * @param mainClass 单据类型
     */
    public static void saveOrUpdate(JSONObject entity, Class<?> mainClass) {
        String className = mainClass.getSimpleName();
        className = className.substring(0,1).toLowerCase()+className.substring(1);
        String serviceName = className.substring(0, className.lastIndexOf("Entity")) + "Service";
        BaseServiceImpl service = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
        service.saveOrUpdate(BeanMapper.map(entity, mainClass), false);
    }

    /**
     * 保存
     * @param entity 待保存对象
     * @param <T>
     * @return
     */
    public static <T> Long saveOrUpdate(T entity) {
        Class<?> mainClass = entity.getClass();
        String className = mainClass.getSimpleName();
        className = className.substring(0,1).toLowerCase()+className.substring(1);
        String serviceName = className.substring(0, className.lastIndexOf("Entity")) + "Service";
        BaseServiceImpl service = ContextUtil.getBean(serviceName, BaseServiceImpl.class);
        service.saveOrUpdate(entity, false);
        return EntityUtil.getLong(entity, "id");
    }

    /**
     * 初始化数据
     * @param entity
     */
    public static void clearInvalidData(JSONObject entity) {
        entity.put("id", null);
        entity.put("createTime", null);
        entity.put("updateTime", null);
        entity.put("tenantId", InvocationInfoProxy.getTenantid());
        entity.put("updateUserCode", null);
        entity.put("createUserCode", null);
    }

    /**
     * 初始化数据
     * @param entity
     */
    public static <T extends BaseEntity> void clearInvalidData(T entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setUpdateTime(null);
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        entity.setUpdateUserCode(null);
        entity.setCreateUserCode(null);
    }

    public static <T extends BaseVO> void clearInvalidData(T vo) {
        vo.setId(null);
        vo.setCreateTime(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setCreateUserCode(null);
    }

    /**
     * 初始化数据，包含子表
     * @param entity
     */
    public static <S, T extends BaseEntity> S clearInvalidEntity(T entity, Class<S> clazz) {
        return BeanMapper.map(clearInvalidEntity(entity), clazz);
    }

    /**
     * 初始化数据，包含子表
     * @param entity
     */
    public static <T extends BaseEntity> T clearInvalidEntity(T entity) {
        Class<T> clazz = (Class<T>) entity.getClass();
        T result = BeanMapper.map(entity, clazz);
        Long id = result.getId();
        setValue(result, "sourceId", id);
        clearInvalidData(result);// 初始化数据
        Class<?> mainClass = result.getClass();
        Field[] fields = mainClass.getDeclaredFields();
        /** 查找字表字段 可能有多个子表*/
        for (Field field : fields) {
            if (field.isAnnotationPresent(SubEntity.class)) {
                SubEntity subEntity = field.getAnnotation(SubEntity.class);
                List<BaseEntity> subList = castList(getValue(result, field.getName()), BaseEntity.class);
                for(BaseEntity detail : subList){
                    setValue(detail, "sourceId", detail.getId());
//                    setValue(detail, "rowState", "add");
                    EntityUtil.clearInvalidData(detail);// 初始化数据
                }
                if(!ListUtil.isEmpty(subList)){
                    setValue(result, field.getName(), subList);
                }
            }
        }
        return result;
    }

    /**
     * 同步数据，包含子表
     * @param target 目标实体
     * @param source 来源实体
     */
    public static <T extends BaseEntity, S extends BaseEntity> T transformFileds(T target, S source) {
        logger.info("同步数据开始，同步前数据：{}，来源数据", target, source);
        Class<T> clazz = (Class<T>) target.getClass();
        T copy = BeanMapper.map(target, clazz);
        T result = BeanMapper.map(source, clazz);
        Long id = source.getId();
        setValue(result, "sourceId", id);
        setValue(result, "id", copy.getId());
        setValue(result, "version", getValue(copy, "version"));

        Class<?> mainClass = target.getClass();
        Field[] fields = mainClass.getDeclaredFields();
        /** 查找字表字段 可能有多个子表*/
        for (Field field : fields) {
            if (field.isAnnotationPresent(SubEntity.class)) {
                SubEntity subEntity = field.getAnnotation(SubEntity.class);
                List<BaseEntity> detailList = castList(getValue(copy, field.getName()), BaseEntity.class);
                Map<Long, BaseEntity> detailMap = detailList.stream().collect(Collectors.toMap(x->x.getId(), x->x));
                List<BaseEntity> subList = castList(getValue(result, field.getName()), BaseEntity.class);
                for(BaseEntity sub : subList){
                    if(detailMap.containsKey(getLong(sub, "sourceDetailId"))){
                        BaseEntity vo = detailMap.get(getLong(sub, "sourceDetailId"));
                        setValue(sub, "sourceId", id);
                        setValue(sub, "sourceDetailId", sub.getId());
                        sub.setId(vo.getId());
                        sub.setVersion(vo.getVersion());
                    }
                }
                List<Long> subIds = subList.stream().map(x->x.getId()).collect(Collectors.toList());
                List<BaseEntity> delList = detailList.stream().filter(x->!subIds.contains(x.getId())).map(x->{x.setRowState("del"); return x;}).collect(Collectors.toList());
                subList.addAll(delList);
                if(!ListUtil.isEmpty(subList)){
                    setValue(result, field.getName(), subList);
                }
            }
        }
        logger.info("同步数据结束，同步后数据：{}", result);
        return result;
    }

    /**
     * 全量同步子表
     * @param target 目标实体
     * @param source 来源实体
     * @param sourceFildName 默认sourceId
     */
    public static <T extends BaseEntity, S extends BaseEntity> T syncDetail(T target, S source, String sourceFildName) {
        Class<?> mainClass = target.getClass();
        T copy = BeanMapper.map(source, (Class<T>)mainClass);
        Field[] fields = mainClass.getDeclaredFields();
        /** 查找字表字段 可能有多个子表*/
        for (Field field : fields) {
            if (field.isAnnotationPresent(SubEntity.class)) {
                SubEntity subEntity = field.getAnnotation(SubEntity.class);
                Class<T> clazz = (Class<T>) subEntity.getClass();
                List<BaseEntity> targetList = castList(getValue(target, field.getName()), BaseEntity.class);
                if("del".equals(target.getRowState()) && !ListUtil.isEmpty(targetList)){
                    for(BaseEntity vo : targetList){
                        vo.setRowState("del");
                    }
                    setValue(target, field.getName(), targetList);
                    continue;
                }
                Map<Long, BaseEntity> targetMap = targetList.stream().collect(Collectors.toMap(x->x.getId(), x->x));
                List<BaseEntity> sourceList = castList(getValue(copy, field.getName()), BaseEntity.class);
                List<Long> sourceIds = sourceList.stream().map(x->getLong(x, sourceFildName)).filter(Objects::nonNull).collect(Collectors.toList());
                List<BaseEntity> subList = new ArrayList<>();
                for (BaseEntity detail : sourceList) {
                    if (getLong(detail, sourceFildName) != null) {
                        detail.setId(getLong(detail, sourceFildName));
                    } else {
                        detail.setId(null);
                        detail.setRowState("add");
                    }
                    // version替换，否则更新不了
                    if(targetMap.containsKey(detail.getId())){
                        BaseEntity vo = targetMap.get(detail.getId());
                        detail.setVersion(vo.getVersion());
                    }
                    subList.add(detail);
                }
                for(BaseEntity vo : targetMap.values()){
                    if(!sourceIds.contains(vo.getId())){
                        vo.setRowState("del");
                        subList.add(vo);
                    }
                }
                if(!ListUtil.isEmpty(subList)){
                    setValue(target, field.getName(), subList);
                }
            }
        }
        return target;
    }

    /**
     * getLong方法
     * @param t
     * @param fieldName
     * @param <T>
     * @return
     */
    public static <T> Long getLong(T t, String fieldName) {
        Object obj = getValue(t, fieldName);
        if(obj instanceof Long){
            return Long.valueOf(String.valueOf(obj));
        }
        return null;
    }

    /**
     * get方法
     * @param t
     * @param fieldName
     * @param <T>
     * @return
     */
    public static <T> Object getValue(T t, String fieldName) {
        Class<?> clazz = t.getClass() ;
        for(; clazz != Object.class ; clazz = clazz.getSuperclass()) {
            try {
                Method m = clazz.getDeclaredMethod("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), (Class[]) null);
                try {
                    return m.invoke(t, (Object[]) null);
                } catch (IllegalAccessException e) {
                    throw new BusinessException("类【" + clazz + "】的字段【" + fieldName + "】的get方法需要设置成public属性！");
                } catch (InvocationTargetException e) {
                    throw new BusinessException("类【" + clazz + "】的字段【" + fieldName + "】的get方法调用失败！");
                }
            } catch (Exception e) {
                //这里甚么都不要做！并且这里的异常必须这样写，不能抛出去。
                //如果这里的异常打印或者往外抛，则就不会执行clazz = clazz.getSuperclass(),最后就不会进入到父类中了
            }
        }
        return null;
    }

    /**
     * set方法
     * @param t
     * @param fieldName
     * @param obj
     * @param <T>
     */
    public static <T> void setValue(T t, String fieldName, Object obj) {
        Class<?> clazz = t.getClass() ;
        for(; clazz != Object.class ; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                Method m = clazz.getDeclaredMethod("set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), field.getType());
                try {
                    m.invoke(t, obj);
                } catch (IllegalAccessException e) {
                    throw new BusinessException("类【" + clazz + "】的字段【" + fieldName + "】的get方法需要设置成public属性！");
                } catch (InvocationTargetException e) {
                    throw new BusinessException("类【" + clazz + "】的字段【" + fieldName + "】的get方法调用失败！");
                }
            } catch (Exception e) {
                //这里甚么都不要做！并且这里的异常必须这样写，不能抛出去。
                //如果这里的异常打印或者往外抛，则就不会执行clazz = clazz.getSuperclass(),最后就不会进入到父类中了
            }
        }
    }

    /**
     * Object转换成List
     * @param <T>
     * @param obj
     * @param clazz
     * @return
     */
    public static <T> List<T> castList(Object obj, Class<?> clazz) {
        List<T> result = new ArrayList<>();
        if(obj instanceof List<?>){
            for(Object o : (List<?>) obj){
                result.add((T) clazz.cast(o));
            }
        }
        return result;
    }
}
