/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.sci.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scientific.sci.bean.SciProjectChangeEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectChangeUserEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectChangeUserHourEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectUserEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectUserHourEntity;
import com.ejianc.business.scientific.sci.mapper.SciProjectChangeMapper;
import com.ejianc.business.scientific.sci.service.ISciProjectChangeService;
import com.ejianc.business.scientific.sci.service.ISciProjectChangeUserHourService;
import com.ejianc.business.scientific.sci.service.ISciProjectChangeUserService;
import com.ejianc.business.scientific.sci.service.ISciProjectService;
import com.ejianc.business.scientific.sci.service.ISciProjectUserHourService;
import com.ejianc.business.scientific.sci.service.ISciProjectUserService;
import com.ejianc.business.scientific.sci.utils.EntityUtil;
import com.ejianc.business.scientific.sci.vo.SciProjectChangeUserHourVO;
import com.ejianc.business.scientific.sci.vo.SciProjectChangeUserVO;
import com.ejianc.business.scientific.sci.vo.SciProjectChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sciProjectChangeService")
public class SciProjectChangeServiceImpl
extends BaseServiceImpl<SciProjectChangeMapper, SciProjectChangeEntity>
implements ISciProjectChangeService {
    private static final String BILL_CODE = "IN_SCI_PROJECT_CHANGE";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISciProjectChangeUserService userService;
    @Autowired
    private ISciProjectChangeUserHourService hourService;
    @Autowired
    private ISciProjectService projectService;
    @Autowired
    private ISciProjectUserService projectUserService;
    @Autowired
    private ISciProjectUserHourService projectHourService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public SciProjectChangeVO saveOrUpdate(SciProjectChangeVO saveOrUpdateVO) {
        SciProjectChangeEntity entity = (SciProjectChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SciProjectChangeEntity.class));
        this.validateProjectId(entity.getSourceId(), entity.getId(), "\u91cd\u590d\u65b0\u589e");
        if (StringUtils.isEmpty((CharSequence)entity.getCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        String changeReason = entity.getItemList().stream().map(x -> x.getItem()).collect(Collectors.joining("\u3001"));
        entity.setChangeReason(changeReason);
        if (CollectionUtils.isNotEmpty(entity.getUserList())) {
            for (SciProjectChangeUserEntity user : entity.getUserList()) {
                for (SciProjectChangeUserHourEntity hour : user.getHourList()) {
                    hour.setUserId(user.getUserId());
                    hour.setUserName(user.getUserName());
                    if (!"del".equals(user.getRowState())) continue;
                    hour.setRowState("del");
                }
            }
        }
        this.validateHourByUser(entity.getUserList());
        if (CollectionUtils.isNotEmpty(entity.getUserList())) {
            for (SciProjectChangeUserEntity user : entity.getUserList()) {
                this.userService.saveOrUpdate((Object)user, false);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(SciProjectEntity::getChangeId, (Object)entity.getId());
        wrapper.set(SciProjectEntity::getChangeStatus, (Object)"2");
        wrapper.set(SciProjectEntity::getChangeCode, (Object)entity.getCode());
        wrapper.eq(BaseEntity::getId, (Object)entity.getSourceId());
        this.projectService.update((Wrapper)wrapper);
        SciProjectChangeVO vo = (SciProjectChangeVO)BeanMapper.map((Object)((Object)entity), SciProjectChangeVO.class);
        return vo;
    }

    @Override
    public SciProjectChangeVO queryDetailChange(Long id) {
        SciProjectEntity entity = (SciProjectEntity)((Object)this.projectService.selectById(id));
        this.validateProjectId(entity.getId(), null, "\u91cd\u590d\u65b0\u589e");
        if (CollectionUtils.isNotEmpty(entity.getUserList())) {
            List ids = entity.getUserList().stream().map(x -> x.getId()).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("pid", new Parameter("in", ids));
            List hourList = this.projectHourService.queryList(param);
            Map<Long, List<SciProjectUserHourEntity>> hourMap = hourList.stream().collect(Collectors.groupingBy(x -> x.getPid()));
            for (SciProjectUserEntity user : entity.getUserList()) {
                user.setHourList(hourMap.get(user.getId()));
            }
        }
        SciProjectChangeVO vo = (SciProjectChangeVO)BeanMapper.map((Object)((Object)entity), SciProjectChangeVO.class);
        for (SciProjectChangeUserVO detail : vo.getUserList()) {
            detail.setSourceId(detail.getId());
            detail.setRowState("add");
            EntityUtil.clearInvalidData(detail);
            detail.setId(Long.valueOf(IdWorker.getId()));
            for (SciProjectChangeUserHourVO hour : detail.getHourList()) {
                hour.setSourceId(hour.getId());
                hour.setRowState("add");
                EntityUtil.clearInvalidData(hour);
                hour.setPid(detail.getId());
                hour.setId(Long.valueOf(IdWorker.getId()));
            }
        }
        for (SciProjectChangeUserVO detail : vo.getBudgetList()) {
            detail.setSourceId(detail.getId());
            detail.setRowState("add");
            EntityUtil.clearInvalidData(detail);
        }
        for (SciProjectChangeUserVO detail : vo.getTargetList()) {
            detail.setSourceId(detail.getId());
            detail.setRowState("add");
            EntityUtil.clearInvalidData(detail);
        }
        vo.setSourceId(vo.getId());
        vo.setBillState(null);
        vo.setChangeReason(null);
        vo.setCode(null);
        vo.setChangeVersion(Integer.valueOf(vo.getChangeVersion() == null ? 1 : vo.getChangeVersion() + 1));
        vo.setChangeDate(new Date());
        EntityUtil.clearInvalidData(vo);
        vo.setId(Long.valueOf(IdWorker.getId()));
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "EJCBT202502000014", "attachMgr", String.valueOf(vo.getId()), "EJCBT202502000015", "attachMgr");
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "EJCBT202502000014", "proposal", String.valueOf(vo.getId()), "EJCBT202502000015", "proposal");
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "EJCBT202502000014", "meet", String.valueOf(vo.getId()), "EJCBT202502000015", "meet");
        return vo;
    }

    @Override
    public List<SciProjectChangeVO> queryChangeHistory(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("sourceId", new Parameter("eq", (Object)id));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getOrderMap().put("changeVersion", "desc");
        List list = super.queryList(param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<SciProjectChangeVO>();
        }
        List result = BeanMapper.mapList((Iterable)list, SciProjectChangeVO.class);
        for (SciProjectChangeVO vo : result) {
            String historyBillCode = vo.getCode() + "-" + (vo.getChangeVersion() - 1);
            vo.setHistoryBillCode(historyBillCode);
        }
        return result;
    }

    @Override
    public String validateProjectId(Long projectId, Long id, String operation) {
        List list;
        List freeList;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter("eq", (Object)projectId));
        if (id != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (CollectionUtils.isNotEmpty(freeList = (list = super.queryList(queryParam, false)).stream().filter(x -> 1 != x.getBillState() && 3 != x.getBillState()).collect(Collectors.toList()))) {
            throw new BusinessException("\u8be5\u79d1\u7814\u9879\u76ee\u5b58\u5728\u975e\u751f\u6548\u6001\u7684\u53d8\u66f4\u5355\uff0c\u4e0d\u80fd" + operation + "!");
        }
        return "\u6821\u9a8c\u6210\u529f\uff01";
    }

    @Override
    public void validateHourByUser(List<SciProjectChangeUserEntity> userList) {
        List dataList;
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        List list = userList.stream().filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List saveList = list.stream().map(x -> x.getHourList()).flatMap(Collection::stream).filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        List userIds = list.stream().map(x -> x.getUserId()).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("userId", new Parameter("in", userIds));
        List ids = saveList.stream().map(x -> x.getSourceId()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            param.getParams().put("id", new Parameter("not_in", ids));
        }
        dataList = CollectionUtils.isNotEmpty((Collection)(dataList = this.projectHourService.queryList(param))) ? dataList : new ArrayList();
        dataList.addAll(BeanMapper.mapList(saveList, SciProjectUserHourEntity.class));
        Map<Long, Map<String, List<SciProjectUserHourEntity>>> userMap = dataList.stream().collect(Collectors.groupingBy(x -> x.getUserId(), Collectors.groupingBy(x -> x.getPlanYear())));
        StringBuilder message = new StringBuilder();
        for (Long userId : userMap.keySet()) {
            Map<String, List<SciProjectUserHourEntity>> yearMap = userMap.get(userId);
            for (String year : yearMap.keySet()) {
                BigDecimal hour = yearMap.get(year).stream().map(x -> x.getPlanHour()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
                if (!ComputeUtil.isGreaterThan((BigDecimal)hour, (BigDecimal)ComputeUtil.toBigDecimal((String)"12"))) continue;
                message.append("\u3010" + yearMap.get(year).get(0).getUserName() + "\u3011");
                message.append("\u5728\u3010" + year + "\u5e74\u3011\u53c2\u4e0e\u7684\u6240\u6709\u79d1\u7814\u9879\u76ee\u7acb\u9879\u4e2d\u7684\u8ba1\u5212\u5de5\u65f6\u7d2f\u8ba1\u503c\u5df2\u8d8512\u4e2a\u6708\uff1b/n");
            }
        }
        if (message.length() > 0) {
            throw new BusinessException(message.toString());
        }
    }
}

