/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.sci.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.scientific.result.MethodApplyVO;
import com.ejianc.business.scientific.result.MethodRegisterVO;
import com.ejianc.business.scientific.result.PaperRegisterVO;
import com.ejianc.business.scientific.result.PatentRegisterVO;
import com.ejianc.business.scientific.result.ResultEvaluateVO;
import com.ejianc.business.scientific.result.SoftRegisterVO;
import com.ejianc.business.scientific.result.service.IMethodApplyService;
import com.ejianc.business.scientific.result.service.IMethodRegisterService;
import com.ejianc.business.scientific.result.service.IPaperRegisterService;
import com.ejianc.business.scientific.result.service.IPatentRegisterService;
import com.ejianc.business.scientific.result.service.IResultEvaluateService;
import com.ejianc.business.scientific.result.service.ISoftRegisterService;
import com.ejianc.business.scientific.sci.bean.SciProjectEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectUserEntity;
import com.ejianc.business.scientific.sci.bean.SciProjectUserHourEntity;
import com.ejianc.business.scientific.sci.cons.ProjectTypeEnum;
import com.ejianc.business.scientific.sci.mapper.SciProjectMapper;
import com.ejianc.business.scientific.sci.service.ICheckAcceptService;
import com.ejianc.business.scientific.sci.service.IExecuteService;
import com.ejianc.business.scientific.sci.service.IFeeConfirmService;
import com.ejianc.business.scientific.sci.service.ISciProjectChangeService;
import com.ejianc.business.scientific.sci.service.ISciProjectService;
import com.ejianc.business.scientific.sci.service.ISciProjectUserHourService;
import com.ejianc.business.scientific.sci.service.ISciProjectUserService;
import com.ejianc.business.scientific.sci.utils.DateUtil;
import com.ejianc.business.scientific.sci.utils.JSONUtils;
import com.ejianc.business.scientific.sci.utils.ListCallable;
import com.ejianc.business.scientific.sci.vo.CheckAcceptVO;
import com.ejianc.business.scientific.sci.vo.ExecuteVO;
import com.ejianc.business.scientific.sci.vo.FeeConfirmVO;
import com.ejianc.business.scientific.sci.vo.SciProjectChangeVO;
import com.ejianc.business.scientific.sci.vo.SciProjectVO;
import com.ejianc.business.scientific.sci.work.service.IWorkTimeService;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sciProjectService")
public class SciProjectServiceImpl
extends BaseServiceImpl<SciProjectMapper, SciProjectEntity>
implements ISciProjectService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE_IN = "IN_SCI_PROJECT";
    private static final String BILL_CODE_OUT = "OUT_SCI_PROJECT";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISciProjectUserService userService;
    @Autowired
    private ISciProjectUserHourService hourService;
    @Autowired
    private ISciProjectChangeService changeService;
    @Autowired
    private IExecuteService executeService;
    @Autowired
    private ICheckAcceptService checkService;
    @Autowired
    private IFeeConfirmService feeService;
    @Autowired
    private IWorkTimeService workTimeService;
    @Autowired
    private IMethodApplyService methodApplyService;
    @Autowired
    private IPatentRegisterService patentRegisterService;
    @Autowired
    private ISoftRegisterService softRegisterService;
    @Autowired
    private IPaperRegisterService paperRegisterService;
    @Autowired
    private IResultEvaluateService resultEvaluateService;
    @Autowired
    private IMethodRegisterService methodRegisterService;

    @Override
    public SciProjectVO saveOrUpdate(SciProjectVO saveOrUpdateVO) {
        SciProjectEntity entity = (SciProjectEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SciProjectEntity.class));
        if (CollectionUtils.isNotEmpty(entity.getUserList())) {
            for (SciProjectUserEntity user : entity.getUserList()) {
                for (SciProjectUserHourEntity hour : user.getHourList()) {
                    hour.setUserId(user.getUserId());
                    hour.setUserName(user.getUserName());
                    if (!"del".equals(user.getRowState())) continue;
                    hour.setRowState("del");
                }
            }
        }
        this.validateHourByUser(entity.getUserList());
        if (entity.getId() == null || entity.getId() == 0L) {
            String rule = "1".equals(entity.getSourceType()) ? BILL_CODE_IN : BILL_CODE_OUT;
            BillCodeParam billCodeParam = BillCodeParam.build((String)rule, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setChangeStatus("1");
            entity.setProjectStatus("0");
        }
        if (CollectionUtils.isNotEmpty(entity.getUserList())) {
            for (SciProjectUserEntity user : entity.getUserList()) {
                this.userService.saveOrUpdate((Object)user, false);
            }
        }
        if (null == entity.getProjectDate()) {
            entity.setProjectDate(new Date());
        }
        super.saveOrUpdate((Object)entity, false);
        SciProjectVO vo = (SciProjectVO)BeanMapper.map((Object)((Object)entity), SciProjectVO.class);
        return vo;
    }

    @Override
    public SciProjectVO queryDetail(Long id) {
        SciProjectEntity entity = (SciProjectEntity)((Object)super.selectById((Serializable)id));
        if (CollectionUtils.isNotEmpty(entity.getUserList())) {
            List ids = entity.getUserList().stream().map(x -> x.getId()).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("pid", new Parameter("in", ids));
            List hourList = this.hourService.queryList(param);
            Map<Long, List<SciProjectUserHourEntity>> hourMap = hourList.stream().collect(Collectors.groupingBy(x -> x.getPid()));
            for (SciProjectUserEntity user : entity.getUserList()) {
                user.setHourList(hourMap.get(user.getId()));
            }
        }
        SciProjectVO vo = (SciProjectVO)BeanMapper.map((Object)((Object)entity), SciProjectVO.class);
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject queryAllDetail(Long id) {
        JSONObject vo;
        JSONObject obj;
        JSONObject result = new JSONObject();
        SciProjectVO projectVO = this.queryDetail(id);
        result.put("projectVO", (Object)projectVO);
        List<SciProjectChangeVO> changeList = this.changeService.queryChangeHistory(id);
        result.put("changeList", changeList);
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)id));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        QueryParam resultParam = new QueryParam();
        resultParam.getParams().put("scientificProjectId", new Parameter("eq", (Object)id));
        resultParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        Future<JSONArray> future1 = ListCallable.excute(threadPool, param, this.executeService);
        Future<JSONArray> future2 = ListCallable.excute(threadPool, param, this.checkService);
        Future<JSONArray> future3 = ListCallable.excute(threadPool, param, this.feeService);
        Future<JSONArray> future4 = ListCallable.excute(threadPool, param, this.workTimeService);
        Future<JSONArray> future5 = ListCallable.excute(threadPool, resultParam, this.methodApplyService);
        Future<JSONArray> future6 = ListCallable.excute(threadPool, resultParam, this.patentRegisterService);
        Future<JSONArray> future7 = ListCallable.excute(threadPool, resultParam, this.softRegisterService);
        Future<JSONArray> future8 = ListCallable.excute(threadPool, resultParam, this.paperRegisterService);
        Future<JSONArray> future9 = ListCallable.excute(threadPool, resultParam, this.resultEvaluateService);
        Future<JSONArray> future10 = ListCallable.excute(threadPool, resultParam, this.methodRegisterService);
        JSONArray executeList = new JSONArray();
        JSONArray checkList = new JSONArray();
        JSONArray feeList = new JSONArray();
        JSONArray workTimeList = new JSONArray();
        JSONArray methodApplyList = new JSONArray();
        JSONArray patentRegisterList = new JSONArray();
        JSONArray softRegisterList = new JSONArray();
        JSONArray paperRegisterList = new JSONArray();
        JSONArray resultEvaluateList = new JSONArray();
        JSONArray methodRegisterList = new JSONArray();
        try {
            executeList = future1.get();
            checkList = future2.get();
            feeList = future3.get();
            workTimeList = future4.get();
            methodApplyList = future5.get();
            patentRegisterList = future6.get();
            softRegisterList = future7.get();
            paperRegisterList = future8.get();
            resultEvaluateList = future9.get();
            methodRegisterList = future10.get();
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        result.put("executeList", JSONUtils.mapList(executeList, ExecuteVO.class));
        result.put("checkList", JSONUtils.mapList(checkList, CheckAcceptVO.class));
        result.put("feeList", JSONUtils.mapList(feeList, FeeConfirmVO.class));
        result.put("workTimeList", JSONUtils.mapList(workTimeList, WorkTimeVO.class));
        result.put("methodApplyList", JSONUtils.mapList(methodApplyList, MethodApplyVO.class));
        result.put("patentRegisterList", JSONUtils.mapList(patentRegisterList, PatentRegisterVO.class));
        result.put("softRegisterList", JSONUtils.mapList(softRegisterList, SoftRegisterVO.class));
        result.put("paperRegisterList", JSONUtils.mapList(paperRegisterList, PaperRegisterVO.class));
        result.put("resultEvaluateList", JSONUtils.mapList(resultEvaluateList, ResultEvaluateVO.class));
        result.put("methodRegisterList", JSONUtils.mapList(methodRegisterList, MethodRegisterVO.class));
        BigDecimal sumApplyMny = feeList.stream().map(x -> ((JSONObject)x).getBigDecimal("applyMny")).filter(Objects::nonNull).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        result.put("budgetMny", (Object)projectVO.getBudgetMny());
        result.put("sumApplyMny", (Object)sumApplyMny);
        BigDecimal sumHour = workTimeList.stream().map(x -> ((JSONObject)x).getBigDecimal("billTotalWorkTime")).filter(Objects::nonNull).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        result.put("planHour", (Object)projectVO.getPlanHour());
        result.put("sumHour", (Object)sumHour);
        JSONArray resultList = new JSONArray();
        for (Object o : methodApplyList) {
            obj = (JSONObject)o;
            vo = new JSONObject();
            vo.put("billCode", (Object)obj.getString("billCode"));
            vo.put("id", (Object)obj.getString("id"));
            vo.put("billType", (Object)"\u5de5\u6cd5\u7533\u8bf7");
            vo.put("billName", (Object)obj.getString("methodName"));
            vo.put("employeeName", (Object)obj.getString("employeeName"));
            vo.put("createTime", (Object)DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add((Object)vo);
        }
        for (Object o : patentRegisterList) {
            obj = (JSONObject)o;
            vo = new JSONObject();
            vo.put("billCode", (Object)obj.getString("billCode"));
            vo.put("id", (Object)obj.getString("id"));
            vo.put("billType", (Object)"\u4e13\u5229");
            vo.put("billName", (Object)obj.getString("patentName"));
            vo.put("employeeName", (Object)obj.getString("employeeName"));
            vo.put("createTime", (Object)DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add((Object)vo);
        }
        for (Object o : softRegisterList) {
            obj = (JSONObject)o;
            vo = new JSONObject();
            vo.put("billCode", (Object)obj.getString("billCode"));
            vo.put("id", (Object)obj.getString("id"));
            vo.put("billType", (Object)"\u8f6f\u8457");
            vo.put("billName", (Object)obj.getString("softName"));
            vo.put("employeeName", (Object)obj.getString("employeeName"));
            vo.put("createTime", (Object)DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add((Object)vo);
        }
        for (Object o : paperRegisterList) {
            obj = (JSONObject)o;
            vo = new JSONObject();
            vo.put("billCode", (Object)obj.getString("billCode"));
            vo.put("id", (Object)obj.getString("id"));
            vo.put("billType", (Object)"\u8bba\u6587");
            vo.put("billName", (Object)obj.getString("paperName"));
            vo.put("employeeName", (Object)obj.getString("employeeName"));
            vo.put("createTime", (Object)DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add((Object)vo);
        }
        for (Object o : resultEvaluateList) {
            obj = (JSONObject)o;
            vo = new JSONObject();
            vo.put("billCode", (Object)obj.getString("billCode"));
            vo.put("id", (Object)obj.getString("id"));
            vo.put("billType", (Object)"\u6210\u679c\u8bc4\u4ef7");
            vo.put("billName", (Object)obj.getString("resultName"));
            vo.put("employeeName", (Object)obj.getString("employeeName"));
            vo.put("createTime", (Object)DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add((Object)vo);
        }
        for (Object o : methodRegisterList) {
            obj = (JSONObject)o;
            vo = new JSONObject();
            vo.put("billCode", (Object)obj.getString("billCode"));
            vo.put("id", (Object)obj.getString("id"));
            vo.put("billType", (Object)"\u7701\u5e02\u7ea7\u5de5\u6cd5\u767b\u8bb0");
            vo.put("billName", (Object)obj.getString("methodName"));
            vo.put("employeeName", (Object)obj.getString("employeeName"));
            vo.put("createTime", (Object)DateUtil.formatSeconds(obj.getDate("createTime")));
            resultList.add((Object)vo);
        }
        result.put("resultList", (Object)resultList);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject sciProjectReport(QueryParam queryParam) {
        LinkedHashMap orderMap = queryParam.getOrderMap();
        if (!orderMap.containsKey("orgName")) {
            orderMap.put("orgName", "asc");
        }
        if (!orderMap.containsKey("projectDate")) {
            orderMap.put("projectDate", "desc");
        }
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        IPage pageData = super.queryPage(queryParam);
        List projectList = pageData.getRecords();
        JSONObject page = new JSONObject();
        page.put("current", (Object)("" + pageData.getCurrent()));
        page.put("size", (Object)("" + pageData.getSize()));
        page.put("records", (Object)pageData.getRecords());
        page.put("total", (Object)("" + pageData.getTotal()));
        page.put("pages", (Object)("" + pageData.getPages()));
        if (CollectionUtils.isEmpty((Collection)projectList)) {
            return page;
        }
        List projectIds = projectList.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("in", projectIds));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        QueryParam resultParam = new QueryParam();
        resultParam.getParams().put("scientificProjectId", new Parameter("in", projectIds));
        resultParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        Future<JSONArray> future2 = ListCallable.excute(threadPool, param, this.checkService);
        Future<JSONArray> future3 = ListCallable.excute(threadPool, param, this.feeService);
        Future<JSONArray> future4 = ListCallable.excute(threadPool, param, this.workTimeService);
        Future<JSONArray> future5 = ListCallable.excute(threadPool, resultParam, this.methodApplyService);
        Future<JSONArray> future6 = ListCallable.excute(threadPool, resultParam, this.patentRegisterService);
        Future<JSONArray> future7 = ListCallable.excute(threadPool, resultParam, this.softRegisterService);
        Future<JSONArray> future8 = ListCallable.excute(threadPool, resultParam, this.paperRegisterService);
        Future<JSONArray> future9 = ListCallable.excute(threadPool, resultParam, this.resultEvaluateService);
        Future<JSONArray> future10 = ListCallable.excute(threadPool, resultParam, this.methodRegisterService);
        JSONArray checkList = new JSONArray();
        JSONArray feeList = new JSONArray();
        JSONArray workTimeList = new JSONArray();
        JSONArray methodApplyList = new JSONArray();
        JSONArray patentRegisterList = new JSONArray();
        JSONArray softRegisterList = new JSONArray();
        JSONArray paperRegisterList = new JSONArray();
        JSONArray resultEvaluateList = new JSONArray();
        JSONArray methodRegisterList = new JSONArray();
        try {
            checkList = future2.get();
            feeList = future3.get();
            workTimeList = future4.get();
            methodApplyList = future5.get();
            patentRegisterList = future6.get();
            softRegisterList = future7.get();
            paperRegisterList = future8.get();
            resultEvaluateList = future9.get();
            methodRegisterList = future10.get();
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        Map<Long, String> checkMap = checkList.stream().map(x -> (JSONObject)x).collect(Collectors.toMap(x -> x.getLong("projectId"), x -> DateUtil.formatDate(x.getDate("checkDate"))));
        Map<Long, BigDecimal> feeMap = feeList.stream().map(x -> (JSONObject)x).collect(Collectors.groupingBy(x -> x.getLong("projectId"), Collectors.reducing(BigDecimal.ZERO, x -> x.getBigDecimal("applyMny"), ComputeUtil::safeAdd)));
        Map<Long, BigDecimal> hourMap = workTimeList.stream().map(x -> (JSONObject)x).collect(Collectors.groupingBy(x -> x.getLong("projectId"), Collectors.reducing(BigDecimal.ZERO, x -> x.getBigDecimal("billTotalWorkTime"), ComputeUtil::safeAdd)));
        Map<Long, Long> methodApplyMap = methodApplyList.stream().map(x -> (JSONObject)x).collect(Collectors.groupingBy(x -> x.getLong("scientificProjectId"), Collectors.counting()));
        Map<Long, Long> patentRegisterMap = patentRegisterList.stream().map(x -> (JSONObject)x).collect(Collectors.groupingBy(x -> x.getLong("scientificProjectId"), Collectors.counting()));
        Map<Long, Long> softRegisterMap = softRegisterList.stream().map(x -> (JSONObject)x).collect(Collectors.groupingBy(x -> x.getLong("scientificProjectId"), Collectors.counting()));
        Map<Long, Long> paperRegisterMap = paperRegisterList.stream().map(x -> (JSONObject)x).collect(Collectors.groupingBy(x -> x.getLong("scientificProjectId"), Collectors.counting()));
        Map<Long, Long> resultEvaluateMap = resultEvaluateList.stream().map(x -> (JSONObject)x).collect(Collectors.groupingBy(x -> x.getLong("scientificProjectId"), Collectors.counting()));
        Map<Long, Long> methodRegisterMap = methodRegisterList.stream().map(x -> (JSONObject)x).collect(Collectors.groupingBy(x -> x.getLong("scientificProjectId"), Collectors.counting()));
        JSONArray array = new JSONArray();
        for (SciProjectEntity project : projectList) {
            Long projectId = project.getId();
            JSONObject obj = new JSONObject();
            obj.put("projectId", (Object)projectId);
            obj.put("orgName", (Object)project.getOrgName());
            obj.put("projectType", (Object)project.getProjectType());
            obj.put("projectTypeName", (Object)ProjectTypeEnum.getEnumByCode((String)project.getProjectType()).getName());
            obj.put("projectStatus", (Object)project.getProjectStatus());
            obj.put("projectDate", (Object)DateUtil.formatDate(project.getProjectDate()));
            obj.put("name", (Object)project.getName());
            obj.put("managerName", (Object)project.getManagerName());
            obj.put("period", (Object)project.getPeriod());
            obj.put("budgetMny", (Object)ComputeUtil.scaleTwo((BigDecimal)project.getBudgetMny()));
            obj.put("planHour", (Object)ComputeUtil.scale((BigDecimal)project.getPlanHour(), (int)1));
            obj.put("sourceType", (Object)project.getSourceType());
            obj.put("billState", (Object)project.getBillState());
            if (checkMap.containsKey(projectId)) {
                obj.put("checkDate", (Object)checkMap.get(projectId));
            }
            if (feeMap.containsKey(projectId)) {
                obj.put("actualMny", (Object)ComputeUtil.scaleTwo((BigDecimal)feeMap.get(projectId)));
            }
            if (hourMap.containsKey(projectId)) {
                obj.put("actualHour", (Object)ComputeUtil.scale((BigDecimal)hourMap.get(projectId), (int)1));
            }
            Integer num = 0;
            if (methodApplyMap.containsKey(projectId)) {
                num = num + methodApplyMap.get(projectId).intValue();
            }
            if (patentRegisterMap.containsKey(projectId)) {
                num = num + patentRegisterMap.get(projectId).intValue();
            }
            if (softRegisterMap.containsKey(projectId)) {
                num = num + softRegisterMap.get(projectId).intValue();
            }
            if (paperRegisterMap.containsKey(projectId)) {
                num = num + paperRegisterMap.get(projectId).intValue();
            }
            if (resultEvaluateMap.containsKey(projectId)) {
                num = num + resultEvaluateMap.get(projectId).intValue();
            }
            if (methodRegisterMap.containsKey(projectId)) {
                num = num + methodRegisterMap.get(projectId).intValue();
            }
            obj.put("num", (Object)num);
            array.add((Object)obj);
        }
        page.put("records", (Object)array);
        return page;
    }

    private void validateHourByUser(List<SciProjectUserEntity> userList) {
        List dataList;
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        List list = userList.stream().filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List saveList = list.stream().map(x -> x.getHourList()).flatMap(Collection::stream).filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        List userIds = list.stream().map(x -> x.getUserId()).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("userId", new Parameter("in", userIds));
        List ids = saveList.stream().map(x -> x.getId()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            param.getParams().put("id", new Parameter("not_in", ids));
        }
        dataList = CollectionUtils.isNotEmpty((Collection)(dataList = this.hourService.queryList(param))) ? dataList : new ArrayList();
        dataList.addAll(saveList);
        Map<Long, Map<String, List<SciProjectUserHourEntity>>> userMap = dataList.stream().collect(Collectors.groupingBy(x -> x.getUserId(), Collectors.groupingBy(x -> x.getPlanYear())));
        StringBuilder message = new StringBuilder();
        for (Long userId : userMap.keySet()) {
            Map<String, List<SciProjectUserHourEntity>> yearMap = userMap.get(userId);
            for (String year : yearMap.keySet()) {
                BigDecimal hour = yearMap.get(year).stream().map(x -> x.getPlanHour()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
                if (!ComputeUtil.isGreaterThan((BigDecimal)hour, (BigDecimal)ComputeUtil.toBigDecimal((String)"12"))) continue;
                message.append("\u3010" + yearMap.get(year).get(0).getUserName() + "\u3011");
                message.append("\u5728\u3010" + year + "\u5e74\u3011\u53c2\u4e0e\u7684\u6240\u6709\u79d1\u7814\u9879\u76ee\u7acb\u9879\u4e2d\u7684\u8ba1\u5212\u5de5\u65f6\u7d2f\u8ba1\u503c\u5df2\u8d8512\u4e2a\u6708\uff1b/n");
            }
        }
        if (message.length() > 0) {
            throw new BusinessException(message.toString());
        }
    }
}

