package com.ejianc.business.scientific.sci.service.impl;

import com.ejianc.business.scientific.sci.bean.*;
import com.ejianc.business.scientific.sci.cons.CommonConstant;
import com.ejianc.business.scientific.sci.service.*;
import com.ejianc.business.scientific.sci.utils.EntityUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("sciProjectChange") 
public class SciProjectChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ISciProjectChangeService service;

	@Autowired
	private ISciProjectChangeUserHourService hourService;

	@Autowired
	private ISciProjectService oldService;

	@Autowired
	private ISciProjectUserService userService;

	@Autowired
	private ISciProjectUserHourService oldHourService;

	@Autowired
	private ISciProjectHistoryService historyService;

	@Autowired
	private ISciProjectHistoryUserService historyUserService;

	@Autowired
	private IAttachmentApi attachmentApi;

    @Autowired
    private IBillTypeApi billTypeApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SciProjectChangeEntity change = service.selectById(billId);
		// 处理孙表
		if(CollectionUtils.isNotEmpty(change.getUserList())){
			List<Long> ids = change.getUserList().stream().map(x->x.getId()).collect(Collectors.toList());
			QueryParam param = new QueryParam();
			param.getParams().put("pid", new Parameter(QueryParam.IN, ids));
			List<SciProjectChangeUserHourEntity> hourList = hourService.queryList(param);
			Map<Long, List<SciProjectChangeUserHourEntity>> hourMap = hourList.stream().collect(Collectors.groupingBy(x->x.getPid()));
			for(SciProjectChangeUserEntity user : change.getUserList()){
				user.setHourList(hourMap.get(user.getId()));
			}
		}
		// 校验人员工时
		service.validateHourByUser(change.getUserList());
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("--------------变更审批通过，处理业务");
		SciProjectChangeEntity change = service.selectById(billId);
		// 处理孙表
		if(CollectionUtils.isNotEmpty(change.getUserList())){
			List<Long> ids = change.getUserList().stream().map(x->x.getId()).collect(Collectors.toList());
			QueryParam param = new QueryParam();
			param.getParams().put("pid", new Parameter(QueryParam.IN, ids));
			List<SciProjectChangeUserHourEntity> hourList = hourService.queryList(param);
			Map<Long, List<SciProjectChangeUserHourEntity>> hourMap = hourList.stream().collect(Collectors.groupingBy(x->x.getPid()));
			for(SciProjectChangeUserEntity user : change.getUserList()){
				user.setHourList(hourMap.get(user.getId()));
			}
		}

		SciProjectEntity old = oldService.selectById(change.getSourceId());
		// 处理孙表
		if(CollectionUtils.isNotEmpty(old.getUserList())){
			List<Long> ids = old.getUserList().stream().map(x->x.getId()).collect(Collectors.toList());
			QueryParam param = new QueryParam();
			param.getParams().put("pid", new Parameter(QueryParam.IN, ids));
			List<SciProjectUserHourEntity> hourList = oldHourService.queryList(param);
			Map<Long, List<SciProjectUserHourEntity>> hourMap = hourList.stream().collect(Collectors.groupingBy(x->x.getPid()));
			for(SciProjectUserEntity user : old.getUserList()){
				user.setHourList(hourMap.get(user.getId()));
			}
		}

		logger.info("--------------同步原单据到历史表");
		SciProjectHistoryEntity history = BeanMapper.map(old, SciProjectHistoryEntity.class);
		Long historyId = IdWorker.getId();
		history = EntityUtil.clearInvalidEntity(history, SciProjectHistoryEntity.class);
		history.setId(historyId);

		// 处理孙表
		if(CollectionUtils.isNotEmpty(history.getUserList())){
			for(SciProjectHistoryUserEntity user : history.getUserList()){
				for(SciProjectHistoryUserHourEntity hour : user.getHourList()){
					EntityUtil.clearInvalidData(hour);
				}
				historyUserService.saveOrUpdate(user, false);
			}
		}
		historyService.saveOrUpdate(history, false);

		// 将原单据附件复制到历史记录
		attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(old.getId()), CommonConstant.IN_SCI_PROJECT, CommonConstant.FILE_TYPE,
				String.valueOf(history.getId()), CommonConstant.IN_SCI_PROJECT, CommonConstant.FILE_TYPE);
		attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(old.getId()), CommonConstant.IN_SCI_PROJECT, "proposal",
				String.valueOf(history.getId()), CommonConstant.IN_SCI_PROJECT, "proposal");
		attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(old.getId()), CommonConstant.IN_SCI_PROJECT, "meet",
				String.valueOf(history.getId()), CommonConstant.IN_SCI_PROJECT, "meet");

		logger.info("--------------同步变更到原单据");
		old.setChangeStatus(CommonConstant.CHANGE_OVER);
		old.setChangeVersion(change.getChangeVersion());
		old.setChangeReason(change.getChangeReason());
		old.setChangeDate(change.getChangeDate());
		// 表头变更字段需回写到原单据
		old.setName(change.getName());
		old.setManagerId(change.getManagerId());
		old.setManagerName(change.getManagerName());
		old.setPeriod(change.getPeriod());
		old.setBudgetMny(change.getBudgetMny());
		old.setPlanHour(change.getPlanHour());
		old.setEmployeeId(change.getEmployeeId());
		old.setEmployeeName(change.getEmployeeName());
		old.setDeptId(change.getDeptId());
		old.setDeptName(change.getDeptName());

		old.setTechnicalIndex(change.getTechnicalIndex());
		old.setExpectResult(change.getExpectResult());
		old.setBackground(change.getBackground());
		old.setResearchArea(change.getResearchArea());
		old.setTechnology(change.getTechnology());
		old.setIntellectual(change.getIntellectual());
		old.setForecast(change.getForecast());
		old.setFeasibility(change.getFeasibility());

		// 全量替换子表
		EntityUtil.syncDetail(old, change, "sourceId");

		// 处理孙表
		if(CollectionUtils.isNotEmpty(old.getUserList())){
			Map<Long, SciProjectChangeUserEntity> changeMap = change.getUserList().stream().collect(Collectors.toMap(x->x.getSourceId(), x->x));
			for(SciProjectUserEntity user : old.getUserList()){
				EntityUtil.syncDetail(user, changeMap.get(user.getId()), "sourceId");
				userService.saveOrUpdate(user, false);
			}
		}
		oldService.saveOrUpdate(old, false);

		logger.info("--------------处理变更附件");
		// 变更附件复制到原单据，同步删除附件
		attachmentApi.copyFiles(String.valueOf(billId), billTypeCode, CommonConstant.FILE_TYPE,
				String.valueOf(old.getId()), CommonConstant.IN_SCI_PROJECT, CommonConstant.FILE_TYPE, true);
		attachmentApi.copyFiles(String.valueOf(billId), billTypeCode, "proposal",
				String.valueOf(old.getId()), CommonConstant.IN_SCI_PROJECT, "proposal", true);
		attachmentApi.copyFiles(String.valueOf(billId), billTypeCode, "meet",
				String.valueOf(old.getId()), CommonConstant.IN_SCI_PROJECT, "meet", true);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("变更单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
