package com.ejianc.business.scientific.sci.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scientific.sci.bean.*;
import com.ejianc.business.scientific.sci.cons.CommonConstant;
import com.ejianc.business.scientific.sci.mapper.SciProjectChangeMapper;
import com.ejianc.business.scientific.sci.service.*;
import com.ejianc.business.scientific.sci.utils.EntityUtil;
import com.ejianc.business.scientific.sci.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 科研项目立项-变更
 * 
 * @author generator
 * 
 */
@Service("sciProjectChangeService")
public class SciProjectChangeServiceImpl extends BaseServiceImpl<SciProjectChangeMapper, SciProjectChangeEntity> implements ISciProjectChangeService{

    private static final String BILL_CODE = "IN_SCI_PROJECT_CHANGE";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private ISciProjectChangeUserService userService;

    @Autowired
    private ISciProjectChangeUserHourService hourService;

    @Autowired
    private ISciProjectService projectService;

    @Autowired
    private ISciProjectUserService projectUserService;

    @Autowired
    private ISciProjectUserHourService projectHourService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public SciProjectChangeVO saveOrUpdate(SciProjectChangeVO saveOrUpdateVO) {
        SciProjectChangeEntity entity = BeanMapper.map(saveOrUpdateVO, SciProjectChangeEntity.class);

        // 校验同一个项目只能存在一个自由态或审批中的单据
        this.validateProjectId(entity.getSourceId(), entity.getId(), "重复新增");

        if(StringUtils.isEmpty(entity.getCode())){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        String changeReason = entity.getItemList().stream().map(x->x.getItem()).collect(Collectors.joining("、"));
        entity.setChangeReason(changeReason);

        // 处理孙表
        if(CollectionUtils.isNotEmpty(entity.getUserList())){
            for(SciProjectChangeUserEntity user : entity.getUserList()){
                for(SciProjectChangeUserHourEntity hour : user.getHourList()){
                    hour.setUserId(user.getUserId());
                    hour.setUserName(user.getUserName());
                    if("del".equals(user.getRowState())){
                        hour.setRowState("del");
                    }
                }
            }
        }
        // 校验人员工时
        this.validateHourByUser(entity.getUserList());

        // 处理孙表
        if(CollectionUtils.isNotEmpty(entity.getUserList())){
            for(SciProjectChangeUserEntity user : entity.getUserList()){
                userService.saveOrUpdate(user, false);
            }
        }
        super.saveOrUpdate(entity, false);

        // 更新原单据变更信息
        LambdaUpdateWrapper<SciProjectEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(SciProjectEntity::getChangeId, entity.getId());
        wrapper.set(SciProjectEntity::getChangeStatus, CommonConstant.CHANGE_ING);
        wrapper.set(SciProjectEntity::getChangeCode, entity.getCode());
        wrapper.eq(SciProjectEntity::getId, entity.getSourceId());
        projectService.update(wrapper);

        SciProjectChangeVO vo = BeanMapper.map(entity, SciProjectChangeVO.class);
        return vo;
    }

    @Override
    public Boolean delete(List<SciProjectChangeVO> vos) {
        if(CollectionUtils.isEmpty(vos)){
            return true;
        }
        List<Long> ids = vos.stream().map(SciProjectChangeVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<SciProjectChangeEntity> list = super.queryList(param);
        for (SciProjectChangeEntity vo : list) {
            LambdaUpdateWrapper<SciProjectEntity> updateWrapper = new LambdaUpdateWrapper<>();
            if (vo.getChangeVersion() == 1) {
                updateWrapper.set(SciProjectEntity::getChangeStatus, CommonConstant.CHANGE_NO);
            } else {
                updateWrapper.set(SciProjectEntity::getChangeStatus, CommonConstant.CHANGE_OVER);
            }
            updateWrapper.eq(SciProjectEntity::getId, vo.getSourceId());
            projectService.update(updateWrapper);
        }

        // 处理孙表
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("pid", new Parameter(QueryParam.IN, ids));
        List<SciProjectChangeUserEntity> userList = userService.queryList(param);
        if(CollectionUtils.isNotEmpty(userList)){
            List<Long> uids = userList.stream().map(x->x.getId()).collect(Collectors.toList());
            userService.removeByIds(uids, true);
        }

        super.removeByIds(ids,true);
        return true;
    }

    @Override
    public SciProjectChangeVO queryDetailChange(Long id) {
        SciProjectEntity entity = projectService.selectById(id);

        // 校验同一个项目只能存在一个自由态或审批中的单据
        this.validateProjectId(entity.getId(), null, "重复新增");

        // 处理孙表
        if(CollectionUtils.isNotEmpty(entity.getUserList())){
            List<Long> ids = entity.getUserList().stream().map(x->x.getId()).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("pid", new Parameter(QueryParam.IN, ids));
            List<SciProjectUserHourEntity> hourList = projectHourService.queryList(param);
            Map<Long, List<SciProjectUserHourEntity>> hourMap = hourList.stream().collect(Collectors.groupingBy(x->x.getPid()));
            for(SciProjectUserEntity user : entity.getUserList()){
                user.setHourList(hourMap.get(user.getId()));
            }
        }
        SciProjectChangeVO vo = BeanMapper.map(entity, SciProjectChangeVO.class);
        for (SciProjectChangeUserVO detail : vo.getUserList()) {
            detail.setSourceId(detail.getId());
            detail.setRowState("add");
            EntityUtil.clearInvalidData(detail);
            detail.setId(IdWorker.getId());
            // 处理孙表
            for(SciProjectChangeUserHourVO hour : detail.getHourList()){
                hour.setSourceId(hour.getId());
                hour.setRowState("add");
                EntityUtil.clearInvalidData(hour);
                hour.setPid(detail.getId());
                hour.setId(IdWorker.getId());
            }
        }
        for (SciProjectChangeBudgetVO detail : vo.getBudgetList()) {
            detail.setSourceId(detail.getId());
            detail.setRowState("add");
            EntityUtil.clearInvalidData(detail);
        }
        for (SciProjectChangeTargetVO detail : vo.getTargetList()) {
            detail.setSourceId(detail.getId());
            detail.setRowState("add");
            EntityUtil.clearInvalidData(detail);
        }
        vo.setSourceId(vo.getId());
        vo.setBillState(null);
        vo.setChangeReason(null);
        vo.setCode(null);
        vo.setChangeVersion(vo.getChangeVersion() == null ? 1 : vo.getChangeVersion() + 1);
        vo.setChangeDate(new Date());
        EntityUtil.clearInvalidData(vo);

        // 拷贝附件到变更单
        vo.setId(IdWorker.getId());
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), CommonConstant.IN_SCI_PROJECT, CommonConstant.FILE_TYPE,
                String.valueOf(vo.getId()), CommonConstant.IN_SCI_PROJECT_CHANGE, CommonConstant.FILE_TYPE);
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), CommonConstant.IN_SCI_PROJECT, "proposal",
                String.valueOf(vo.getId()), CommonConstant.IN_SCI_PROJECT_CHANGE, "proposal");
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), CommonConstant.IN_SCI_PROJECT, "meet",
                String.valueOf(vo.getId()), CommonConstant.IN_SCI_PROJECT_CHANGE, "meet");
        return vo;
    }

    @Override
    public List<SciProjectChangeVO> queryChangeHistory(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("sourceId", new Parameter(QueryParam.EQ, id));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getOrderMap().put("changeVersion", QueryParam.DESC);
        List<SciProjectChangeEntity> list = super.queryList(param);
        if(CollectionUtils.isEmpty(list)){
            return new ArrayList<>();
        }
        List<SciProjectChangeVO> result = BeanMapper.mapList(list, SciProjectChangeVO.class);
        for (SciProjectChangeVO vo : result) {
            String historyBillCode = vo.getCode() + "-" + (vo.getChangeVersion() - 1);
            vo.setHistoryBillCode(historyBillCode);
        }
        return result;
    }

    @Override
    public String validateProjectId(Long projectId, Long id, String operation) {
        //同一个项目只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, projectId));
        if(id != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<SciProjectChangeEntity> list = super.queryList(queryParam, false);
        List<SciProjectChangeEntity> freeList = list.stream().filter(x->1 !=x.getBillState() && 3 !=x.getBillState()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(freeList)) {
            throw new BusinessException("该科研项目存在非生效态的变更单，不能" + operation + "!");
        }
        return "校验成功！";
    }

    @Override
    public void validateHourByUser(List<SciProjectChangeUserEntity> userList) {
        if(CollectionUtils.isEmpty(userList)){
            return;
        }
        List<SciProjectChangeUserEntity> list = userList.stream().filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(list)){
            return;
        }
        List<SciProjectChangeUserHourEntity> saveList = list.stream().map(x->x.getHourList()).flatMap(Collection::stream).
                filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(saveList)){
            return;
        }
        List<Long> userIds = list.stream().map(x->x.getUserId()).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("userId", new Parameter(QueryParam.IN, userIds));
        List<Long> ids = saveList.stream().map(x->x.getSourceId()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(ids)){
            param.getParams().put("id", new Parameter(QueryParam.NOT_IN, ids));
        }
        List<SciProjectUserHourEntity> dataList = projectHourService.queryList(param);
        dataList = CollectionUtils.isNotEmpty(dataList) ? dataList : new ArrayList<>();
        dataList.addAll(BeanMapper.mapList(saveList, SciProjectUserHourEntity.class));
        Map<Long, Map<String, List<SciProjectUserHourEntity>>> userMap = dataList.stream().collect(
                Collectors.groupingBy(x->x.getUserId(), Collectors.groupingBy(x->x.getPlanYear())));
        StringBuilder message = new StringBuilder();
        for(Long userId : userMap.keySet()){
            Map<String, List<SciProjectUserHourEntity>> yearMap = userMap.get(userId);
            for(String year : yearMap.keySet()){
                BigDecimal hour = yearMap.get(year).stream().map(x->x.getPlanHour()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
                if(ComputeUtil.isGreaterThan(hour, ComputeUtil.toBigDecimal("12"))){
                    message.append("【" + yearMap.get(year).get(0).getUserName() + "】");
                    message.append("在【" + year + "年】参与的所有科研项目立项中的计划工时累计值已超12个月；/n");
                }
            }
        }
        if(message.length() > 0){
            throw new BusinessException(message.toString());
        }
    }

}
