package com.ejianc.business.scientific.sci.work.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.scientific.sci.work.service.IWorkTimeDetailService;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeDetailVO;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeReportVO;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scientific.sci.work.mapper.WorkTimeMapper;
import com.ejianc.business.scientific.sci.work.bean.WorkTimeEntity;
import com.ejianc.business.scientific.sci.work.service.IWorkTimeService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 科研管理-科研工时填报
 * 
 * @author generator
 * 
 */
@Service("workTimeService")
public class WorkTimeServiceImpl extends BaseServiceImpl<WorkTimeMapper, WorkTimeEntity> implements IWorkTimeService{


    private static final String BILL_CODE = "SCI_WORK_TIME";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IWorkTimeDetailService detailService;

    @Autowired
    private WorkTimeMapper mapper;

    @Autowired
    private SessionManager sessionManager;

    @Override
    public WorkTimeVO saveOrUpdate(WorkTimeVO saveOrUpdateVO) {

        WorkTimeEntity entity = BeanMapper.map(saveOrUpdateVO, WorkTimeEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(!billCode.isSuccess()) {
                //此处需要根据实际修改 删除本行或者上一行
                saveOrUpdateVO.setCheckMsg("网络异常， 编码生成失败， 请稍后再试");
                return saveOrUpdateVO;
            }
            entity.setBillCode(billCode.getData());

            UserContext user = sessionManager.getUserContext();
            if(StringUtils.isBlank(entity.getDeptName()) && StringUtils.isNotBlank(user.getDeptName())) {
                entity.setDeptId(user.getDeptId());
                entity.setDeptName(user.getDeptName());
            }

        }

        //查询当前科研项目是否存在非生效的单据
        QueryWrapper<WorkTimeEntity> validQuery = new QueryWrapper<>();
        validQuery.eq("project_id", entity.getProjectId());
        if(null != entity.getId()) {
            validQuery.ne("id", entity.getId());
        }
        validQuery.notIn("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List<WorkTimeEntity> dbList = super.list(validQuery);
        if(CollectionUtils.isNotEmpty(dbList)) {
            saveOrUpdateVO.setCheckMsg("该科研项目存在非生效态的工时填报单，不能重复新增！");
            return saveOrUpdateVO;
        }

        //查验当前科研项目是否已存在相同月份的工时填报单
        String errMsg = checkProject(saveOrUpdateVO);
        if(StringUtils.isNotBlank(errMsg)) {
            saveOrUpdateVO.setCheckMsg(errMsg);
            return saveOrUpdateVO;
        }

        //查验项目下成员当前月份 每个人总的工时
        if(CollectionUtils.isNotEmpty(saveOrUpdateVO.getDetailList())) {
            List<Long> userIds= new ArrayList<>(saveOrUpdateVO.getDetailList().stream().filter(item -> !"del".equals(item.getRowState())).map(WorkTimeDetailVO::getUserId).collect(Collectors.toSet()));
            Map<Long, BigDecimal> userTotalWorkTimeMap = detailService.countUserWorkTime(userIds, saveOrUpdateVO.getYearMonth(), saveOrUpdateVO.getId(), null);
            if(MapUtils.isNotEmpty(userTotalWorkTimeMap)) {
                List<String> userNames = new ArrayList<>();
                List<String> errMsgList = new ArrayList<>();
                saveOrUpdateVO.getDetailList().stream().filter(item -> !"del".equals(item.getRowState()) && userTotalWorkTimeMap.containsKey(item.getUserId())).forEach(item -> {
                    if(new BigDecimal("1").compareTo(ComputeUtil.safeAdd(item.getUserHour(), userTotalWorkTimeMap.get(item.getUserId()))) < 0) {
                        userNames.add(item.getUserName());
                        errMsgList.add("【"+item.getUserName()+"】本月所有科研项目累计工时已超1；");
                    }
                });

                if(CollectionUtils.isNotEmpty(errMsgList)) {
                    saveOrUpdateVO.setCheckMsg(errMsgList.stream().collect(Collectors.joining("\n")) + "不能保存！");
                    return saveOrUpdateVO;
                }
            }
            entity.getDetailList().stream().forEach(item -> item.setDetailYearMonth(saveOrUpdateVO.getYearMonth()));
        }

        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, WorkTimeVO.class);
    }

    @Override
    public List<WorkTimeDetailVO> checkUserWorkTime(WorkTimeVO saveOrUpdateVO) {
        List<WorkTimeDetailVO> resp = new ArrayList<>();
        //查验项目下成员当前月份 每个人总的工时
        if(CollectionUtils.isNotEmpty(saveOrUpdateVO.getDetailList())) {
            List<Long> userIds= new ArrayList<>(saveOrUpdateVO.getDetailList().stream().filter(item -> !"del".equals(item.getRowState())).map(WorkTimeDetailVO::getUserId).collect(Collectors.toSet()));
            Map<Long, BigDecimal> userTotalWorkTimeMap = detailService.countUserWorkTime(userIds, saveOrUpdateVO.getYearMonth(), saveOrUpdateVO.getId(), null);
            if(MapUtils.isNotEmpty(userTotalWorkTimeMap)) {
                List<String> userNames = new ArrayList<>();
                saveOrUpdateVO.getDetailList().stream().filter(item -> !"del".equals(item.getRowState()) && userTotalWorkTimeMap.containsKey(item.getUserId())).forEach(item -> {
                    if(new BigDecimal("1").compareTo(ComputeUtil.safeAdd(item.getUserHour(), userTotalWorkTimeMap.get(item.getUserId()))) < 0) {
                        resp.add(item);
                    }
                });
            }
        }
        return resp;
    }

    @Override
    public String checkProject(WorkTimeVO saveOrUpdateVO) {
        QueryWrapper<WorkTimeEntity> query = new QueryWrapper<>();
        query.eq("project_id", saveOrUpdateVO.getProjectId());
        query.eq("year_month", saveOrUpdateVO.getYearMonth());
        if(null != saveOrUpdateVO.getId()) {
            query.ne("id", saveOrUpdateVO.getId());
        }

        List<WorkTimeEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            return "该科研项目在该月份已填报，不能重复新增！";
        }
        return null;
    }

    @Override
    public List<WorkTimeReportVO> pageReport(WorkTimeReportVO params) {
        return mapper.pageReport(params);
    }

    @Override
    public Map<Long, BigDecimal> getUserWorkTime(List<Long> userIds, String yearMonth) {
        return this.getUserWorkTime(userIds, yearMonth, null);
    }
    @Override
    public Map<Long, BigDecimal> getUserWorkTime(List<Long> userIds, String yearMonth, Long projectId) {
        return detailService.countUserWorkTime(userIds, yearMonth, null, projectId);
    }

    @Override
    public Long countReport(Map<String, Object> params) {
        return mapper.countReport(params);
    }
}
