/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.sci.work.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.scientific.sci.work.bean.WorkTimeDetailEntity;
import com.ejianc.business.scientific.sci.work.mapper.WorkTimeDetailMapper;
import com.ejianc.business.scientific.sci.work.service.IWorkTimeDetailService;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="workTimeDetailService")
public class WorkTimeDetailServiceImpl
extends BaseServiceImpl<WorkTimeDetailMapper, WorkTimeDetailEntity>
implements IWorkTimeDetailService {
    @Autowired
    private WorkTimeDetailMapper mapper;

    @Override
    public Map<Long, BigDecimal> countUserWorkTime(List<Long> userIds, String yearMonth, Long pid, Long projectId) {
        HashMap<Long, BigDecimal> resp = new HashMap<Long, BigDecimal>();
        List<Map<String, Object>> result = this.mapper.countUserWorkTime(userIds, yearMonth, pid, projectId);
        if (CollectionUtils.isNotEmpty(result)) {
            for (Map<String, Object> m : result) {
                resp.put(Long.valueOf(m.get("userId").toString()), new BigDecimal(m.get("totalHour").toString()));
            }
        }
        return resp;
    }

    @Override
    public Map<Long, List<JSONObject>> queryUserWorkTime(List<Long> userIds, String yearMonth, Long pid, Long projectId) {
        List<Map<String, Object>> result = this.mapper.queryUserWorkTime(userIds, yearMonth, pid, projectId);
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        if (CollectionUtils.isNotEmpty(result)) {
            for (Map<String, Object> m : result) {
                JSONObject obj = new JSONObject();
                obj.put("userId", (Object)Long.valueOf(m.get("userId").toString()));
                obj.put("totalHour", (Object)ComputeUtil.toBigDecimal((Object)m.get("totalHour")));
                obj.put("projectName", (Object)m.get("projectName").toString());
                list.add(obj);
            }
        }
        Map<Long, List<JSONObject>> resp = list.stream().collect(Collectors.groupingBy(x -> x.getLong("userId")));
        return resp;
    }
}

