package com.ejianc.business.scientific.sci.work.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scientific.sci.work.mapper.UserMonthWorkTimeStaticDetailMapper;
import com.ejianc.business.scientific.sci.work.bean.UserMonthWorkTimeStaticDetailEntity;
import com.ejianc.business.scientific.sci.work.service.IUserMonthWorkTimeStaticDetailService;

import java.util.List;

/**
 * 员工月度工时统计子表
 * 
 * @author generator
 * 
 */
@Service("userMonthWorkTimeStaticDetailService")
public class UserMonthWorkTimeStaticDetailServiceImpl extends BaseServiceImpl<UserMonthWorkTimeStaticDetailMapper, UserMonthWorkTimeStaticDetailEntity> implements IUserMonthWorkTimeStaticDetailService{


    @Autowired
    private UserMonthWorkTimeStaticDetailMapper mapper;

    @Override
    public List<UserMonthWorkTimeStaticDetailEntity> getByPid(Long pid) {
        QueryWrapper<UserMonthWorkTimeStaticDetailEntity> query = new QueryWrapper<>();
        query.eq("pid", pid);
        return super.list(query);
    }

    @Override
    public List<UserMonthWorkTimeStaticDetailEntity> staticByYearMonth(String yearMonth) {
        return mapper.staticByYearMonth(yearMonth);
    }
}
