/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.sci.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class ListCallable
implements Callable<JSONArray> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RequestAttributes context = RequestContextHolder.getRequestAttributes();
    private String url;
    private QueryParam queryParam;
    private IBaseService service;
    private Boolean pageDataResp = true;

    public static Future<JSONArray> excute(ExecutorService threadPool, QueryParam queryParam, IBaseService service) {
        ListCallable callable = new ListCallable(queryParam, service);
        Future<JSONArray> future = threadPool.submit(callable);
        return future;
    }

    public ListCallable(QueryParam queryParam, IBaseService service) {
        this.queryParam = queryParam;
        this.service = service;
    }

    public static Future<JSONArray> excute(ExecutorService threadPool, String url, QueryParam queryParam) {
        ListCallable callable = new ListCallable(url, queryParam);
        Future<JSONArray> future = threadPool.submit(callable);
        return future;
    }

    public static Future<JSONArray> excute(ExecutorService threadPool, String url, QueryParam queryParam, boolean pageDataResp) {
        ListCallable callable = new ListCallable(url, queryParam, pageDataResp);
        Future<JSONArray> future = threadPool.submit(callable);
        return future;
    }

    public ListCallable(String url, QueryParam queryParam) {
        this.url = url;
        this.queryParam = queryParam;
    }

    public ListCallable(String url, QueryParam queryParam, Boolean pageDataResp) {
        this.url = url;
        this.queryParam = queryParam;
        this.pageDataResp = pageDataResp;
    }

    @Override
    public JSONArray call() throws Exception {
        if (this.service == null) {
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            String resp = HttpTookit.postByJson((String)this.url, (String)JSONObject.toJSONString((Object)this.queryParam));
            JSONObject json = JSONObject.parseObject((String)resp);
            if (json.getInteger("code") != 0) {
                this.logger.error("\u83b7\u53d6URL-{}\u5217\u8868\u5931\u8d25\uff1a{}", (Object)this.url, (Object)json.getString("msg"));
                return new JSONArray();
            }
            if (this.pageDataResp.booleanValue()) {
                JSONObject data = json.getJSONObject("data");
                if (data == null) {
                    return new JSONArray();
                }
                return data.getJSONArray("records");
            }
            return json.getJSONArray("data");
        }
        List list = this.service.queryList(this.queryParam, false);
        String json = JSON.toJSONString((Object)list);
        JSONArray records = JSONArray.parseArray((String)json);
        return records;
    }
}

