package com.ejianc.business.scientific.sci.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.scientific.sci.bean.FeeConfirmDetailEntity;
/**
 * 科研经费确认
 * 
 * @author generator
 * 
 */
 @TableName("ejc_scientific_fee_confirm")
public class FeeConfirmEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织
    @TableField(value="project_id")
    private Long projectId; // 科研项目主键
    @TableField(value="project_name")
    private String projectName; // 科研项目名称
    @TableField(value="project_type")
    private String projectType; // 科研项目类型:1-横向科研 2-纵向科研
    @TableField(value="manager_id")
    private Long managerId; // 项目负责人主键
    @TableField(value="manager_name")
    private String managerName; // 项目负责人
    @TableField(value="employee_id")
    private Long employeeId; // 经办人主键
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="dept_id")
    private Long deptId; // 经办部门主键
    @TableField(value="dept_name")
    private String deptName; // 经办部门
    @TableField(value="memo")
    private String memo; // 完成情况
    @TableField(value="source_type")
    private String sourceType; // 单据来源：1-内部 2-外部
    @TableField(value="apply_date")
    private Date applyDate; // 申请日期
    @TableField(value="budget_mny")
    private BigDecimal budgetMny; // 经费预算
    @TableField(value="last_apply_mny")
    private BigDecimal lastApplyMny; // 截止上期累计申请金额
    @TableField(value="sum_apply_mny")
    private BigDecimal sumApplyMny; // 累计申请金额
    @TableField(value="apply_mny")
    private BigDecimal applyMny; // 本次申请金额
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="feeConfirmDetailService")
    private List<FeeConfirmDetailEntity> detailList = new ArrayList<>(); // 科研经费确认-费用明细
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public Long getManagerId() {
        return managerId;
    }

    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }
    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    public BigDecimal getLastApplyMny() {
        return lastApplyMny;
    }

    public void setLastApplyMny(BigDecimal lastApplyMny) {
        this.lastApplyMny = lastApplyMny;
    }
    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    

    public List<FeeConfirmDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<FeeConfirmDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
