package com.ejianc.business.scientific.sci.service.impl;

import com.ejianc.business.scientific.sci.bean.*;
import com.ejianc.business.scientific.sci.mapper.SciProjectHistoryMapper;
import com.ejianc.business.scientific.sci.service.ISciProjectHistoryBudgetYearService;
import com.ejianc.business.scientific.sci.service.ISciProjectHistoryService;
import com.ejianc.business.scientific.sci.service.ISciProjectHistoryUserHourService;
import com.ejianc.business.scientific.sci.service.ISciProjectHistoryUserService;
import com.ejianc.business.scientific.sci.vo.SciProjectHistoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 科研项目立项-历史
 * 
 * @author generator
 * 
 */
@Service("sciProjectHistoryService")
public class SciProjectHistoryServiceImpl extends BaseServiceImpl<SciProjectHistoryMapper, SciProjectHistoryEntity> implements ISciProjectHistoryService{

    @Autowired
    private ISciProjectHistoryUserService userService;

    @Autowired
    private ISciProjectHistoryUserHourService hourService;

    @Autowired
    private ISciProjectHistoryBudgetYearService yearService;

    @Override
    public SciProjectHistoryVO queryDetailByChangeId(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("changeId", new Parameter(QueryParam.EQ, id));
        List<SciProjectHistoryEntity> list = super.queryList(param);
        if(CollectionUtils.isEmpty(list)){
            return new SciProjectHistoryVO();
        }
        SciProjectHistoryEntity entity = super.selectById(list.get(0).getId());
        // 处理孙表
        if(CollectionUtils.isNotEmpty(entity.getUserList())){
            List<Long> ids = entity.getUserList().stream().map(x->x.getId()).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("pid", new Parameter(QueryParam.IN, ids));
            List<SciProjectHistoryUserHourEntity> hourList = hourService.queryList(queryParam);
            Map<Long, List<SciProjectHistoryUserHourEntity>> hourMap = hourList.stream().collect(Collectors.groupingBy(x->x.getPid()));
            for(SciProjectHistoryUserEntity user : entity.getUserList()){
                if(hourMap.containsKey(user.getId())){
                    user.setHourList(hourMap.get(user.getId()));
                }
            }
        }
        if(CollectionUtils.isNotEmpty(entity.getBudgetList())){
            List<Long> ids = entity.getBudgetList().stream().map(x->x.getId()).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("pid", new Parameter(QueryParam.IN, ids));
            List<SciProjectHistoryBudgetYearEntity> yearList = yearService.queryList(queryParam);
            Map<Long, List<SciProjectHistoryBudgetYearEntity>> yearMap = yearList.stream().collect(Collectors.groupingBy(x->x.getPid()));
            for(SciProjectHistoryBudgetEntity budget : entity.getBudgetList()){
                if(yearMap.containsKey(budget.getId())){
                    budget.setYearList(yearMap.get(budget.getId()));
                }
            }
        }
        return BeanMapper.map(entity, SciProjectHistoryVO.class);
    }
}
