/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scientific.sci.work.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.scientific.sci.work.bean.WorkTimeEntity;
import com.ejianc.business.scientific.sci.work.mapper.WorkTimeMapper;
import com.ejianc.business.scientific.sci.work.service.IWorkTimeDetailService;
import com.ejianc.business.scientific.sci.work.service.IWorkTimeService;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeDetailVO;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeReportVO;
import com.ejianc.business.scientific.sci.work.vo.WorkTimeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="workTimeService")
public class WorkTimeServiceImpl
extends BaseServiceImpl<WorkTimeMapper, WorkTimeEntity>
implements IWorkTimeService {
    private static final String BILL_CODE = "SCI_WORK_TIME";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IWorkTimeDetailService detailService;
    @Autowired
    private WorkTimeMapper mapper;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public WorkTimeVO saveOrUpdate(WorkTimeVO saveOrUpdateVO) {
        WorkTimeEntity entity = (WorkTimeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WorkTimeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                saveOrUpdateVO.setCheckMsg("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                return saveOrUpdateVO;
            }
            entity.setBillCode((String)billCode.getData());
            UserContext user = this.sessionManager.getUserContext();
            if (StringUtils.isBlank((CharSequence)entity.getDeptName()) && StringUtils.isNotBlank((CharSequence)user.getDeptName())) {
                entity.setDeptId(user.getDeptId());
                entity.setDeptName(user.getDeptName());
            }
        }
        QueryWrapper validQuery = new QueryWrapper();
        validQuery.eq((Object)"project_id", (Object)entity.getProjectId());
        if (null != entity.getId()) {
            validQuery.ne((Object)"id", (Object)entity.getId());
        }
        validQuery.notIn((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List dbList = super.list((Wrapper)validQuery);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            saveOrUpdateVO.setCheckMsg("\u8be5\u79d1\u7814\u9879\u76ee\u5b58\u5728\u975e\u751f\u6548\u6001\u7684\u5de5\u65f6\u586b\u62a5\u5355\uff0c\u4e0d\u80fd\u91cd\u590d\u65b0\u589e\uff01");
            return saveOrUpdateVO;
        }
        String errMsg = this.checkProject(saveOrUpdateVO);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            saveOrUpdateVO.setCheckMsg(errMsg);
            return saveOrUpdateVO;
        }
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getDetailList())) {
            ArrayList<Long> userIds = new ArrayList<Long>(saveOrUpdateVO.getDetailList().stream().filter(item -> !"del".equals(item.getRowState())).map(WorkTimeDetailVO::getUserId).collect(Collectors.toSet()));
            Map<Long, List<JSONObject>> timeMap = this.detailService.queryUserWorkTime(userIds, saveOrUpdateVO.getYearMonth(), saveOrUpdateVO.getId(), null);
            if (MapUtils.isNotEmpty(timeMap)) {
                ArrayList userNames = new ArrayList();
                ArrayList errMsgList = new ArrayList();
                saveOrUpdateVO.getDetailList().stream().filter(item -> !"del".equals(item.getRowState()) && timeMap.containsKey(item.getUserId())).forEach(item -> {
                    BigDecimal totalHour = ((List)timeMap.get(item.getUserId())).stream().map(x -> x.getBigDecimal("totalHour")).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
                    String projectNames = ((List)timeMap.get(item.getUserId())).stream().map(x -> "\u3010" + x.getString("projectName") + "\u3011").collect(Collectors.joining());
                    if (new BigDecimal("1").compareTo(ComputeUtil.safeAdd((BigDecimal)item.getUserHour(), (BigDecimal)totalHour)) < 0) {
                        userNames.add(item.getUserName());
                        errMsgList.add("\u3010" + item.getUserName() + "\u3011\u672c\u6708\u6240\u6709\u79d1\u7814\u9879\u76ee\u7d2f\u8ba1\u5de5\u65f6\u5df2\u8d851\uff0c\u8be5\u4eba\u5458\u672c\u6708\u4efd\u53c2\u4e0e\u7684\u6240\u6709\u79d1\u7814\u9879\u76ee\u6709\uff1a" + projectNames + "\uff1b");
                    }
                });
                if (CollectionUtils.isNotEmpty(errMsgList)) {
                    saveOrUpdateVO.setCheckMsg(errMsgList.stream().collect(Collectors.joining("\n")) + "\u4e0d\u80fd\u4fdd\u5b58\uff01");
                    return saveOrUpdateVO;
                }
            }
            entity.getDetailList().stream().forEach(item -> item.setDetailYearMonth(saveOrUpdateVO.getYearMonth()));
        }
        super.saveOrUpdate((Object)entity, false);
        return (WorkTimeVO)BeanMapper.map((Object)((Object)entity), WorkTimeVO.class);
    }

    @Override
    public List<WorkTimeDetailVO> checkUserWorkTime(WorkTimeVO saveOrUpdateVO) {
        ArrayList<Long> userIds;
        Map<Long, BigDecimal> userTotalWorkTimeMap;
        ArrayList<WorkTimeDetailVO> resp = new ArrayList<WorkTimeDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getDetailList()) && MapUtils.isNotEmpty(userTotalWorkTimeMap = this.detailService.countUserWorkTime(userIds = new ArrayList<Long>(saveOrUpdateVO.getDetailList().stream().filter(item -> !"del".equals(item.getRowState())).map(WorkTimeDetailVO::getUserId).collect(Collectors.toSet())), saveOrUpdateVO.getYearMonth(), saveOrUpdateVO.getId(), null))) {
            ArrayList userNames = new ArrayList();
            saveOrUpdateVO.getDetailList().stream().filter(item -> !"del".equals(item.getRowState()) && userTotalWorkTimeMap.containsKey(item.getUserId())).forEach(item -> {
                if (new BigDecimal("1").compareTo(ComputeUtil.safeAdd((BigDecimal)item.getUserHour(), (BigDecimal)((BigDecimal)userTotalWorkTimeMap.get(item.getUserId())))) < 0) {
                    resp.add((WorkTimeDetailVO)item);
                }
            });
        }
        return resp;
    }

    @Override
    public String checkProject(WorkTimeVO saveOrUpdateVO) {
        List dbList;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)saveOrUpdateVO.getProjectId());
        query.eq((Object)"year_month", (Object)saveOrUpdateVO.getYearMonth());
        if (null != saveOrUpdateVO.getId()) {
            query.ne((Object)"id", (Object)saveOrUpdateVO.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(dbList = super.list((Wrapper)query)))) {
            return "\u8be5\u79d1\u7814\u9879\u76ee\u5728\u8be5\u6708\u4efd\u5df2\u586b\u62a5\uff0c\u4e0d\u80fd\u91cd\u590d\u65b0\u589e\uff01";
        }
        return null;
    }

    @Override
    public List<WorkTimeReportVO> pageReport(WorkTimeReportVO params) {
        return this.mapper.pageReport(params);
    }

    @Override
    public Map<Long, BigDecimal> getUserWorkTime(List<Long> userIds, String yearMonth) {
        return this.getUserWorkTime(userIds, yearMonth, null);
    }

    @Override
    public Map<Long, BigDecimal> getUserWorkTime(List<Long> userIds, String yearMonth, Long projectId) {
        return this.detailService.countUserWorkTime(userIds, yearMonth, null, projectId);
    }

    @Override
    public Long countReport(Map<String, Object> params) {
        return this.mapper.countReport(params);
    }
}

