package com.ejianc.integration.sdbjmaterial.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

@Component("pageUtil")
public class PageUtil<T> {

    /**
     * List转Page
     * @param list 所有记录
     * @param current 当前页，默认 1
     * @param size 当前分页总页数
     * @param <T> 泛型
     * @return
     */
    public static <T> List<T> listToPage(List<T> list, int current, int size) {
        if(size == -1){
            return list;
        }
        current = (current - 1) * size;// 每页的起始索引
        Integer total = list.size();// 记录总数
        if (current + size > total) {
            return list.subList(current, total);
        } else {
            return list.subList(current, total > size ? current + size : current + total);
        }
    }

    /**
     * JSONArray转Page
     * @param array 所有记录
     * @param current 当前页，默认 1
     * @param size 当前分页总页数
     * @return
     */
    public static JSONArray listToPage(JSONArray array, int current, int size) {
        if(size == -1){
            return array;
        }
        current = (current - 1) * size;// 每页的起始索引
        Integer total = array.size();// 记录总数
        if (current + size > total) {
            return new JSONArray(array.subList(current, total));
        } else {
            return new JSONArray(array.subList(current, total > size ? current + size : current + total));
        }
    }

    /**
     * 获取页数
     * @param total
     * @param size
     * @return
     */
    public static Integer getPages(Integer total, Integer size) {
        Integer pages = 0;
        if (size == -1) {
            pages = 1;
        } else if (total % size > 0) {
            pages = (total / size) + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }
        return pages;
    }


    /**
     * 判断模糊搜索是否包含
     * @param searchText
     * @param t
     * @param fileds
     * @param <T>
     * @return
     */
    public static <T> boolean contains(String searchText, T t, String... fileds){
        if(StringUtils.isEmpty(searchText)){
            return true;
        }
        JSONObject vo = JSONObject.parseObject(JSONObject.toJSONString(t));
        boolean flag = false;
        for(String filed : fileds){
            String filedValue = vo.getString(filed);
            flag = flag || (StringUtils.isNotEmpty(filedValue) && filedValue.contains(searchText));
        }
        return flag;
    }
}