/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.integration.sdbjmaterial.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="pageUtil")
public class PageUtil<T> {
    public static <T> List<T> listToPage(List<T> list, int current, int size) {
        if (size == -1) {
            return list;
        }
        Integer total = list.size();
        if ((current = (current - 1) * size) + size > total) {
            return list.subList(current, total);
        }
        return list.subList(current, total > size ? current + size : current + total);
    }

    public static JSONArray listToPage(JSONArray array, int current, int size) {
        if (size == -1) {
            return array;
        }
        Integer total = array.size();
        if ((current = (current - 1) * size) + size > total) {
            return new JSONArray(array.subList(current, total.intValue()));
        }
        return new JSONArray(array.subList(current, total > size ? current + size : current + total));
    }

    public static Integer getPages(Integer total, Integer size) {
        Integer pages = 0;
        if (size == -1) {
            pages = 1;
        } else if (total % size > 0) {
            pages = total / size + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }
        return pages;
    }

    public static <T> boolean contains(String searchText, T t, String ... fileds) {
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            return true;
        }
        JSONObject vo = JSONObject.parseObject((String)JSONObject.toJSONString(t));
        boolean flag = false;
        for (String filed : fileds) {
            String filedValue = vo.getString(filed);
            flag = flag || StringUtils.isNotEmpty((CharSequence)filedValue) && filedValue.contains(searchText);
        }
        return flag;
    }
}

