package com.ejianc.business.panhuo.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.panhuo.bean.CollectEntity;
import com.ejianc.business.panhuo.bean.GoodsEntity;
import com.ejianc.business.panhuo.bean.OrderEntity;
import com.ejianc.business.panhuo.service.ICollectService;
import com.ejianc.business.panhuo.service.IGoodsService;
import com.ejianc.business.panhuo.service.IOrderService;
import com.ejianc.business.panhuo.vo.GoodsDetailsVO;
import com.ejianc.business.panhuo.vo.GoodsVO;
import com.ejianc.business.panhuo.vo.ReportVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 资产表
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("goods")
public class GoodsController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IGoodsService service;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private ICollectService collectService;

    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IAttachmentApi iAttachmentApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${weChat.cgdd-agentid}")
    private String cgddAgentid;

    @Value("${weChat.cgdd-secret}")
    private String cgddSecret;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GoodsVO> saveOrUpdate(@RequestBody GoodsVO saveorUpdateVO) {
        return CommonResponse.success("操作成功！", service.saveGoods(saveorUpdateVO));
    }

    /**
     * @Description updateMainimgPath 修改主图
     */
    @RequestMapping(value = "/updateMainimgPath", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateMainimgPath(@RequestBody GoodsVO saveorUpdateVO) {
        LambdaUpdateWrapper<GoodsEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(GoodsEntity::getId, saveorUpdateVO.getId());
        updateWrapper.set(GoodsEntity::getMainimgPath, saveorUpdateVO.getMainimgPath());
        service.update(updateWrapper);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GoodsVO> queryDetail(Long id) {
        GoodsEntity entity = service.selectById(id);
        GoodsVO vo = BeanMapper.map(entity, GoodsVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 复制上架
     */
    @RequestMapping(value = "/queryCopyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GoodsVO> queryCopyDetail(Long id) {
        GoodsEntity entity = service.selectById(id);
        GoodsVO vo = BeanMapper.map(entity, GoodsVO.class);
//        vo.setId(null);
        vo.setBillCode(null);
        vo.setLower(null);
        vo.setLowerTime(null);
        vo.setLowerType(null);
        vo.setSeller(null);
        vo.setSellerName(null);
        vo.setToolId(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setRotatableNums(entity.getNums());
        vo.setSellNums(BigDecimal.ZERO);
        vo.setPreNums(BigDecimal.ZERO);
        vo.setRotatableNums(entity.getNums());

//        if(CollectionUtils.isNotEmpty(vo.getImgsPath())){
//            vo.getImgsPath().forEach(e -> {
//                e.setSourceId(null);
//                e.setRowState("add");
//            });
//        }
        vo.setId(IdWorker.getId());
        CommonResponse<String> response = iAttachmentApi.copyFilesFromSourceBillToTargetBill(
                id.toString(),
                "BT200813000000001",
                "imgUpload",
                vo.getId().toString(),
                "BT200813000000001",
                "imgUpload"
        );
        if (!response.isSuccess()) {
            return CommonResponse.error(response.getMsg());
        }
        if (CollectionUtils.isNotEmpty(vo.getLabels())) {
            vo.getLabels().forEach(e -> {
                e.setSourceId(null);
                e.setRowState("add");
            });
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GoodsVO> vos) {
        LambdaQueryWrapper<OrderEntity> lambdachange = Wrappers.<OrderEntity>lambdaQuery();
        lambdachange.eq(OrderEntity::getGoodsId, vos.get(0).getId());
        List<OrderEntity> list = orderService.list(lambdachange);
        if (CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.error("该商品存在订单,不允许删除");
        }
        service.removeByIds(vos.stream().map(GoodsVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("rotatableNums", new Parameter(QueryParam.GT, 0));
        Parameter lon = param.getParams().get("lon");
        Parameter lat = param.getParams().get("lat");
        param.getParams().remove("lon");
        param.getParams().remove("lat");
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        if (null != lon && null != lat) {
            Page<GoodsEntity> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
            QueryWrapper wrapper = changeToQueryWrapper(param);
            List<GoodsEntity> list = service.queryGoods(page, wrapper, lon.getValue() + "", lat.getValue() + "");
            res.put("records", BeanMapper.mapList(list, GoodsVO.class));
            res.put("total", page.getTotal());
            res.put("current", page.getCurrent());
            res.put("size", page.getSize());
            res.put("pages", page.getPages());
        } else {
            IPage<GoodsEntity> page = service.queryPage(param, false);
            IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            res.put("records", page.getRecords());
            res.put("total", page.getTotal());
            res.put("current", page.getCurrent());
            res.put("size", page.getSize());
            res.put("pages", page.getPages());
        }
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @param id
     * @Description queryGoodsDetail  资产集市-查询详情(带周转记录，其他项目等信息)
     */
    @RequestMapping(value = "/queryGoodsDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<GoodsDetailsVO> queryGoodsDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryGoodsDetail(id));
    }

    /**
     * @param
     * @Description queryGoodsDetail  资产详情 - 卖家所有在售信息
     */
    @RequestMapping(value = "/queryOtherGoods", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryOtherGoods(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("spec");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("rotatableNums", new Parameter(QueryParam.GT, 0));
        IPage<GoodsEntity> page = service.queryPage(param, false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));
        return CommonResponse.success("查询数据成功！", pageData);
    }

    /**
     * @param param
     * @Description queryList 我的货架-出售中
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryGoodsIng", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsIng(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 0));
        Parameter isMyGoods = param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if (null != isMyGoods && isMyGoods.getValue().toString().contains("0") && isMyGoods.getValue().toString().contains("1")) {
            param.getParams().remove("seller");
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().remove("seller");
        }
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
        }
        IPage<GoodsEntity> page = service.queryPage(param, false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description queryList 我的货架-已下架
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryGoodsEnd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsEnd(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 1));
        Parameter isMyGoods = param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if (null != isMyGoods && isMyGoods.getValue().toString().contains("0") && isMyGoods.getValue().toString().contains("1")) {
            param.getParams().remove("seller");
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().remove("seller");
        }
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
        }
        IPage<GoodsEntity> page = service.queryPage(param, false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description queryList 我的货架-出售中
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryGoodsTemp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryGoodsTemp(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("projectName");
        fuzzyFields.add("address");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 2));
        Parameter isMyGoods = param.getParams().get("isMyGoods");
        param.getParams().remove("isMyGoods");
        if (null != isMyGoods && isMyGoods.getValue().toString().contains("0") && isMyGoods.getValue().toString().contains("1")) {
            param.getParams().remove("seller");
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().put("seller", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUserid()));
        } else if (null != isMyGoods && isMyGoods.getValue().toString().contains("0")) {
            param.getParams().remove("seller");
        }
        CommonResponse<List<OrgVO>> childOrgResp = orgApi.findProjectOrgsByUserId(InvocationInfoProxy.getUserid());
        if (!childOrgResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<Long> childIds = new ArrayList<>();
        childIds.addAll(childOrgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(childIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, childIds));
        }
        IPage<GoodsEntity> page = service.queryPage(param, false);
        IPage<GoodsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), GoodsVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description updateStatus 下架
     */
    @RequestMapping(value = "/updateStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GoodsVO> updateStatus(@RequestBody GoodsVO saveorUpdateVO) {
        GoodsEntity entity = service.selectById(saveorUpdateVO.getId());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("goods_id", new Parameter(QueryParam.EQ, saveorUpdateVO.getId()));
        queryParam.getParams().put("type", new Parameter(QueryParam.EQ, 0));
        List<OrderEntity> listOrder = orderService.queryList(queryParam, false);
        if (null != listOrder && listOrder.size() > 0) {
            return CommonResponse.error(5001, "存在未完成的订单,不允许下架！");
        }
        entity.setStatus(1);//下架
        entity.setLowerType(0);//下架类型0-手动下架，1-售罄下架，2-到期下架
        entity.setLower(InvocationInfoProxy.getUserid());
        entity.setLowerTime(DateFormater.getCurrentDate());
        service.saveOrUpdate(entity, false);
        GoodsVO vo = BeanMapper.map(entity, GoodsVO.class);
        return CommonResponse.success("操作成功！", vo);
    }

    /**
     * @Description shelfGoods 定时下架到期资产
     */
    @RequestMapping(value = "/shelfGoods", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse shelfGoods(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param);
        logger.info("获取到的参数JSON是：" + param + "----");
        int day = json.getJSONObject(0).getJSONArray("parameters").getJSONObject(0).getInteger("value");
        logger.info("获取到的参数是：" + day + "----");
        logger.debug("参数----" + day);
        if (day > 0) {
            Calendar calendar = Calendar.getInstance();
            /* HOUR_OF_DAY 指示一天中小时 */
            calendar.set(Calendar.DAY_OF_YEAR, calendar.get(Calendar.DAY_OF_YEAR) - day);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            logger.info(("加上参数的时间：" + df.format(calendar.getTime())));
            //获取资产到期数据
            LambdaQueryWrapper<GoodsEntity> lambdachange = Wrappers.<GoodsEntity>lambdaQuery();
            lambdachange.le(GoodsEntity::getShelfTime, df.format(calendar.getTime()));
            lambdachange.eq(GoodsEntity::getStatus, 0);
            List<GoodsEntity> list = service.list(lambdachange);
            if (CollectionUtils.isNotEmpty(list)) {
                logger.debug("开始循环设置----" + list.size());
                List<GoodsEntity> listUp = new ArrayList<>();
                Map<Long, List<GoodsEntity>> map = new HashMap<>();
                list.forEach(entity -> {
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, entity.getTenantId()));
                    queryParam.getParams().put("goods_id", new Parameter(QueryParam.EQ, entity.getId()));
                    queryParam.getParams().put("type", new Parameter(QueryParam.EQ, 0));
                    List<OrderEntity> listOrder = orderService.queryList(queryParam, false);
                    if (null == listOrder || listOrder.size() <= 0) {  //不存在未完成订单，可下架
                        logger.debug("开始设置下架----");
                        entity.setStatus(1);//下架
                        entity.setLowerType(2);//下架类型0-手动下架，1-售罄下架，2-到期下架
                        entity.setLower(99999L);
                        entity.setLowerTime(DateFormater.getCurrentDate());
                        listUp.add(entity);
                        //为发消息做准备
                        if (map.containsKey(entity.getSeller())) {
                            map.get(entity.getSeller()).add(entity);
                        } else {
                            List<GoodsEntity> listGoods = new ArrayList<>();
                            listGoods.add(entity);
                            map.put(entity.getSeller(), listGoods);
                        }

                    }
                });

                for (Map.Entry<Long, List<GoodsEntity>> entry : map.entrySet()) {
                    // TO DO 定时到期下架消息发送
                    List<String> messageType = new ArrayList<>();
                    messageType.add("sys");
                    messageType.add("weChat");
                    List<String> sender = new ArrayList<>();
                    sender.add(entry.getKey() + "");
                    logger.info("发送信息给发布人:>----------" + sender + baseHost);
                    String formurl = baseHost + "ejc-sdbjpanhuo-frontend/#/shelfManagement?activeKey=2&isMyGoods=0&lowerType=2&lowerTime=" + DateFormater.getInstance().format(DateFormater.SHORT_FORMAT);
                    String subject = "您上架的物资有【" + entry.getValue().size() + "】件今日到期自动下架";
                    String content = "您上架的物资有【" + entry.getValue().size() + "】件今日到期自动下架。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
                    this.sendMsg(messageType, sender, "notice", subject, content);
                }
                if (CollectionUtils.isNotEmpty(listUp)) {
                    service.updateBatchById(listUp);
                }
            }
        }
        return CommonResponse.success("运行成功！");
    }

    public static void main(String[] args) {
        Calendar calendar2 = Calendar.getInstance();
        /* HOUR_OF_DAY 指示一天中小时 */
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd");
        System.out.println();
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        if (messageType.contains("smsg")) {
            // 短信消息
            // channel.add(PushMsgParameter.CHANNEL_TYPE_NOTE);
        }
        if (messageType.contains("weChat")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());

        if (messageType.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", cgddAgentid);
            weixineeParams.put("secret", cgddSecret);
            weixineeParams.put("msgtype", "textcard");
            weixineeParams.put("title", "消息提醒");
            weixineeParams.put("description", subject);
            weixineeParams.put("url", baseHost + "ejc-sdbjpanhuo-mobile/#/goodsManage?tab=1&userid={userid}");
            weixineeParams.put("btntxt", "点击查看");
            parameter.setWeixineeParams(weixineeParams);
        }
        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }


    /**
     * pc端，首页统计分析
     */
    @RequestMapping(value = "/orgStatistics", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReportVO> orgStatistics(Long orgId) {
        ReportVO res = service.orgStatistics(orgId);
        return CommonResponse.success("查询成功！", res);
    }

    /**
     * pc端，期间对比分析
     */
    @RequestMapping(value = "/periodStatistics", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ReportVO>> periodStatistics() {
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        List<ReportVO> res = service.periodStatistics(commonOrgIds);
        return CommonResponse.success("查询成功！", res);
    }

    /**
     * pc端，比例分析
     */
    @RequestMapping(value = "/proportion", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ReportVO>> proportion(int type) {
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success("查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        List<ReportVO> res = service.proportion(commonOrgIds, type);
        return CommonResponse.success("查询成功！", res);
    }

    /**
     * 下级单位使用分析
     */
    @RequestMapping(value = "/subordinateReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ReportVO>> subordinateReport() {
        List<ReportVO> res = new ArrayList<>();
        CommonResponse<List<OrgVO>> childrenOrg = orgApi.getDirectChildrenByPid(InvocationInfoProxy.getOrgId(), null);
        if (CollectionUtils.isNotEmpty(childrenOrg.getData())) {
            childrenOrg.getData().forEach(e -> {
                ReportVO vo = service.orgStatistics(e.getId());
                vo.setOrgName(e.getName());
                res.add(vo);
            });
        }
        return CommonResponse.success("查询成功！", res);
    }

    /**
     * PM推送闲置设备接口
     */
    @RequestMapping(value = "/receiveEquipment", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GoodsVO> receiveEquipment(@RequestBody GoodsVO saveorUpdateVO) {
        return CommonResponse.success("操作成功！", service.receiveEquipment(saveorUpdateVO));
    }
    /**
     * PM修改闲置状态接口
     */
    @RequestMapping(value = "/updateEquipmentStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateEquipmentStatus(@RequestBody GoodsVO saveorUpdateVO) {
        return CommonResponse.success("操作成功！", service.updateEquipmentStatus(saveorUpdateVO));
    }
}
