package com.ejianc.business.panhuo.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.panhuo.bean.AllotEntity;
import com.ejianc.business.panhuo.mapper.AllotMapper;
import com.ejianc.business.panhuo.service.IAllotService;
import com.ejianc.business.panhuo.vo.AllotVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 调拨单
 * 
 * @author generator
 * 
 */
@Service("allotService")
public class AllotServiceImpl extends BaseServiceImpl<AllotMapper, AllotEntity> implements IAllotService{

    private static final String SDBJPANHUO_ZC = "SDBJPANHUO_DBD";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public AllotVO saveAllot(AllotVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        AllotEntity entity = BeanMapper.map(vo, AllotEntity.class);
        if(StringUtils.isEmpty(vo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(SDBJPANHUO_ZC,tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        AllotVO resvo = BeanMapper.map(entity, AllotVO.class);
        return resvo;
    }
}
