package com.ejianc.business.sdbjscene.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 日常检查主表
 *
 * @author generator
 *
 */
@TableName("ejc_scene_daily")
public class SceneDailyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名
    @TableField(value="check_name")
    private String checkName; // 检查名称
    @TableField(value="check_type")
    private Long checkType; // 检查类型
    @TableField(value="check_type_name")
    private String checkTypeName;
    @TableField(value="check_id")
    private String checkId; // 检查人id
    @TableField(value="check_person")
    private String checkPerson; // 检查人
    @TableField(value="check_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date checkDate; // 检查日期
    @TableField(value="notif_relevant_id")
    private String notifRelevantId; // 通知相关人员id
    @TableField(value="notif_relevant_person")
    private String notifRelevantPerson; // 通知相关人员
    @TableField(value="remarks")
    private String remarks; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中

    @TableField(exist=false)
    @SubEntity(serviceName="sceneDailyDetailService",pidName ="pid")
    private List<SceneDailyDetailEntity> sceneDailys = new ArrayList<>();



    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 检查名称
     */
    public String getCheckName() {
        return checkName;
    }

    /**
     * 检查名称
     */
    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }
    /**
     * 检查类型 1、综合检查；2、安全检查；3、质量检查；4、进度检查；5、其他检查；
     */
    public Long getCheckType() {
        return checkType;
    }

    /**
     * 检查类型
     */
    public void setCheckType(Long checkType) {
        this.checkType = checkType;
    }

    public String getCheckTypeName() {
        return checkTypeName;
    }

    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }

    /**
     * 检查人id
     */
    public String getCheckId() {
        return checkId;
    }

    /**
     * 检查人id
     */
    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }
    /**
     * 检查人
     */
    public String getCheckPerson() {
        return checkPerson;
    }

    /**
     * 检查人
     */
    public void setCheckPerson(String checkPerson) {
        this.checkPerson = checkPerson;
    }
    /**
     * 检查日期
     */
    public java.util.Date getCheckDate() {
        return checkDate;
    }

    /**
     * 检查日期
     */
    public void setCheckDate(java.util.Date checkDate) {
        this.checkDate = checkDate;
    }

    /**
     * 通知相关人员id
     */
    public String getNotifRelevantId() {
        return notifRelevantId;
    }

    /**
     * 通知相关人员id
     */
    public void setNotifRelevantId(String notifRelevantId) {
        this.notifRelevantId = notifRelevantId;
    }
    /**
     * 通知相关人员
     */
    public String getNotifRelevantPerson() {
        return notifRelevantPerson;
    }

    /**
     * 通知相关人员
     */
    public void setNotifRelevantPerson(String notifRelevantPerson) {
        this.notifRelevantPerson = notifRelevantPerson;
    }
    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<SceneDailyDetailEntity> getSceneDailys() {
        return sceneDailys;
    }

    public void setSceneDailys(List<SceneDailyDetailEntity> sceneDailys) {
        this.sceneDailys = sceneDailys;
    }
}