package com.ejianc.business.sdbjscene.controller;

import java.io.Serializable;

import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.sdbjscene.bean.SceneDailyDetailEntity;
import com.ejianc.business.sdbjscene.vo.DailyDetailExportVO;
import com.ejianc.business.sdbjscene.vo.SceneDailyDetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.sdbjscene.bean.SceneDailyEntity;
import com.ejianc.business.sdbjscene.service.ISceneDailyService;
import com.ejianc.business.sdbjscene.vo.SceneDailyVO;

/**
 * 日常检查主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("daily")
//@Api(value = "日常检查主表", tags = {"日常检查主表"})
public class SceneDailyController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Value("${common.env.base-host}")
    private String baseHost;

    private static final String BILL_CODE = "SCENE_Daily_CODE";//此处需要根据实际修改

    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private ISceneDailyService service;

    @Value("${oms.fileServerPath}")
    private String baseImgUrl;


//    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneDailyVO> saveOrUpdate( @RequestBody SceneDailyVO saveorUpdateVO) {
        SceneDailyEntity entity = BeanMapper.map(saveorUpdateVO, SceneDailyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);

        List<SceneDailyDetailEntity> sceneDailyDetailList= entity.getSceneDailys();
        SceneDailyVO vo = BeanMapper.map(entity, SceneDailyVO.class);
        if(ListUtil.isNotEmpty(sceneDailyDetailList)){
            List<SceneDailyDetailVO> list = BeanMapper.mapList(sceneDailyDetailList, SceneDailyDetailVO.class);
            list.forEach((item)-> item.setBaseImgUrl(baseImgUrl));
            vo.setSceneDailys(list);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }


//    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneDailyVO> queryDetail(@RequestParam Long id) {
        SceneDailyEntity entity = service.selectById(id);
        List<SceneDailyDetailEntity> sceneDailyDetailList= entity.getSceneDailys();
        SceneDailyVO vo = BeanMapper.map(entity, SceneDailyVO.class);
        if(ListUtil.isNotEmpty(sceneDailyDetailList)){
            List<SceneDailyDetailVO> list = BeanMapper.mapList(sceneDailyDetailList, SceneDailyDetailVO.class);
            list.forEach((item)-> item.setBaseImgUrl(baseImgUrl));
            vo.setSceneDailys(list);
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }


//    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SceneDailyVO> vos) {
        service.removeByIds(vos.stream().map(SceneDailyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


//    @ApiOperation("列表查询")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SceneDailyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkTypeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("createUserCode",Parameter.getEqInstance(InvocationInfoProxy.getUsercode()));

        IPage<SceneDailyEntity> page = service.queryPage(param,false);
        IPage<SceneDailyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneDailyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @RequestMapping(value = "/queryPageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DailyDetailExportVO>> queryPageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<DailyDetailExportVO> page = service.queryPageList(param);
        return CommonResponse.success("查询列表数据成功！",page);
    }


//    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        List<DailyDetailExportVO> list = service.queryExportList(param);
        if(ListUtil.isNotEmpty(list)){
            int indexNum = 1;
            for (DailyDetailExportVO dailyDetailExportVO : list) {
                dailyDetailExportVO.setIndexNum(indexNum);
                if(StringUtils.isNotEmpty(dailyDetailExportVO.getProblemImgIds())){
                    StringBuffer imageUrls = new StringBuffer();
                    for (String s : dailyDetailExportVO.getProblemImgIds().split(",")) {
                        imageUrls.append(baseHost).append("ejc-file-web/attachment/filePreview?fileId=").append(s).append(",");
                    }
                    dailyDetailExportVO.setImageUrls(imageUrls.toString().substring(0,imageUrls.length()-1));
                }
                indexNum++;
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        beans.put("rowStartIndex", 5);
        Map<String, Parameter> params = param.getParams();
        for (String key:params.keySet()){
            if(key.equals("checkType")){
                CommonResponse<DefdocDetailVO> detailVOResponse = iDefdocApi.getDefDocById(Long.parseLong(params.get(key).getValue().toString()));
                if(detailVOResponse.isSuccess() && detailVOResponse.getData()!=null){
                    beans.put(key,detailVOResponse.getData().getName());
                }
            }else if(key.equals("projectId")){
                CommonResponse<ProjectRegisterVO> detailVOResponse = projectApi.queryProjectDetail(Long.parseLong(params.get(key).getValue().toString()));
                if(detailVOResponse.isSuccess() && detailVOResponse.getData()!=null){
                    beans.put(key,detailVOResponse.getData().getName());
                }
            }else if(key.equals("checkDate")){
                if(params.get(key).getValue()!=null){
                    String[] checkDate = params.get(key).getValue().toString().split(",");
                    beans.put("checkDateStart",checkDate[0]);
                    beans.put("checkDateEnd",checkDate[1]);
                }
            }else {
                beans.put(key,params.get(key).getValue());
            }
        }
        ExcelExport.getInstance().exportWithTrans("SceneDaily-export.xlsx", beans, response);
    }


//    @ApiOperation("参照")
    @RequestMapping(value = "/refSceneDailyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SceneDailyVO>> refSceneDailyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SceneDailyEntity> page = service.queryPage(param,false);
        IPage<SceneDailyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneDailyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
}
