package com.ejianc.business.sdbjscene.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sdbjscene.vo.DailyDetailExportVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sdbjscene.mapper.SceneDailyMapper;
import com.ejianc.business.sdbjscene.bean.SceneDailyEntity;
import com.ejianc.business.sdbjscene.service.ISceneDailyService;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 日常检查主表
 * 
 * @author generator
 * 
 */
@Service("sceneDailyService")
public class SceneDailyServiceImpl extends BaseServiceImpl<SceneDailyMapper, SceneDailyEntity> implements ISceneDailyService{

    @Autowired
    private SceneDailyMapper sceneDailyMapper;

    @Override
    public IPage<DailyDetailExportVO> queryPageList(QueryParam queryParam) {
        Map<String,Object> params = new HashMap<>();
        params.put("pageIndex",(queryParam.getPageIndex()-1)*queryParam.getPageSize());
        params.put("pageSize",queryParam.getPageSize());
        if(StringUtils.isNotEmpty(queryParam.getSearchText())){
            params.put("searchText",queryParam.getSearchText());
        }
        Map<String, Parameter> parameterMap = queryParam.getParams();
        if(parameterMap.containsKey("projectId")){
            if(parameterMap.get("projectId").getType().equals(QueryParam.IN)){
                params.put("projectId"," in (" + parameterMap.get("projectId").getValue()+") ");
            }else {
                params.put("projectId"," = '" + parameterMap.get("projectId").getValue()+"' ");
            }
        }
        if(parameterMap.containsKey("checkType")){
            if(parameterMap.get("checkType").getType().equals(QueryParam.IN)){
                params.put("checkType"," in (" + parameterMap.get("checkType").getValue()+") ");
            }else {
                params.put("checkType"," = '" + parameterMap.get("checkType").getValue()+"' ");
            }
        }
        if(parameterMap.containsKey("checkDate")){
            String[] date = parameterMap.get("checkDate").getValue().toString().split(",");
            params.put("checkDate"," between '" + date[0]+"' and '"+date[1]+"' ");
        }

        if(parameterMap.containsKey("checkPerson")){
            params.put("checkPerson"," like '%" +parameterMap.get("checkPerson").getValue()+"%' ");
        }
        if(parameterMap.containsKey("checkName")){
            params.put("checkName"," like '%" +parameterMap.get("checkName").getValue()+"%' ");
        }
        if(parameterMap.containsKey("checkItem")){
            params.put("checkItem"," like '%" +parameterMap.get("checkItem").getValue()+"%' ");
        }
        if(parameterMap.containsKey("dailySituation")){
            params.put("dailySituation"," like '%" +parameterMap.get("dailySituation").getValue()+"%' ");
        }
        LinkedHashMap<String,String> order = queryParam.getOrderMap();
        if(order!=null){
            StringBuffer orderBy = new StringBuffer();
            for (String key:order.keySet()){
                orderBy.append(key).append(" ").append(order.get(key)).append(",");
            }
            params.put("orderBy",orderBy.toString().substring(0,orderBy.length()-1));
        }
        List<DailyDetailExportVO> records = sceneDailyMapper.queryList(params);
        Long count = sceneDailyMapper.queryCount(params);
        IPage<DailyDetailExportVO> page = new Page<>(queryParam.getPageIndex(),queryParam.getPageSize(),count);
        page.setRecords(records);
        return page;
    }

    @Override
    public List<DailyDetailExportVO> queryExportList(QueryParam queryParam) {
        Map<String,Object> params = new HashMap<>();
        if(StringUtils.isNotEmpty(queryParam.getSearchText())){
            params.put("searchText",queryParam.getSearchText());
        }
        Map<String, Parameter> parameterMap = queryParam.getParams();
        if(parameterMap.containsKey("projectId")){
            if(parameterMap.get("projectId").getType().equals(QueryParam.IN)){
                params.put("projectId"," in (" + parameterMap.get("projectId").getValue()+") ");
            }else {
                params.put("projectId"," = '" + parameterMap.get("projectId").getValue()+"' ");
            }
        }
        if(parameterMap.containsKey("checkType")){
            if(parameterMap.get("checkType").getType().equals(QueryParam.IN)){
                params.put("checkType"," in (" + parameterMap.get("checkType").getValue()+") ");
            }else {
                params.put("checkType"," = '" + parameterMap.get("checkType").getValue()+"' ");
            }
        }
        if(parameterMap.containsKey("checkDate")){
            String[] date = parameterMap.get("checkDate").getValue().toString().split(",");
            params.put("checkDate"," between '" + date[0]+"' and '"+date[1]+"' ");
        }

        if(parameterMap.containsKey("checkPerson")){
            params.put("checkPerson"," like '%" +parameterMap.get("checkPerson").getValue()+"%' ");
        }
        if(parameterMap.containsKey("checkName")){
            params.put("checkName"," like '%" +parameterMap.get("checkName").getValue()+"%' ");
        }
        if(parameterMap.containsKey("checkItem")){
            params.put("checkItem"," like '%" +parameterMap.get("checkItem").getValue()+"%' ");
        }
        if(parameterMap.containsKey("dailySituation")){
            params.put("dailySituation"," like '%" +parameterMap.get("dailySituation").getValue()+"%' ");
        }
        LinkedHashMap<String,String> order = queryParam.getOrderMap();
        if(order!=null){
            StringBuffer orderBy = new StringBuffer();
            for (String key:order.keySet()){
                orderBy.append(key).append(" ").append(order.get(key)).append(",");
            }
            params.put("orderBy",orderBy.toString().substring(0,orderBy.length()-1));
        }
        return sceneDailyMapper.queryList(params);
    }
}
