package com.ejianc.business.sdbjscene.vo;

import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 日常检查主表
 *
 * @author generator
 *
 */
//@ApiModel("日常检查主表")
public class SceneDailyVO extends BaseVO {
    private static final long serialVersionUID = 1L;

//    @ApiModelProperty("单据编号")
    private String billCode;
//    @ApiModelProperty("项目id")
    private Long projectId;
//    @ApiModelProperty("项目名称")
    private String projectName;
//    @ApiModelProperty("组织id")
    private Long orgId;
//    @ApiModelProperty("组织名")
    private String orgName;
//    @ApiModelProperty("检查名称")
    private String checkName;
//    @ApiModelProperty("检查类型")
    private Long checkType;
//    @ApiModelProperty("检查类型名称")
    private String checkTypeName;
//    @ApiModelProperty("检查人id")
    private String checkId;
//    @ApiModelProperty("检查人")
    private String checkPerson;
//    @ApiModelProperty("检查日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date checkDate;
//    @ApiModelProperty("通知相关人员id")
    private String notifRelevantId;
//    @ApiModelProperty("通知相关人员")
    private String notifRelevantPerson;
//    @ApiModelProperty("备注")
    private String remarks;
//    @ApiModelProperty("单据状态：0自由态，1已提交")
    private Integer billState;
//    @ApiModelProperty("检查单待检复检子表")
    private List<SceneDailyDetailVO> sceneDailys = new ArrayList<>();

//    @ApiModelProperty("发送消息时用到的数量")
    private Integer msgNum;
//    @ApiModelProperty("发送消息时用到的ID")
    private Long msgId;
//    @ApiModelProperty("发送消息时用到的billCode")
    private String msgBillCode;

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 检查名称
     */
    public String getCheckName() {
        return checkName;
    }

    /**
     * 检查名称
     */
    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCheckType() {
        return checkType;
    }
    @ReferDeserialTransfer
    public void setCheckType(Long checkType) {
        this.checkType = checkType;
    }

    public String getCheckTypeName() {
        return checkTypeName;
    }

    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }

    /**
     * 检查人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public String getCheckId() {
        return checkId;
    }

    /**
     * 检查人id
     */
    @ReferDeserialTransfer
    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }
    /**
     * 检查人
     */
    public String getCheckPerson() {
        return checkPerson;
    }

    /**
     * 检查人
     */
    public void setCheckPerson(String checkPerson) {
        this.checkPerson = checkPerson;
    }
    /**
     * 检查日期
     */
    public java.util.Date getCheckDate() {
        return checkDate;
    }

    /**
     * 检查日期
     */
    public void setCheckDate(java.util.Date checkDate) {
        this.checkDate = checkDate;
    }


    /**
     * 通知相关人员id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public String getNotifRelevantId() {
        return notifRelevantId;
    }

    /**
     * 通知相关人员id
     */
    @ReferDeserialTransfer
    public void setNotifRelevantId(String notifRelevantId) {
        this.notifRelevantId = notifRelevantId;
    }
    /**
     * 通知相关人员
     */
    public String getNotifRelevantPerson() {
        return notifRelevantPerson;
    }

    /**
     * 通知相关人员
     */
    public void setNotifRelevantPerson(String notifRelevantPerson) {
        this.notifRelevantPerson = notifRelevantPerson;
    }
    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<SceneDailyDetailVO> getSceneDailys() {
        return sceneDailys;
    }

    public void setSceneDailys(List<SceneDailyDetailVO> sceneDailys) {
        this.sceneDailys = sceneDailys;
    }

    public Integer getMsgNum() {
        return msgNum;
    }

    public void setMsgNum(Integer msgNum) {
        this.msgNum = msgNum;
    }

    public Long getMsgId() {
        return msgId;
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }

    public String getMsgBillCode() {
        return msgBillCode;
    }

    public void setMsgBillCode(String msgBillCode) {
        this.msgBillCode = msgBillCode;
    }
}
