package com.ejianc.business.capital.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author CJ
 * @Description:
 * @date 2021/10/15 17:22
 */
public class CapitalRealPaymentApplyVO extends BaseVO {


    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 提交日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date commitDate;

    /**
     * 提交人名称
     */
    private String commitUserName;

    /**
     * 提交人账号
     */
    private String commitUserCode;

    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 修改人名称
     */
    private String modifyUserName;

    /**
     * 申请组织: 单据录入上下文组织
     */
    private Long applyOrgId;

    /**
     * 申请组织名称
     */
    private String applyOrgName;

    /**
     * 单据编码
     */
    private String billCode;

    /**
     * 出资方Id
     */
    private Long captailId;

    /**
     * 出资方名称
     */
    private String captailName;

    /**
     * 已实缴金额（不含本次）
     */
    private BigDecimal paidCapital;

    /**
     * 本次申请实缴金额
     */
    private BigDecimal applyAmt;

    /**
     * 累计申请实缴金额(含本次）
     */
    private BigDecimal totalPaidCapital;

    /**
     * 注册资本
     */
    private BigDecimal registerCapital;

    /**
     * 注册资本币种id
     */
    private Long currencyTypeId;

    /**
     * 注册资本币种名称
     */
    private String currencyTypeName;

    /**
     * 公司Id(组织机构）
     */
    private Long organizationId;

    /**
     * 公司名称(组织机构）
     */
    private String organizationName;

    /**
     * 本次已实缴金额
     */
    private BigDecimal realPaidAmt;

    /**
     * 申请原因
     */
    private String applyReason;

    public String getApplyReason() {
        return applyReason;
    }

    public void setApplyReason(String applyReason) {
        this.applyReason = applyReason;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public Long getApplyOrgId() {
        return applyOrgId;
    }

    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }

    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getCaptailId() {
        return captailId;
    }

    public void setCaptailId(Long captailId) {
        this.captailId = captailId;
    }

    public String getCaptailName() {
        return captailName;
    }

    public void setCaptailName(String captailName) {
        this.captailName = captailName;
    }

    public BigDecimal getPaidCapital() {
        return paidCapital;
    }

    public void setPaidCapital(BigDecimal paidCapital) {
        this.paidCapital = paidCapital;
    }

    public BigDecimal getApplyAmt() {
        return applyAmt;
    }

    public void setApplyAmt(BigDecimal applyAmt) {
        this.applyAmt = applyAmt;
    }

    public BigDecimal getTotalPaidCapital() {
        return totalPaidCapital;
    }

    public void setTotalPaidCapital(BigDecimal totalPaidCapital) {
        this.totalPaidCapital = totalPaidCapital;
    }

    public BigDecimal getRegisterCapital() {
        return registerCapital;
    }

    public void setRegisterCapital(BigDecimal registerCapital) {
        this.registerCapital = registerCapital;
    }

    public Long getCurrencyTypeId() {
        return currencyTypeId;
    }

    public void setCurrencyTypeId(Long currencyTypeId) {
        this.currencyTypeId = currencyTypeId;
    }

    public String getCurrencyTypeName() {
        return currencyTypeName;
    }

    public void setCurrencyTypeName(String currencyTypeName) {
        this.currencyTypeName = currencyTypeName;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public BigDecimal getRealPaidAmt() {
        return realPaidAmt;
    }

    public void setRealPaidAmt(BigDecimal realPaidAmt) {
        this.realPaidAmt = realPaidAmt;
    }
}
