package com.ejianc.business.capital.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 资本金收款登记
 *
 * @author CJ
 * @Description: 资本金收款登记
 * @date 2021/10/19 10:14
 */
public class CapitalRecRegistryVO extends BaseVO {

    private static final long serialVersionUID = -2892123254241490546L;
    /**
     * 登记人所属组织Id
     */
    private Long orgId;

    /**
     * 登记人所属组织名称
     */
    private String orgName;

    /**
     * 登记组织机构Id
     */
    private Long sddjsOrgId;

    /**
     * 登记组织机构名称
     */
    private String sddjsOrgName;

    /**
     * 出资方名称，多个逗号分隔
     */
    private String captailNames;

    /**
     * 本次总共收款金额
     */
    private BigDecimal curTotalRecAmt;

    /**
     * 注册资本
     */
    private BigDecimal registerCapital;

    /**
     * 注册资本币种id
     */
    private Long currencyTypeId;

    /**
     * 注册资本币种名称
     */
    private String currencyTypeName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 子表
     */
    List<CapitalRecRegistrySubVO> subList;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 提交日期
     */
    private Date commitDate;

    /**
     * 提交人名称
     */
    private String commitUserName;

    /**
     * 提交人账号
     */
    private String commitUserCode;

    /**
     * 生效日期
     */
    private Date effectiveDate;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 修改人名称
     */
    private String modifyUserName;

    /**
     * 单据编码
     */
    private String billCode;

    /** 导出使用字段  **/
    private String billStateName;

    private String createTimeStr;

    public String getCreateTimeStr() {
        return createTimeStr;
    }

    public void setCreateTimeStr(String createTimeStr) {
        this.createTimeStr = createTimeStr;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public BigDecimal getCurTotalRecAmt() {
        return curTotalRecAmt;
    }

    public void setCurTotalRecAmt(BigDecimal curTotalRecAmt) {
        this.curTotalRecAmt = curTotalRecAmt;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getSddjsOrgId() {
        return sddjsOrgId;
    }

    @ReferDeserialTransfer
    public void setSddjsOrgId(Long sddjsOrgId) {
        this.sddjsOrgId = sddjsOrgId;
    }

    public String getSddjsOrgName() {
        return sddjsOrgName;
    }

    public void setSddjsOrgName(String sddjsOrgName) {
        this.sddjsOrgName = sddjsOrgName;
    }

    public String getCaptailNames() {
        return captailNames;
    }

    public void setCaptailNames(String captailNames) {
        this.captailNames = captailNames;
    }

    public BigDecimal getRegisterCapital() {
        return registerCapital;
    }

    public void setRegisterCapital(BigDecimal registerCapital) {
        this.registerCapital = registerCapital;
    }

    public Long getCurrencyTypeId() {
        return currencyTypeId;
    }

    @ReferDeserialTransfer
    public void setCurrencyTypeId(Long currencyTypeId) {
        this.currencyTypeId = currencyTypeId;
    }

    public String getCurrencyTypeName() {
        return currencyTypeName;
    }

    public void setCurrencyTypeName(String currencyTypeName) {
        this.currencyTypeName = currencyTypeName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<CapitalRecRegistrySubVO> getSubList() {
        return subList;
    }

    public void setSubList(List<CapitalRecRegistrySubVO> subList) {
        this.subList = subList;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
}
