package com.ejianc.business.production.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.production.vo.AcquisitionEquityVO;
import com.ejianc.business.production.vo.CapitalVO;
import com.ejianc.business.production.vo.CapitalReductionVO;
import com.ejianc.business.production.vo.ConformanceContentVO;
import com.ejianc.business.production.vo.CurrencyVO;
import com.ejianc.business.production.vo.NoneCurrencyVO;
import com.ejianc.business.production.vo.ReformNewShareholderVO;
import com.ejianc.business.production.vo.ResidualPropertyVO;
import com.ejianc.business.production.vo.TransferInfoVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 产权登记主表
 * 
 * @author generator
 * 
 */
public class ProductionVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private java.lang.String code; // 登记单号
    private java.lang.String name; // 名称
    private java.lang.String unifiedSocialCreditCode; // 统一社会信用代码
    private Boolean inReacrd; // 是否在集团备案
    private java.lang.String outCapitalOrg; // 国家出资企业id
    private java.lang.String outCapitalOrgName; // 国家出资企业名称
    private java.lang.Long relationToOutOrg; // 与国家出资企业的关系id
    private java.lang.String relationToOutOrgName; // 与国家出资企业的关系名称
    private java.lang.Boolean beOwner; // 是否国家出资企业业主
    private java.lang.Long mainCapitalOrgId; // 主要出资人id
    private java.lang.String mainCapitalOrgName; // 主要出资人名称
    private java.lang.Long registerCountryId; // 注册国家id
    private java.lang.String registerCountryName; // 注册国家名称
    private java.lang.String registerIn; // 注册地境内/境外
    private java.lang.String registerAddress; // 注册地
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date dateIncorporation; // 注册日期
    private java.math.BigDecimal registerCapital; // 注册资本
    private java.lang.Long currencyTypeId; // 注册资本币种id
    private java.lang.String currencyTypeName; // 注册资本币种名称
    private java.lang.String registerCapitalBig; // 注册资本大写
    private java.lang.Long orgTypeId; // 企业类别id
    private java.lang.String orgTypeName; // 企业类别名称
    private String orgType;
    private java.lang.String regulatoryBodiesId; // 国资监管机构id
    private java.lang.String regulatoryBodies; // 国资监管机构
    private java.lang.Long orgFormId; // 组织形式
    private java.lang.String orgFormName; // 组织形式
    private java.lang.String orgForm; // 组织形式
    private java.lang.String majorIndustriesId; // 主要行业
    private java.lang.String majorIndustries; // 主要行业
    private java.lang.String productLevel; // 企业产权级次
    private java.lang.String mangerLevel; // 企业管理级次
    private java.lang.Boolean mergeTable; // 是否并表
    private java.lang.Boolean beListed; // 是否上市公司
    private java.lang.Boolean beClosed; // 是否存在休眠/停业/歇业等情况
    private java.lang.String decisionProgram; // 决策或批复程序
    private String decisionProgramName;// 决策或批复程序名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date decisionDate; // 决策或批复日期
    private java.lang.String noEconomicBehavior; // 无经济行为决策或批复文件理由描述
    private java.lang.String decisionOtherMemo; // 经济行为决策或批复文件-其他说明情况
    private java.lang.Long acquirer; // 收购方名称
    private java.lang.String acquirerName; // 收购方名称
    private java.lang.String acquirerUnicode; // 收购方统一社会信用代码
    private java.math.BigDecimal proportionTransferredEquity; // 转让股权比例
    private java.lang.Boolean hasCentralEnterprisesFunded; // 标的企业是否有央企出资
    private java.lang.String assetAppraisalFilingNo; // 资产评估备案编号
    private java.math.BigDecimal assessedValueNetAssets; // 净资产评估值
    private String assessedValueNetAssetsBig;//净资产评估值(大写)
    private java.lang.Long capitalIncrease; // 增资情形
    private java.lang.String capitalIncreaseName; // 增资情形
    private java.lang.String assetAppraisalFilingNum; // 资产评估备案编号
    private java.math.BigDecimal capitalAssessedValueAssets; // 增资企业净资产评估值
    private java.math.BigDecimal capitalEquivalent; // 增资评估折合(元/注册资本)
    private java.lang.String capitalEquivalentBig; // 增资评估折合(元/注册资本)(大写)
    private java.math.BigDecimal capitalIncreasePrice; // 增资价格(元/注册资本)
    private java.lang.String capitalIncreasePriceBig; // 增资价格(元/注册资本)(大写)
    private java.lang.Boolean hasAssessmentFilingForm; // 有无评估备案表或核准文件
    private java.lang.String intermediary; // 中介结构名称
    private java.lang.String appraisalReportNo; // 评估报告号
    private java.lang.String filingApprovalOrg; // 备案或核准单位名称
    private java.lang.String filingApprovalCode; // 备案号或核准文件号
    private java.lang.String capitalOtherMemo; // 标的企业-其他需说明的情况
    private java.lang.String reductionCapital; // 减资情形
    private Long reductionCapitalId;
    private java.math.BigDecimal reductionCapitalTotal; // 减少资本总额
    private java.lang.String reductionCapitalTotalBig; // 减少资本总额(大写)
    private java.lang.String reductionCapitalPricingBasis; // 作价依据
    private java.lang.Boolean centralEnterprisesAllOut; // 减资-中央企业出资人是否全部退出
    private java.math.BigDecimal reductionCapitalValueAssets; // 减资企业净资产评估值
    private java.lang.String reductionCapitalValueAssetsBig; // 减资企业净资产评估值(大写)
    private java.lang.Boolean hasEmployeeCongress; // 有无职工代表大会决议
    private java.lang.String employeeCongressOpinions; // 职工代表大会意见
    private java.lang.String employeeCongressOtherMemo; // 职工代表大会-其他需说明的情况
    private java.lang.String transferType; // 划转类型
    private Long registrationPropertyRightsId;
    private java.lang.String registrationPropertyRights; // 产权登记情形
    private java.lang.Boolean introductionNewShareholders; // 是否引入新股东-改制
    private java.math.BigDecimal reformOrgNetAssetsAudit; // 改制企业净资产审计值
    private java.lang.String reformOrgNetAssetsAuditBig; // 改制企业净资产审计值(大写)
    private java.lang.Boolean hasNonMonetaryContribution; // 有无非货币出资
    private java.lang.Integer hasPropertyDistribution; // 有无财产分配情况
    private java.lang.Long sourceApplyId; // 产权登记单来源于哪个申请单
    private java.lang.Long orgId; // 创建单据组织id
    private java.lang.String createUserName; // 创建人
    private java.lang.String productionTypeName; // 产权登记单类型名称：
    private java.lang.String productionTypeCode; // 产权登记单类型编码：
    private String applyType;//登记属性   即申请单类型 ，set:设立，change：变更，del：注销，merge：合并，divide：分立，supplementary:补录
    private String routeUrl;//路由url
    private Boolean useStatus;//使用状态
    private String billStateName;
    private String investorsBefore;
    private String investorsAfter;
    private String historyRecord;
    private java.lang.Long initiatorId; // 发起方企业id
    private java.lang.String initiatorName; // 发起方企业名称
    private String initiatorUnifiedSocialCreditCode;
    private java.lang.String investedEnterpriseValuationFilingCode; // 被投资企业的资产评估备案编号
    private java.math.BigDecimal investedEnterpriseAssetsAppraisalValue; // 被投资企业净资产评估值
    private java.lang.String investedEnterpriseAssetsAppraisalValueBig; // 被投资企业净资产评估值(大写)
    private java.math.BigDecimal fundedEnterpriseEquityRatio; // 出资企业因本次股权投资占被投资企业股权比例
    private java.lang.Boolean involvingInvestedEnterprisesContribution; // 是否涉及被投资企业主要出资人变动
    private java.lang.Boolean involvingInvestedEnterprisesShareContribution; // 是否涉及用于股权投资的企业主要出资人变动
    private java.lang.Boolean approvalThereAssessmentRecordDocument; // 有无评估备案表或核准文件
    private java.lang.String approvalIntermediaryStructureName; // 中介结构名称
    private java.lang.String approvalRecordOrApprovedName; // 备案或核准单位名称
    private java.lang.String approvalRecordOrApprovedFile; // 备案号或核准文件号
    private java.lang.String approvalOtherRequiringExplanation; // 其他需说明的情况
    private java.lang.Boolean noneCurrencyThereAssessmentRecordDocument; // 非货币-有无评估备案表或核准文件
    private java.lang.String noneCurrencyIntermediaryStructureName; // 非货币--中介结构名称
    private java.lang.String noneCurrencyRecordOrApprovedName; // 非货币---备案或核准单位名称
    private java.lang.String noneCurrencyRecordOrApprovedFile; // 非货币---备案号或核准文件号
    private java.lang.String noneCurrencyEvaluationReportNo; // 评估报告号
    private java.lang.String noneCurrencyOtherRequiringExplanation; // 非货币---其他需说明的情况
    private java.math.BigDecimal investmentAmount; // 投资金额
    private String investmentAmountBig; // 投资金额大写
    private BigDecimal equityRatio; // 股权比例
    private java.lang.String transactionOrgName; // 产权交易机构名称
    private java.lang.String transactionProjectCode; // 项目编号
    private java.util.Date transactionEndDate; // 项目发布/截止日期
    private java.math.BigDecimal listingPrice; // 挂牌价格
    private BigDecimal transactionPrice;//成交价格
    private String transactionPriceBig;//成交价格(大写)
    private java.lang.String declareEnterpriseType; // 申报企业类型
    private java.lang.String transfereeNature; // 受让性质
    private java.lang.Long transfereeEnterpriseId; //  受让方企业id
    private java.lang.String transfereeEnterpriseName; // 受让方企业名称
    private java.lang.String transfereeUnifiedSocialCreditCode; // 受让方统一社会信用代码
    private java.lang.String pricingBasis; // 作价依据
    private java.lang.String transfereeType; // 转让类型
    private Long inUseOrgId; // 在用组织id
    private Boolean notCentralEnterprises;
    private String ownedAssetsSupervisionAuthority;//转让方所属国资监管机构
    private Long transfererEnterpriseId;//转让方企业名称
    private String transfererEnterpriseName;//转让方企业名称
    private String transfererUnifiedSocialCreditCode;
    private String applyTypeName;
    private String inReacrdName;

    private List<AcquisitionEquityVO> acquisitionEquityEntities = new ArrayList<>(); // 产权登记-收购股权明细
    private List<CapitalVO> capitalEntities = new ArrayList<>(); // 产权登记--资本状况
    private List<CapitalReductionVO> capitalReductionEntities = new ArrayList<>(); // 产权登记-减资方情况
    private List<ConformanceContentVO> conformanceContentEntities = new ArrayList<>(); // 产权登记-合规性目录
    private List<CurrencyVO> currencyEntities = new ArrayList<>(); // 产权登记-货币出资情况
    private List<NoneCurrencyVO> noneCurrencyEntities = new ArrayList<>(); // 产权登记-非货币出资
    private List<ReformNewShareholderVO> reformNewShareholderEntities = new ArrayList<>(); // 产权登记-改制新股东
    private List<ResidualPropertyVO> residualPropertyEntities = new ArrayList<>(); // 产权登记-剩余财产分配情况
    private List<TransferInfoVO> transferInfoEntities = new ArrayList<>(); // 产权登记-划转方案信息
    private List<InvestorsVO> investorsEntities = new ArrayList<>(); // 产权登记-出资人情况
   /* private List<TransfererVO> transfererEntities = new ArrayList<>();//转让方
    private List<TransferorVO> transferorEntities = new ArrayList<>();//受让方*/
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 名称
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 名称
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }
    /**
     * 统一社会信用代码
     */
    public java.lang.String getUnifiedSocialCreditCode() {
        return unifiedSocialCreditCode;
    }

    /**
     * 统一社会信用代码
     */
    public void setUnifiedSocialCreditCode(java.lang.String unifiedSocialCreditCode) {
        this.unifiedSocialCreditCode = unifiedSocialCreditCode;
    }

    /**
     * 是否在集团备案
     */
    public Boolean getInReacrd() {
        return inReacrd;
    }

    public void setInReacrd(Boolean inReacrd) {
        this.inReacrd = inReacrd;
    }

    /**
     * 国家出资企业id
     */
    public String getOutCapitalOrg() {
        return outCapitalOrg;
    }

    public void setOutCapitalOrg(String outCapitalOrg) {
        this.outCapitalOrg = outCapitalOrg;
    }

    /**
     * 国家出资企业名称
     */
    public java.lang.String getOutCapitalOrgName() {
        return outCapitalOrgName;
    }

    /**
     * 国家出资企业名称
     */
    public void setOutCapitalOrgName(java.lang.String outCapitalOrgName) {
        this.outCapitalOrgName = outCapitalOrgName;
    }

    /**
     * 与国家出资企业的关系id
     */
    public Long getRelationToOutOrg() {
        return relationToOutOrg;
    }

    public void setRelationToOutOrg(Long relationToOutOrg) {
        this.relationToOutOrg = relationToOutOrg;
    }

    /**
     * 与国家出资企业的关系名称
     */
    public java.lang.String getRelationToOutOrgName() {
        return relationToOutOrgName;
    }

    /**
     * 与国家出资企业的关系名称
     */
    public void setRelationToOutOrgName(java.lang.String relationToOutOrgName) {
        this.relationToOutOrgName = relationToOutOrgName;
    }
    /**
     * 是否国家出资企业业主
     */
    public Boolean getBeOwner() {
        return beOwner;
    }

    public void setBeOwner(Boolean beOwner) {
        this.beOwner = beOwner;
    }

    /**
     * 主要出资人id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public java.lang.Long getMainCapitalOrgId() {
        return mainCapitalOrgId;
    }

    /**
     * 主要出资人id
     */
    @ReferDeserialTransfer
    public void setMainCapitalOrgId(java.lang.Long mainCapitalOrgId) {
        this.mainCapitalOrgId = mainCapitalOrgId;
    }
    /**
     * 主要出资人名称
     */
    public java.lang.String getMainCapitalOrgName() {
        return mainCapitalOrgName;
    }

    /**
     * 主要出资人名称
     */
    public void setMainCapitalOrgName(java.lang.String mainCapitalOrgName) {
        this.mainCapitalOrgName = mainCapitalOrgName;
    }
    /**
     * 注册国家id
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public java.lang.Long getRegisterCountryId() {
        return registerCountryId;
    }

    /**
     * 注册国家id
     */
    @ReferDeserialTransfer
    public void setRegisterCountryId(java.lang.Long registerCountryId) {
        this.registerCountryId = registerCountryId;
    }
    /**
     * 注册国家名称
     */
    public java.lang.String getRegisterCountryName() {
        return registerCountryName;
    }

    /**
     * 注册国家名称
     */
    public void setRegisterCountryName(java.lang.String registerCountryName) {
        this.registerCountryName = registerCountryName;
    }
    /**
     * 注册地境内/境外
     */
    public java.lang.String getRegisterIn() {
        return registerIn;
    }

    /**
     * 注册地境内/境外
     */
    public void setRegisterIn(java.lang.String registerIn) {
        this.registerIn = registerIn;
    }
    /**
     * 注册地
     */
    public java.lang.String getRegisterAddress() {
        return registerAddress;
    }

    /**
     * 注册地
     */
    public void setRegisterAddress(java.lang.String registerAddress) {
        this.registerAddress = registerAddress;
    }
    /**
     * 注册日期
     */
    public Date getDateIncorporation() {
        return dateIncorporation;
    }

    public void setDateIncorporation(Date dateIncorporation) {
        this.dateIncorporation = dateIncorporation;
    }

    /**
     * 注册资本
     */
    public java.math.BigDecimal getRegisterCapital() {
        return registerCapital;
    }

    /**
     * 注册资本
     */
    public void setRegisterCapital(java.math.BigDecimal registerCapital) {
        this.registerCapital = registerCapital;
    }
    /**
     * 注册资本币种id
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public java.lang.Long getCurrencyTypeId() {
        return currencyTypeId;
    }

    /**
     * 注册资本币种id
     */
    @ReferDeserialTransfer
    public void setCurrencyTypeId(java.lang.Long currencyTypeId) {
        this.currencyTypeId = currencyTypeId;
    }
    /**
     * 注册资本币种名称
     */
    public java.lang.String getCurrencyTypeName() {
        return currencyTypeName;
    }

    /**
     * 注册资本币种名称
     */
    public void setCurrencyTypeName(java.lang.String currencyTypeName) {
        this.currencyTypeName = currencyTypeName;
    }
    /**
     * 注册资本大写
     */
    public java.lang.String getRegisterCapitalBig() {
        return registerCapitalBig;
    }

    /**
     * 注册资本大写
     */
    public void setRegisterCapitalBig(java.lang.String registerCapitalBig) {
        this.registerCapitalBig = registerCapitalBig;
    }
    /**
     * 企业类别id
     */
    public java.lang.Long getOrgTypeId() {
        return orgTypeId;
    }

    /**
     * 企业类别id
     */
    public void setOrgTypeId(java.lang.Long orgTypeId) {
        this.orgTypeId = orgTypeId;
    }
    /**
     * 企业类别名称
     */
    public java.lang.String getOrgTypeName() {
        return orgTypeName;
    }

    /**
     * 企业类别名称
     */
    public void setOrgTypeName(java.lang.String orgTypeName) {
        this.orgTypeName = orgTypeName;
    }
    /**
     * 国资监管机构id
     */
    public String getRegulatoryBodiesId() {
        return regulatoryBodiesId;
    }

    public void setRegulatoryBodiesId(String regulatoryBodiesId) {
        this.regulatoryBodiesId = regulatoryBodiesId;
    }

    /**
     * 国资监管机构
     */
    public java.lang.String getRegulatoryBodies() {
        return regulatoryBodies;
    }

    /**
     * 国资监管机构
     */
    public void setRegulatoryBodies(java.lang.String regulatoryBodies) {
        this.regulatoryBodies = regulatoryBodies;
    }
    /**
     * 组织形式
     */
    public java.lang.Long getOrgFormId() {
        return orgFormId;
    }

    /**
     * 组织形式
     */
    public void setOrgFormId(java.lang.Long orgFormId) {
        this.orgFormId = orgFormId;
    }
    /**
     * 组织形式
     */
    public java.lang.String getOrgFormName() {
        return orgFormName;
    }

    /**
     * 组织形式
     */
    public void setOrgFormName(java.lang.String orgFormName) {
        this.orgFormName = orgFormName;
    }

    /**
     * 主要行业
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public String getMajorIndustriesId() {
        return majorIndustriesId;
    }

    @ReferDeserialTransfer
    public void setMajorIndustriesId(String majorIndustriesId) {
        this.majorIndustriesId = majorIndustriesId;
    }

    /**
     * 主要行业
     */
    public java.lang.String getMajorIndustries() {
        return majorIndustries;
    }

    /**
     * 主要行业
     */
    public void setMajorIndustries(java.lang.String majorIndustries) {
        this.majorIndustries = majorIndustries;
    }
    /**
     * 企业产权级次
     */
    public java.lang.String getProductLevel() {
        return productLevel;
    }

    /**
     * 企业产权级次
     */
    public void setProductLevel(java.lang.String productLevel) {
        this.productLevel = productLevel;
    }
    /**
     * 企业管理级次
     */
    public java.lang.String getMangerLevel() {
        return mangerLevel;
    }

    /**
     * 企业管理级次
     */
    public void setMangerLevel(java.lang.String mangerLevel) {
        this.mangerLevel = mangerLevel;
    }
    /**
     * 是否并表
     */
    public Boolean getMergeTable() {
        return mergeTable;
    }

    public void setMergeTable(Boolean mergeTable) {
        this.mergeTable = mergeTable;
    }

    public Boolean getBeListed() {
        return beListed;
    }

    public void setBeListed(Boolean beListed) {
        this.beListed = beListed;
    }

    public Boolean getBeClosed() {
        return beClosed;
    }

    public void setBeClosed(Boolean beClosed) {
        this.beClosed = beClosed;
    }

    /**
     * 决策或批复程序
     */
    public String getDecisionProgram() {
        return decisionProgram;
    }

    public void setDecisionProgram(String decisionProgram) {
        this.decisionProgram = decisionProgram;
    }

    /**
     * 决策或批复日期
     */
    public java.util.Date getDecisionDate() {
        return decisionDate;
    }

    /**
     * 决策或批复日期
     */
    public void setDecisionDate(java.util.Date decisionDate) {
        this.decisionDate = decisionDate;
    }
    /**
     * 无经济行为决策或批复文件理由描述
     */
    public java.lang.String getNoEconomicBehavior() {
        return noEconomicBehavior;
    }

    /**
     * 无经济行为决策或批复文件理由描述
     */
    public void setNoEconomicBehavior(java.lang.String noEconomicBehavior) {
        this.noEconomicBehavior = noEconomicBehavior;
    }
    /**
     * 经济行为决策或批复文件-其他说明情况
     */
    public java.lang.String getDecisionOtherMemo() {
        return decisionOtherMemo;
    }

    /**
     * 经济行为决策或批复文件-其他说明情况
     */
    public void setDecisionOtherMemo(java.lang.String decisionOtherMemo) {
        this.decisionOtherMemo = decisionOtherMemo;
    }
    /**
     * 收购方名称
     */
    @ReferSerialTransfer(referCode="sddjs-org")
    public java.lang.Long getAcquirer() {
        return acquirer;
    }

    /**
     * 收购方名称
     */
    @ReferDeserialTransfer
    public void setAcquirer(java.lang.Long acquirer) {
        this.acquirer = acquirer;
    }
    /**
     * 收购方名称
     */
    public java.lang.String getAcquirerName() {
        return acquirerName;
    }

    /**
     * 收购方名称
     */
    public void setAcquirerName(java.lang.String acquirerName) {
        this.acquirerName = acquirerName;
    }
    /**
     * 收购方统一社会信用代码
     */
    public java.lang.String getAcquirerUnicode() {
        return acquirerUnicode;
    }

    /**
     * 收购方统一社会信用代码
     */
    public void setAcquirerUnicode(java.lang.String acquirerUnicode) {
        this.acquirerUnicode = acquirerUnicode;
    }
    /**
     * 转让股权比例
     */
    public java.math.BigDecimal getProportionTransferredEquity() {
        return proportionTransferredEquity;
    }

    /**
     * 转让股权比例
     */
    public void setProportionTransferredEquity(java.math.BigDecimal proportionTransferredEquity) {
        this.proportionTransferredEquity = proportionTransferredEquity;
    }
    /**
     * 标的企业是否有央企出资
     */
    public Boolean getHasCentralEnterprisesFunded() {
        return hasCentralEnterprisesFunded;
    }

    public void setHasCentralEnterprisesFunded(Boolean hasCentralEnterprisesFunded) {
        this.hasCentralEnterprisesFunded = hasCentralEnterprisesFunded;
    }

    /**
     * 资产评估备案编号
     */
    public java.lang.String getAssetAppraisalFilingNo() {
        return assetAppraisalFilingNo;
    }

    /**
     * 资产评估备案编号
     */
    public void setAssetAppraisalFilingNo(java.lang.String assetAppraisalFilingNo) {
        this.assetAppraisalFilingNo = assetAppraisalFilingNo;
    }
    /**
     * 净资产评估值
     */
    public java.math.BigDecimal getAssessedValueNetAssets() {
        return assessedValueNetAssets;
    }

    /**
     * 净资产评估值
     */
    public void setAssessedValueNetAssets(java.math.BigDecimal assessedValueNetAssets) {
        this.assessedValueNetAssets = assessedValueNetAssets;
    }
    /**
     * 增资情形
     */
    public java.lang.Long getCapitalIncrease() {
        return capitalIncrease;
    }

    /**
     * 增资情形
     */
    public void setCapitalIncrease(java.lang.Long capitalIncrease) {
        this.capitalIncrease = capitalIncrease;
    }
    /**
     * 增资情形
     */
    public java.lang.String getCapitalIncreaseName() {
        return capitalIncreaseName;
    }

    /**
     * 增资情形
     */
    public void setCapitalIncreaseName(java.lang.String capitalIncreaseName) {
        this.capitalIncreaseName = capitalIncreaseName;
    }
    /**
     * 资产评估备案编号
     */
    public java.lang.String getAssetAppraisalFilingNum() {
        return assetAppraisalFilingNum;
    }

    /**
     * 资产评估备案编号
     */
    public void setAssetAppraisalFilingNum(java.lang.String assetAppraisalFilingNum) {
        this.assetAppraisalFilingNum = assetAppraisalFilingNum;
    }
    /**
     * 增资企业净资产评估值
     */
    public java.math.BigDecimal getCapitalAssessedValueAssets() {
        return capitalAssessedValueAssets;
    }

    /**
     * 增资企业净资产评估值
     */
    public void setCapitalAssessedValueAssets(java.math.BigDecimal capitalAssessedValueAssets) {
        this.capitalAssessedValueAssets = capitalAssessedValueAssets;
    }
    /**
     * 增资评估折合(元/注册资本)
     */
    public java.math.BigDecimal getCapitalEquivalent() {
        return capitalEquivalent;
    }

    /**
     * 增资评估折合(元/注册资本)
     */
    public void setCapitalEquivalent(java.math.BigDecimal capitalEquivalent) {
        this.capitalEquivalent = capitalEquivalent;
    }
    /**
     * 增资评估折合(元/注册资本)(大写)
     */
    public java.lang.String getCapitalEquivalentBig() {
        return capitalEquivalentBig;
    }

    /**
     * 增资评估折合(元/注册资本)(大写)
     */
    public void setCapitalEquivalentBig(java.lang.String capitalEquivalentBig) {
        this.capitalEquivalentBig = capitalEquivalentBig;
    }
    /**
     * 增资价格(元/注册资本)
     */
    public java.math.BigDecimal getCapitalIncreasePrice() {
        return capitalIncreasePrice;
    }

    /**
     * 增资价格(元/注册资本)
     */
    public void setCapitalIncreasePrice(java.math.BigDecimal capitalIncreasePrice) {
        this.capitalIncreasePrice = capitalIncreasePrice;
    }
    /**
     * 增资价格(元/注册资本)(大写)
     */
    public java.lang.String getCapitalIncreasePriceBig() {
        return capitalIncreasePriceBig;
    }

    /**
     * 增资价格(元/注册资本)(大写)
     */
    public void setCapitalIncreasePriceBig(java.lang.String capitalIncreasePriceBig) {
        this.capitalIncreasePriceBig = capitalIncreasePriceBig;
    }
    /**
     * 有无评估备案表或核准文件
     */
    public Boolean getHasAssessmentFilingForm() {
        return hasAssessmentFilingForm;
    }

    public void setHasAssessmentFilingForm(Boolean hasAssessmentFilingForm) {
        this.hasAssessmentFilingForm = hasAssessmentFilingForm;
    }

    /**
     * 中介结构名称
     */
    public java.lang.String getIntermediary() {
        return intermediary;
    }

    /**
     * 中介结构名称
     */
    public void setIntermediary(java.lang.String intermediary) {
        this.intermediary = intermediary;
    }
    /**
     * 评估报告号
     */
    public java.lang.String getAppraisalReportNo() {
        return appraisalReportNo;
    }

    /**
     * 评估报告号
     */
    public void setAppraisalReportNo(java.lang.String appraisalReportNo) {
        this.appraisalReportNo = appraisalReportNo;
    }
    /**
     * 备案或核准单位名称
     */
    public java.lang.String getFilingApprovalOrg() {
        return filingApprovalOrg;
    }

    /**
     * 备案或核准单位名称
     */
    public void setFilingApprovalOrg(java.lang.String filingApprovalOrg) {
        this.filingApprovalOrg = filingApprovalOrg;
    }
    /**
     * 备案号或核准文件号
     */
    public java.lang.String getFilingApprovalCode() {
        return filingApprovalCode;
    }

    /**
     * 备案号或核准文件号
     */
    public void setFilingApprovalCode(java.lang.String filingApprovalCode) {
        this.filingApprovalCode = filingApprovalCode;
    }
    /**
     * 标的企业-其他需说明的情况
     */
    public java.lang.String getCapitalOtherMemo() {
        return capitalOtherMemo;
    }

    /**
     * 标的企业-其他需说明的情况
     */
    public void setCapitalOtherMemo(java.lang.String capitalOtherMemo) {
        this.capitalOtherMemo = capitalOtherMemo;
    }
    /**
     * 减资情形
     */
    public java.lang.String getReductionCapital() {
        return reductionCapital;
    }

    /**
     * 减资情形
     */
    public void setReductionCapital(java.lang.String reductionCapital) {
        this.reductionCapital = reductionCapital;
    }
    /**
     * 减少资本总额
     */
    public java.math.BigDecimal getReductionCapitalTotal() {
        return reductionCapitalTotal;
    }

    /**
     * 减少资本总额
     */
    public void setReductionCapitalTotal(java.math.BigDecimal reductionCapitalTotal) {
        this.reductionCapitalTotal = reductionCapitalTotal;
    }
    /**
     * 减少资本总额(大写)
     */
    public java.lang.String getReductionCapitalTotalBig() {
        return reductionCapitalTotalBig;
    }

    /**
     * 减少资本总额(大写)
     */
    public void setReductionCapitalTotalBig(java.lang.String reductionCapitalTotalBig) {
        this.reductionCapitalTotalBig = reductionCapitalTotalBig;
    }
    /**
     * 作价依据
     */
    public java.lang.String getReductionCapitalPricingBasis() {
        return reductionCapitalPricingBasis;
    }

    /**
     * 作价依据
     */
    public void setReductionCapitalPricingBasis(java.lang.String reductionCapitalPricingBasis) {
        this.reductionCapitalPricingBasis = reductionCapitalPricingBasis;
    }
    /**
     * 减资-中央企业出资人是否全部退出
     */
    public Boolean getCentralEnterprisesAllOut() {
        return centralEnterprisesAllOut;
    }

    public void setCentralEnterprisesAllOut(Boolean centralEnterprisesAllOut) {
        this.centralEnterprisesAllOut = centralEnterprisesAllOut;
    }

    /**
     * 减资企业净资产评估值
     */
    public java.math.BigDecimal getReductionCapitalValueAssets() {
        return reductionCapitalValueAssets;
    }

    /**
     * 减资企业净资产评估值
     */
    public void setReductionCapitalValueAssets(java.math.BigDecimal reductionCapitalValueAssets) {
        this.reductionCapitalValueAssets = reductionCapitalValueAssets;
    }
    /**
     * 减资企业净资产评估值(大写)
     */
    public java.lang.String getReductionCapitalValueAssetsBig() {
        return reductionCapitalValueAssetsBig;
    }

    /**
     * 减资企业净资产评估值(大写)
     */
    public void setReductionCapitalValueAssetsBig(java.lang.String reductionCapitalValueAssetsBig) {
        this.reductionCapitalValueAssetsBig = reductionCapitalValueAssetsBig;
    }
    /**
     * 有无职工代表大会决议
     */
    public Boolean getHasEmployeeCongress() {
        return hasEmployeeCongress;
    }

    public void setHasEmployeeCongress(Boolean hasEmployeeCongress) {
        this.hasEmployeeCongress = hasEmployeeCongress;
    }

    /**
     * 职工代表大会意见
     */
    public java.lang.String getEmployeeCongressOpinions() {
        return employeeCongressOpinions;
    }

    /**
     * 职工代表大会意见
     */
    public void setEmployeeCongressOpinions(java.lang.String employeeCongressOpinions) {
        this.employeeCongressOpinions = employeeCongressOpinions;
    }
    /**
     * 职工代表大会-其他需说明的情况
     */
    public java.lang.String getEmployeeCongressOtherMemo() {
        return employeeCongressOtherMemo;
    }

    /**
     * 职工代表大会-其他需说明的情况
     */
    public void setEmployeeCongressOtherMemo(java.lang.String employeeCongressOtherMemo) {
        this.employeeCongressOtherMemo = employeeCongressOtherMemo;
    }
    /**
     * 划转类型
     */
    public java.lang.String getTransferType() {
        return transferType;
    }

    /**
     * 划转类型
     */
    public void setTransferType(java.lang.String transferType) {
        this.transferType = transferType;
    }
    /**
     * 产权登记情形
     */
    public java.lang.String getRegistrationPropertyRights() {
        return registrationPropertyRights;
    }

    /**
     * 产权登记情形
     */
    public void setRegistrationPropertyRights(java.lang.String registrationPropertyRights) {
        this.registrationPropertyRights = registrationPropertyRights;
    }
    /**
     * 是否引入新股东-改制
     */
    public Boolean getIntroductionNewShareholders() {
        return introductionNewShareholders;
    }

    public void setIntroductionNewShareholders(Boolean introductionNewShareholders) {
        this.introductionNewShareholders = introductionNewShareholders;
    }

    /**
     * 改制企业净资产审计值
     */
    public java.math.BigDecimal getReformOrgNetAssetsAudit() {
        return reformOrgNetAssetsAudit;
    }

    /**
     * 改制企业净资产审计值
     */
    public void setReformOrgNetAssetsAudit(java.math.BigDecimal reformOrgNetAssetsAudit) {
        this.reformOrgNetAssetsAudit = reformOrgNetAssetsAudit;
    }
    /**
     * 改制企业净资产审计值(大写)
     */
    public java.lang.String getReformOrgNetAssetsAuditBig() {
        return reformOrgNetAssetsAuditBig;
    }

    /**
     * 改制企业净资产审计值(大写)
     */
    public void setReformOrgNetAssetsAuditBig(java.lang.String reformOrgNetAssetsAuditBig) {
        this.reformOrgNetAssetsAuditBig = reformOrgNetAssetsAuditBig;
    }
    /**
     * 有无非货币出资
     */
    public Boolean getHasNonMonetaryContribution() {
        return hasNonMonetaryContribution;
    }

    public void setHasNonMonetaryContribution(Boolean hasNonMonetaryContribution) {
        this.hasNonMonetaryContribution = hasNonMonetaryContribution;
    }

    /**
     * 有无财产分配情况
     */
    public java.lang.Integer getHasPropertyDistribution() {
        return hasPropertyDistribution;
    }

    /**
     * 有无财产分配情况
     */
    public void setHasPropertyDistribution(java.lang.Integer hasPropertyDistribution) {
        this.hasPropertyDistribution = hasPropertyDistribution;
    }

    /**
     * 产权登记单来源于哪个申请单
     */
    public java.lang.Long getSourceApplyId() {
        return sourceApplyId;
    }

    /**
     * 产权登记单来源于哪个申请单
     */
    public void setSourceApplyId(java.lang.Long sourceApplyId) {
        this.sourceApplyId = sourceApplyId;
    }
    /**
     * 创建单据组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 创建单据组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 创建人
     */
    public java.lang.String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人
     */
    public void setCreateUserName(java.lang.String createUserName) {
        this.createUserName = createUserName;
    }

    public List<AcquisitionEquityVO> getAcquisitionEquityEntities() {
        return acquisitionEquityEntities;
    }

    public void setAcquisitionEquityEntities(List<AcquisitionEquityVO> acquisitionEquityEntities) {
        this.acquisitionEquityEntities = acquisitionEquityEntities;
    }

    public List<CapitalVO> getCapitalEntities() {
        return capitalEntities;
    }

    public void setCapitalEntities(List<CapitalVO> capitalEntities) {
        this.capitalEntities = capitalEntities;
    }

    public List<CapitalReductionVO> getCapitalReductionEntities() {
        return capitalReductionEntities;
    }

    public void setCapitalReductionEntities(List<CapitalReductionVO> capitalReductionEntities) {
        this.capitalReductionEntities = capitalReductionEntities;
    }

    public List<ConformanceContentVO> getConformanceContentEntities() {
        return conformanceContentEntities;
    }

    public void setConformanceContentEntities(List<ConformanceContentVO> conformanceContentEntities) {
        this.conformanceContentEntities = conformanceContentEntities;
    }

    public List<CurrencyVO> getCurrencyEntities() {
        return currencyEntities;
    }

    public void setCurrencyEntities(List<CurrencyVO> currencyEntities) {
        this.currencyEntities = currencyEntities;
    }

    public List<NoneCurrencyVO> getNoneCurrencyEntities() {
        return noneCurrencyEntities;
    }

    public void setNoneCurrencyEntities(List<NoneCurrencyVO> noneCurrencyEntities) {
        this.noneCurrencyEntities = noneCurrencyEntities;
    }

    public List<ReformNewShareholderVO> getReformNewShareholderEntities() {
        return reformNewShareholderEntities;
    }

    public void setReformNewShareholderEntities(List<ReformNewShareholderVO> reformNewShareholderEntities) {
        this.reformNewShareholderEntities = reformNewShareholderEntities;
    }

    public List<ResidualPropertyVO> getResidualPropertyEntities() {
        return residualPropertyEntities;
    }

    public void setResidualPropertyEntities(List<ResidualPropertyVO> residualPropertyEntities) {
        this.residualPropertyEntities = residualPropertyEntities;
    }

    public List<TransferInfoVO> getTransferInfoEntities() {
        return transferInfoEntities;
    }

    public void setTransferInfoEntities(List<TransferInfoVO> transferInfoEntities) {
        this.transferInfoEntities = transferInfoEntities;
    }

    public String getProductionTypeName() {
        return productionTypeName;
    }

    public void setProductionTypeName(String productionTypeName) {
        this.productionTypeName = productionTypeName;
    }

    public String getProductionTypeCode() {
        return productionTypeCode;
    }

    public void setProductionTypeCode(String productionTypeCode) {
        this.productionTypeCode = productionTypeCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getOrgForm() {
        return orgForm;
    }

    public void setOrgForm(String orgForm) {
        this.orgForm = orgForm;
    }

    public String getOrgType() {
        return orgType;
    }

    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }

    public String getDecisionProgramName() {
        return decisionProgramName;
    }

    public void setDecisionProgramName(String decisionProgramName) {
        this.decisionProgramName = decisionProgramName;
    }

    public List<InvestorsVO> getInvestorsEntities() {
        return investorsEntities;
    }

    public void setInvestorsEntities(List<InvestorsVO> investorsEntities) {
        this.investorsEntities = investorsEntities;
    }

    public Long getReductionCapitalId() {
        return reductionCapitalId;
    }

    public void setReductionCapitalId(Long reductionCapitalId) {
        this.reductionCapitalId = reductionCapitalId;
    }

    public Long getRegistrationPropertyRightsId() {
        return registrationPropertyRightsId;
    }

    public void setRegistrationPropertyRightsId(Long registrationPropertyRightsId) {
        this.registrationPropertyRightsId = registrationPropertyRightsId;
    }

    public String getApplyType() {
        return applyType;
    }

    public void setApplyType(String applyType) {
        this.applyType = applyType;
    }

    public String getRouteUrl() {
        return routeUrl;
    }

    public void setRouteUrl(String routeUrl) {
        this.routeUrl = routeUrl;
    }

    public Boolean getUseStatus() {
        return useStatus;
    }

    public void setUseStatus(Boolean useStatus) {
        this.useStatus = useStatus;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getInvestorsBefore() {
        return investorsBefore;
    }

    public void setInvestorsBefore(String investorsBefore) {
        this.investorsBefore = investorsBefore;
    }

    public String getInvestorsAfter() {
        return investorsAfter;
    }

    public void setInvestorsAfter(String investorsAfter) {
        this.investorsAfter = investorsAfter;
    }

    public String getHistoryRecord() {
        return historyRecord;
    }

    public void setHistoryRecord(String historyRecord) {
        this.historyRecord = historyRecord;
    }

    public String getApplyTypeName() {
        return applyTypeName;
    }

    public void setApplyTypeName(String applyTypeName) {
        this.applyTypeName = applyTypeName;
    }

    public String getInReacrdName() {
        return inReacrdName;
    }

    public void setInReacrdName(String inReacrdName) {
        this.inReacrdName = inReacrdName;
    }

    public Long getInitiatorId() {
        return initiatorId;
    }

    public void setInitiatorId(Long initiatorId) {
        this.initiatorId = initiatorId;
    }

    public String getInitiatorName() {
        return initiatorName;
    }

    public void setInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
    }

    public String getInvestedEnterpriseValuationFilingCode() {
        return investedEnterpriseValuationFilingCode;
    }

    public void setInvestedEnterpriseValuationFilingCode(String investedEnterpriseValuationFilingCode) {
        this.investedEnterpriseValuationFilingCode = investedEnterpriseValuationFilingCode;
    }

    public BigDecimal getInvestedEnterpriseAssetsAppraisalValue() {
        return investedEnterpriseAssetsAppraisalValue;
    }

    public void setInvestedEnterpriseAssetsAppraisalValue(BigDecimal investedEnterpriseAssetsAppraisalValue) {
        this.investedEnterpriseAssetsAppraisalValue = investedEnterpriseAssetsAppraisalValue;
    }

    public String getInvestedEnterpriseAssetsAppraisalValueBig() {
        return investedEnterpriseAssetsAppraisalValueBig;
    }

    public void setInvestedEnterpriseAssetsAppraisalValueBig(String investedEnterpriseAssetsAppraisalValueBig) {
        this.investedEnterpriseAssetsAppraisalValueBig = investedEnterpriseAssetsAppraisalValueBig;
    }

    public BigDecimal getFundedEnterpriseEquityRatio() {
        return fundedEnterpriseEquityRatio;
    }

    public void setFundedEnterpriseEquityRatio(BigDecimal fundedEnterpriseEquityRatio) {
        this.fundedEnterpriseEquityRatio = fundedEnterpriseEquityRatio;
    }

    public Boolean getInvolvingInvestedEnterprisesContribution() {
        return involvingInvestedEnterprisesContribution;
    }

    public void setInvolvingInvestedEnterprisesContribution(Boolean involvingInvestedEnterprisesContribution) {
        this.involvingInvestedEnterprisesContribution = involvingInvestedEnterprisesContribution;
    }

    public Boolean getInvolvingInvestedEnterprisesShareContribution() {
        return involvingInvestedEnterprisesShareContribution;
    }

    public void setInvolvingInvestedEnterprisesShareContribution(Boolean involvingInvestedEnterprisesShareContribution) {
        this.involvingInvestedEnterprisesShareContribution = involvingInvestedEnterprisesShareContribution;
    }

    public Boolean getApprovalThereAssessmentRecordDocument() {
        return approvalThereAssessmentRecordDocument;
    }

    public void setApprovalThereAssessmentRecordDocument(Boolean approvalThereAssessmentRecordDocument) {
        this.approvalThereAssessmentRecordDocument = approvalThereAssessmentRecordDocument;
    }

    public String getApprovalIntermediaryStructureName() {
        return approvalIntermediaryStructureName;
    }

    public void setApprovalIntermediaryStructureName(String approvalIntermediaryStructureName) {
        this.approvalIntermediaryStructureName = approvalIntermediaryStructureName;
    }

    public String getApprovalRecordOrApprovedName() {
        return approvalRecordOrApprovedName;
    }

    public void setApprovalRecordOrApprovedName(String approvalRecordOrApprovedName) {
        this.approvalRecordOrApprovedName = approvalRecordOrApprovedName;
    }

    public String getApprovalRecordOrApprovedFile() {
        return approvalRecordOrApprovedFile;
    }

    public void setApprovalRecordOrApprovedFile(String approvalRecordOrApprovedFile) {
        this.approvalRecordOrApprovedFile = approvalRecordOrApprovedFile;
    }

    public String getApprovalOtherRequiringExplanation() {
        return approvalOtherRequiringExplanation;
    }

    public void setApprovalOtherRequiringExplanation(String approvalOtherRequiringExplanation) {
        this.approvalOtherRequiringExplanation = approvalOtherRequiringExplanation;
    }

    public Boolean getNoneCurrencyThereAssessmentRecordDocument() {
        return noneCurrencyThereAssessmentRecordDocument;
    }

    public void setNoneCurrencyThereAssessmentRecordDocument(Boolean noneCurrencyThereAssessmentRecordDocument) {
        this.noneCurrencyThereAssessmentRecordDocument = noneCurrencyThereAssessmentRecordDocument;
    }

    public String getNoneCurrencyIntermediaryStructureName() {
        return noneCurrencyIntermediaryStructureName;
    }

    public void setNoneCurrencyIntermediaryStructureName(String noneCurrencyIntermediaryStructureName) {
        this.noneCurrencyIntermediaryStructureName = noneCurrencyIntermediaryStructureName;
    }

    public String getNoneCurrencyRecordOrApprovedName() {
        return noneCurrencyRecordOrApprovedName;
    }

    public void setNoneCurrencyRecordOrApprovedName(String noneCurrencyRecordOrApprovedName) {
        this.noneCurrencyRecordOrApprovedName = noneCurrencyRecordOrApprovedName;
    }

    public String getNoneCurrencyRecordOrApprovedFile() {
        return noneCurrencyRecordOrApprovedFile;
    }

    public void setNoneCurrencyRecordOrApprovedFile(String noneCurrencyRecordOrApprovedFile) {
        this.noneCurrencyRecordOrApprovedFile = noneCurrencyRecordOrApprovedFile;
    }

    public String getNoneCurrencyEvaluationReportNo() {
        return noneCurrencyEvaluationReportNo;
    }

    public void setNoneCurrencyEvaluationReportNo(String noneCurrencyEvaluationReportNo) {
        this.noneCurrencyEvaluationReportNo = noneCurrencyEvaluationReportNo;
    }

    public String getNoneCurrencyOtherRequiringExplanation() {
        return noneCurrencyOtherRequiringExplanation;
    }

    public void setNoneCurrencyOtherRequiringExplanation(String noneCurrencyOtherRequiringExplanation) {
        this.noneCurrencyOtherRequiringExplanation = noneCurrencyOtherRequiringExplanation;
    }

    public String getInitiatorUnifiedSocialCreditCode() {
        return initiatorUnifiedSocialCreditCode;
    }

    public void setInitiatorUnifiedSocialCreditCode(String initiatorUnifiedSocialCreditCode) {
        this.initiatorUnifiedSocialCreditCode = initiatorUnifiedSocialCreditCode;
    }

    public BigDecimal getInvestmentAmount() {
        return investmentAmount;
    }

    public void setInvestmentAmount(BigDecimal investmentAmount) {
        this.investmentAmount = investmentAmount;
    }

    public String getInvestmentAmountBig() {
        return investmentAmountBig;
    }

    public void setInvestmentAmountBig(String investmentAmountBig) {
        this.investmentAmountBig = investmentAmountBig;
    }

    public BigDecimal getEquityRatio() {
        return equityRatio;
    }

    public void setEquityRatio(BigDecimal equityRatio) {
        this.equityRatio = equityRatio;
    }

    /*public List<TransfererVO> getTransfererEntities() {
        return transfererEntities;
    }

    public void setTransfererEntities(List<TransfererVO> transfererEntities) {
        this.transfererEntities = transfererEntities;
    }

    public List<TransferorVO> getTransferorEntities() {
        return transferorEntities;
    }

    public void setTransferorEntities(List<TransferorVO> transferorEntities) {
        this.transferorEntities = transferorEntities;
    }*/

    public String getTransactionOrgName() {
        return transactionOrgName;
    }

    public void setTransactionOrgName(String transactionOrgName) {
        this.transactionOrgName = transactionOrgName;
    }

    public String getTransactionProjectCode() {
        return transactionProjectCode;
    }

    public void setTransactionProjectCode(String transactionProjectCode) {
        this.transactionProjectCode = transactionProjectCode;
    }

    public Date getTransactionEndDate() {
        return transactionEndDate;
    }

    public void setTransactionEndDate(Date transactionEndDate) {
        this.transactionEndDate = transactionEndDate;
    }

    public BigDecimal getListingPrice() {
        return listingPrice;
    }

    public void setListingPrice(BigDecimal listingPrice) {
        this.listingPrice = listingPrice;
    }

    public String getAssessedValueNetAssetsBig() {
        return assessedValueNetAssetsBig;
    }

    public void setAssessedValueNetAssetsBig(String assessedValueNetAssetsBig) {
        this.assessedValueNetAssetsBig = assessedValueNetAssetsBig;
    }

    public BigDecimal getTransactionPrice() {
        return transactionPrice;
    }

    public void setTransactionPrice(BigDecimal transactionPrice) {
        this.transactionPrice = transactionPrice;
    }

    public String getTransactionPriceBig() {
        return transactionPriceBig;
    }

    public void setTransactionPriceBig(String transactionPriceBig) {
        this.transactionPriceBig = transactionPriceBig;
    }

    public String getDeclareEnterpriseType() {
        return declareEnterpriseType;
    }

    public void setDeclareEnterpriseType(String declareEnterpriseType) {
        this.declareEnterpriseType = declareEnterpriseType;
    }

    public String getTransfereeNature() {
        return transfereeNature;
    }

    public void setTransfereeNature(String transfereeNature) {
        this.transfereeNature = transfereeNature;
    }

    public Long getTransfereeEnterpriseId() {
        return transfereeEnterpriseId;
    }

    public void setTransfereeEnterpriseId(Long transfereeEnterpriseId) {
        this.transfereeEnterpriseId = transfereeEnterpriseId;
    }

    public String getTransfereeEnterpriseName() {
        return transfereeEnterpriseName;
    }

    public void setTransfereeEnterpriseName(String transfereeEnterpriseName) {
        this.transfereeEnterpriseName = transfereeEnterpriseName;
    }

    public String getTransfereeUnifiedSocialCreditCode() {
        return transfereeUnifiedSocialCreditCode;
    }

    public void setTransfereeUnifiedSocialCreditCode(String transfereeUnifiedSocialCreditCode) {
        this.transfereeUnifiedSocialCreditCode = transfereeUnifiedSocialCreditCode;
    }

    public String getPricingBasis() {
        return pricingBasis;
    }

    public void setPricingBasis(String pricingBasis) {
        this.pricingBasis = pricingBasis;
    }

    public String getTransfereeType() {
        return transfereeType;
    }

    public void setTransfereeType(String transfereeType) {
        this.transfereeType = transfereeType;
    }

    public Long getInUseOrgId() {
        return inUseOrgId;
    }

    public void setInUseOrgId(Long inUseOrgId) {
        this.inUseOrgId = inUseOrgId;
    }

    public Boolean getNotCentralEnterprises() {
        return notCentralEnterprises;
    }

    public void setNotCentralEnterprises(Boolean notCentralEnterprises) {
        this.notCentralEnterprises = notCentralEnterprises;
    }

    public String getOwnedAssetsSupervisionAuthority() {
        return ownedAssetsSupervisionAuthority;
    }

    public void setOwnedAssetsSupervisionAuthority(String ownedAssetsSupervisionAuthority) {
        this.ownedAssetsSupervisionAuthority = ownedAssetsSupervisionAuthority;
    }

    public Long getTransfererEnterpriseId() {
        return transfererEnterpriseId;
    }

    public void setTransfererEnterpriseId(Long transfererEnterpriseId) {
        this.transfererEnterpriseId = transfererEnterpriseId;
    }

    public String getTransfererEnterpriseName() {
        return transfererEnterpriseName;
    }

    public void setTransfererEnterpriseName(String transfererEnterpriseName) {
        this.transfererEnterpriseName = transfererEnterpriseName;
    }

    public String getTransfererUnifiedSocialCreditCode() {
        return transfererUnifiedSocialCreditCode;
    }

    public void setTransfererUnifiedSocialCreditCode(String transfererUnifiedSocialCreditCode) {
        this.transfererUnifiedSocialCreditCode = transfererUnifiedSocialCreditCode;
    }
}
