/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sddjsorg.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.vo.OrgApplyVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"orgApply"})
public class OrgApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "sddjs-org-apply";
    @Autowired
    private IOrgApplyService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPushMessageApi pushMessageApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrgApplyVO> saveOrUpdate(@RequestBody OrgApplyVO saveorUpdateVO) {
        OrgApplyEntity entity;
        if ("set".equals(saveorUpdateVO.getApplyType()) || "supplementary".equals(saveorUpdateVO.getApplyType())) {
            this.checkRepetition(saveorUpdateVO);
        }
        if ((entity = (OrgApplyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OrgApplyEntity.class))).getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        OrgApplyVO vo = (OrgApplyVO)BeanMapper.map((Object)((Object)entity), OrgApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    public void checkRepetition(OrgApplyVO saveorUpdateVO) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("name", new Parameter("eq", (Object)saveorUpdateVO.getName()));
        ArrayList<String> applyType = new ArrayList<String>();
        applyType.add("set");
        applyType.add("supplementary");
        queryParam.getParams().put("applyType", new Parameter("in", applyType));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (saveorUpdateVO.getId() != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)saveorUpdateVO.getId()));
        }
        if ((list = this.service.queryList(queryParam, false)) != null && list.size() > 0) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff01\u5df2\u7ecf\u5b58\u5728\u516c\u53f8\u540d\u79f0\u4e3a[" + saveorUpdateVO.getName() + "]\u7684\u7ec4\u7ec7\u673a\u6784");
        }
        if (StringUtils.isNotBlank((CharSequence)saveorUpdateVO.getUnifiedSocialCreditCode())) {
            List listCode;
            QueryParam queryParamCode = new QueryParam();
            queryParamCode.getParams().put("unifiedSocialCreditCode", new Parameter("eq", (Object)saveorUpdateVO.getUnifiedSocialCreditCode()));
            queryParamCode.getParams().put("applyType", new Parameter("in", applyType));
            queryParamCode.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            if (saveorUpdateVO.getId() != null) {
                queryParamCode.getParams().put("id", new Parameter("ne", (Object)saveorUpdateVO.getId()));
            }
            if ((listCode = this.service.queryList(queryParamCode, false)) != null && listCode.size() > 0) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff01\u5df2\u7ecf\u5b58\u5728\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a[" + saveorUpdateVO.getName() + "]\u7684\u7ec4\u7ec7\u673a\u6784");
            }
        }
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrgApplyVO> queryDetail(Long id) {
        OrgApplyEntity entity = (OrgApplyEntity)((Object)this.service.selectById(id));
        OrgApplyVO vo = (OrgApplyVO)BeanMapper.map((Object)((Object)entity), OrgApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrgApplyVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrgApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrgApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OrgApply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOrgApplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OrgApplyVO>> refOrgApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrgApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/file"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> file(Long id) {
        return this.service.file(id);
    }

    @RequestMapping(value={"/unfile"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> unfile(Long id) {
        return this.service.unfile(id);
    }

    @RequestMapping(value={"/assign"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> assign(@RequestBody OrgApplyVO saveorUpdateVO) {
        OrgApplyEntity entity = (OrgApplyEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
        entity.setCurrentProcessor(saveorUpdateVO.getCurrentProcessor());
        entity.setCurrentProcessorName(saveorUpdateVO.getCurrentProcessorName());
        entity.setPendingStartTime(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        channel.add("sys");
        String[] receivers = new String[]{saveorUpdateVO.getCurrentProcessor().toString()};
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType("notice");
        parameter.setSubject("\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u6307\u6d3e\u5904\u7406\uff1a\u3010\u7ec4\u7ec7\u673a\u6784\u8bbe\u7acb\u7533\u8bf7 \u3011   \u516c\u53f8\uff1a" + entity.getName());
        String url = this.baseHost + "ejc-sddjsorg-web/#/orgApply/setApplyCard?id=" + entity.getId();
        parameter.setContent("\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u6307\u6d3e\u5904\u7406\uff1a\u3010\u7ec4\u7ec7\u673a\u6784\u8bbe\u7acb\u7533\u8bf7 \u3011   \u516c\u53f8\uff1a" + entity.getName() + "\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
        return CommonResponse.success((String)"\u6307\u6d3e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/supplement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrgApplyVO> supplement(@RequestBody OrgApplyVO saveorUpdateVO) {
        if ("set".equals(saveorUpdateVO.getApplyType()) || "supplementary".equals(saveorUpdateVO.getApplyType())) {
            this.checkRepetition(saveorUpdateVO);
        }
        OrgApplyEntity entity = (OrgApplyEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, OrgApplyEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        channel.add("sys");
        String[] receivers = new String[]{saveorUpdateVO.getCurrentProcessor().toString()};
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType("notice");
        parameter.setSubject("\u3010\u7ec4\u7ec7\u673a\u6784\u8bbe\u7acb\u7533\u8bf7 \u3011   \u516c\u53f8\uff1a" + entity.getName() + "\u5df2\u5b8c\u6210\u8865\u5145\u4fe1\u606f");
        String url = this.baseHost + "ejc-sddjsorg-web/#/orgApply/setApplyCard?id=" + entity.getId();
        parameter.setContent("\u3010\u7ec4\u7ec7\u673a\u6784\u8bbe\u7acb\u7533\u8bf7 \u3011   \u516c\u53f8\uff1a" + entity.getName() + "\u5df2\u5b8c\u6210\u8865\u5145\u4fe1\u606f\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
        OrgApplyVO vo = (OrgApplyVO)BeanMapper.map((Object)((Object)entity), OrgApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

