package com.ejianc.business.capital.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.capital.bean.CapitalRealPaymentApplyEntity;
import com.ejianc.business.capital.service.ICapitalRealPaymentApplyService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 资本金实缴申请审批回调服务
 *
 * @author CJ
 * @Description:
 * @date 2021/10/15 17:55
 */
public class CapitalRealPayApplyBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICapitalRealPaymentApplyService capitalRealPaymentApplyService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * 提交审批
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        CapitalRealPaymentApplyEntity e = capitalRealPaymentApplyService.selectById(billId);
        UserContext userContext = sessionManager.getUserContext();

        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        capitalRealPaymentApplyService.saveOrUpdate(e, false);

        return CommonResponse.success("资本金实缴申请审批回调处理成功！");
    }

    /**
     * 直审/审批通过
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

        if(state == 1) {
            CapitalRealPaymentApplyEntity e = capitalRealPaymentApplyService.selectById(billId);
            UserContext userContext = sessionManager.getUserContext();

            e.setCommitDate(new Date());
            e.setCommitUserCode(userContext.getUserCode());
            e.setCommitUserName(userContext.getUserName());
            capitalRealPaymentApplyService.saveOrUpdate(e, false);
        }

        return CommonResponse.success("资本金实缴申请审批回调处理成功！");
    }

    /**
     * 撤回回调处理
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return doBpmBack(billId, state, billTypeCode);
    }

    /**
     * 弃审回调处理
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return doBpmBack(billId, state, billTypeCode);
    }

    /**
     * 弃审、撤回回调处理
     *
     * @param billId
     * @param state
     * @param billTypeCode
     * @return
     */
    private CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
        CapitalRealPaymentApplyEntity e = capitalRealPaymentApplyService.selectById(billId);
        logger.info("资本金实缴申请单据-【{}】执行撤回逻辑", JSONObject.toJSONString(e));

        //清空生效时间/提交人相关信息
        e.setEffectiveDate(null);
        e.setCommitDate(null);
        e.setCommitUserCode(null);
        e.setCommitUserName(null);
        capitalRealPaymentApplyService.saveOrUpdate(e, false);

        return CommonResponse.success("执行资本金实缴申请单据撤回逻辑成功! ");
    }

}
