package com.ejianc.business.capital.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 资本金收款登记-实缴收款信息子实体
 *
 * @author CJ
 * @Description: 资本金收款登记-实缴收款信息子实体
 * @date 2021/10/19 10:25
 */
@TableName(value = "ejc_sddjsorg_capital_rec_registry_sub")
public class CapitalRecRegistrySubEntity extends BaseEntity {

    private static final long serialVersionUID = 9093426690115192047L;
    /**
     * 主表Id
     */
    @TableField(value = "capital_rec_registry_id")
    private Long capitalRecRegistryId;

    /**
     * 出资方Id
     */
    @TableField(value = "captail_id")
    private Long captailId;

    /**
     * 出资方名称
     */
    @TableField(value="captail_name")
    private String captailName;

    /**
     * 内/外部出资方
     */
    @TableField(value="in_out_captail")
    private String inOutCaptail;

    /**
     * 认缴资本
     */
    @TableField(value="subscribed_capital")
    private BigDecimal subscribedCapital;

    /**
     * 认缴资本(大写)
     */
    @TableField(value="subscribed_capital_big")
    private String subscribedCapitalBig;

    /**
     * 实缴资本
     */
    @TableField(value="paid_capital")
    private BigDecimal paidCapital;

    /**
     * 实缴资本(大写)
     */
    @TableField(value="paid_capital_big")
    private String paidCapitalBig;

    /**
     * 累计实缴金额
     */
    @TableField(value = "total_paid_capital")
    private BigDecimal totalPaidCapital;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 本次实缴金额
     */
    @TableField(value = "cur_pay_amt")
    private BigDecimal curPayAmt;

    /**
     * 附件路径
     */
    @TableField(value = "attach_file_paths")
    private String attachFilePaths;

    public String getAttachFilePaths() {
        return attachFilePaths;
    }

    public void setAttachFilePaths(String attachFilePaths) {
        this.attachFilePaths = attachFilePaths;
    }

    public BigDecimal getCurPayAmt() {
        return curPayAmt;
    }

    public void setCurPayAmt(BigDecimal curPayAmt) {
        this.curPayAmt = curPayAmt;
    }

    public Long getCapitalRecRegistryId() {
        return capitalRecRegistryId;
    }

    public void setCapitalRecRegistryId(Long capitalRecRegistryId) {
        this.capitalRecRegistryId = capitalRecRegistryId;
    }

    public Long getCaptailId() {
        return captailId;
    }

    public void setCaptailId(Long captailId) {
        this.captailId = captailId;
    }

    public String getCaptailName() {
        return captailName;
    }

    public void setCaptailName(String captailName) {
        this.captailName = captailName;
    }

    public String getInOutCaptail() {
        return inOutCaptail;
    }

    public void setInOutCaptail(String inOutCaptail) {
        this.inOutCaptail = inOutCaptail;
    }

    public BigDecimal getSubscribedCapital() {
        return subscribedCapital;
    }

    public void setSubscribedCapital(BigDecimal subscribedCapital) {
        this.subscribedCapital = subscribedCapital;
    }

    public String getSubscribedCapitalBig() {
        return subscribedCapitalBig;
    }

    public void setSubscribedCapitalBig(String subscribedCapitalBig) {
        this.subscribedCapitalBig = subscribedCapitalBig;
    }

    public BigDecimal getPaidCapital() {
        return paidCapital;
    }

    public void setPaidCapital(BigDecimal paidCapital) {
        this.paidCapital = paidCapital;
    }

    public String getPaidCapitalBig() {
        return paidCapitalBig;
    }

    public void setPaidCapitalBig(String paidCapitalBig) {
        this.paidCapitalBig = paidCapitalBig;
    }

    public BigDecimal getTotalPaidCapital() {
        return totalPaidCapital;
    }

    public void setTotalPaidCapital(BigDecimal totalPaidCapital) {
        this.totalPaidCapital = totalPaidCapital;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
