package com.ejianc.business.orgcenter.mapper;

import com.ejianc.business.orgcenter.bean.AdministrativeAreaEntity;
import com.ejianc.business.orgcenter.vo.AdministrativeAreaVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2021/10/12 10:47
 */
@Mapper
public interface AdministrativeAreaMapper extends BaseCrudMapper<AdministrativeAreaEntity> {
    /**
     * 根据主键批量删除行政地区记录
     *
     * @param ids
     */
    void batchDelByIds(@Param(value = "ids") List<Long> ids);

    /**
     * 查询匹配的行政地区
     *
     * @param pid
     * @return
     */
    List<Map> queryAll(@Param(value = "pid") Long pid);

    /**
     * 查询匹配的地区列表
     *
     * @param pid
     * @param billCode
     * @param areaName
     * @return
     */
    List<AdministrativeAreaVO> queryList(@Param(value = "pid") Long pid, @Param(value = "billCode")  String billCode, @Param(value = "areaName")  String areaName);
}
