package com.ejianc.business.production.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.bean.CapitalEntity;
import com.ejianc.business.production.bean.ProductionTypeItemEntity;
import com.ejianc.business.production.service.IProductionTypeItemService;
import com.ejianc.business.production.vo.CapitalVO;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.OrgShareholderEntity;
import com.ejianc.business.sddjsorg.mapper.OrgApplyMapper;
import com.ejianc.business.sddjsorg.mapper.OrgShareholderMapper;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.service.IOrgShareholderService;
import com.ejianc.business.sddjsorg.vo.OrgApplyVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.production.mapper.ProductionMapper;
import com.ejianc.business.production.bean.ProductionEntity;
import com.ejianc.business.production.service.IProductionService;

import java.math.BigDecimal;
import java.util.*;

/**
 * 产权登记主表
 * 
 * @author generator
 * 
 */
@Service("productionService")
public class ProductionServiceImpl extends BaseServiceImpl<ProductionMapper, ProductionEntity> implements IProductionService{
    @Autowired
    private IOrgApplyService orgApplyService;
    @Autowired
    private OrgShareholderMapper orgShareholderMapper;
    @Autowired
    private IOrgShareholderService orgShareholderService;
    @Autowired
    private IProductionTypeItemService productionTypeItemService;
    @Override
    public boolean registerSave(ProductionEntity productionEntity) {

        return false;
    }

    /**
     * 指派
     * @param applyId
     * @param userId
     * @param userName
     * @return
     */
    public CommonResponse<String> assignTask(Long applyId,Long userId,String userName) {
        try{
            OrgApplyEntity orgApplyEntity =orgApplyService.getById(applyId);
            orgApplyEntity.setCurrentProcessorName(userName);
            orgApplyEntity.setCurrentProcessor(userId);
            orgApplyEntity.setPendingStartTime(new Date());
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.success("指派失败");
        }

        return CommonResponse.success("指派成功");
    }

    /**
     * 根据申请id 和出资类型查询数据
     * @param applyId
     * @param contributionType
     * @return
     */
    public List<OrgShareholderEntity> queryApplyShareholderByApplyIdList(Long applyId, String contributionType) {
        QueryWrapper<OrgShareholderEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("pid", applyId);
        queryWrapper.eq("dr","0");
        if(StringUtils.isNotBlank(contributionType)){
            queryWrapper.eq("contribution_type",contributionType);
        }else{
            queryWrapper.ne("contribution_type","现金");
        }
        return orgShareholderMapper.selectList(queryWrapper);
    }

    /**
     * 查询产权登记类型子数据
     * @return
     */
    public List<ProductionTypeItemEntity> queryProductionTypeItemList() {
        return productionTypeItemService.list();
    }

    @Override
    public List<OrgShareholderEntity> queryApplyShareholderByApplyIdAllList(Long applyId) {
        QueryWrapper<OrgShareholderEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("pid", applyId);
        queryWrapper.eq("dr","0");

        return orgShareholderMapper.selectList(queryWrapper);
    }

    public List<CapitalVO> queryApplyShareholderByApplyIdSumCaptailName(Long applyId) {

        List<CapitalVO> resp = new ArrayList<CapitalVO>();
        QueryWrapper<OrgShareholderEntity> query = new QueryWrapper<>();
        query.select("  count(id) as  declaredNumberEnterprises,captail_type as  captailType");
        query.eq("pid", applyId);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.groupBy("captail_type");
        Map<String, Object> dataMap = orgShareholderService.getMap(query);

        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            CapitalVO vo = new CapitalVO();
            vo.setCaptailType((String) dataMap.get("captailType"));
            vo.setDeclaredNumberEnterprises((Long) (dataMap.get("declaredNumberEnterprises") != null?dataMap.get("declaredNumberEnterprises"):0));
            resp.add(vo);
        }
        return resp;

    }
}
