package com.ejianc.business.sddjsorg.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.SddjsOrgEntity;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.service.ISddjsOrgService;
import com.ejianc.business.sddjsorg.vo.OrgApplyFileVO;
import com.ejianc.business.sddjsorg.vo.OrgApplyVO;
import com.ejianc.business.sddjsorg.vo.SddjsOrgVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 组织机构实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sddjsorg")
public class SddjsOrgController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    private static final String BILL_CODE = "sddjs-org";//此处需要根据实际修改

    @Autowired
    private ISddjsOrgService service;

    @Autowired
    private IOrgApplyService orgApplyService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SddjsOrgVO> saveOrUpdate(@RequestBody SddjsOrgVO saveorUpdateVO) {
    	SddjsOrgEntity entity = BeanMapper.map(saveorUpdateVO, SddjsOrgEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SddjsOrgVO vo = BeanMapper.map(entity, SddjsOrgVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SddjsOrgVO> queryDetail(Long id) {
    	SddjsOrgEntity entity = service.selectById(id);
    	SddjsOrgVO vo = BeanMapper.map(entity, SddjsOrgVO.class);
    	QueryWrapper<OrgApplyEntity> queryWrapper = new QueryWrapper<>();
    	queryWrapper.eq("in_use_org_id", id);
    	queryWrapper.orderByDesc("create_time");
		List<OrgApplyEntity> list = orgApplyService.list(queryWrapper);
		if(list!=null&&list.size()>0){
			vo.setOrgApplyList(BeanMapper.mapList(list, OrgApplyVO.class));
		}
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SddjsOrgVO> vos) {
        service.removeByIds(vos.stream().map(SddjsOrgVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SddjsOrgVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(SddjsOrgVO::getId).collect(Collectors.toList())));

        IPage<SddjsOrgEntity> page = service.queryPage(param,false);
        IPage<SddjsOrgVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SddjsOrgVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SddjsOrgEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Org-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOrgData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SddjsOrgVO>> refOrgData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SddjsOrgEntity> page = service.queryPage(param,false);
        IPage<SddjsOrgVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SddjsOrgVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryChangeDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrgApplyVO> queryChangeDetail(Long changeId) {
    	SddjsOrgEntity entity = service.selectById(changeId);
    	OrgApplyVO vo = BeanMapper.map(entity, OrgApplyVO.class);
    	Long id = IdWorker.getId();
    	vo.setInUseOrgId(entity.getId());
    	vo.setApplyType("change");
    	vo.setId(id);
    	vo.setCreateTime(null);
    	vo.setCreateUserCode(null);
    	vo.setTenantId(InvocationInfoProxy.getTenantid());
    	vo.setUpdateTime(null);
    	vo.setUpdateUserCode(null);
    	vo.setBillState(null);
    	vo.setOrgApplyFileList(null);
    	//营业执照
    	attachmentApi.copyFilesFromSourceBillToTargetBill(entity.getId().toString(), "BT211012000000004", "businessLicense", id.toString(), "BT211012000000004", "businessLicense");
    	//公司章程
    	attachmentApi.copyFilesFromSourceBillToTargetBill(entity.getId().toString(), "BT211012000000004", "articles", id.toString(), "BT211012000000004", "articles");
		if(vo.getOrgShareholderList()!=null&&vo.getOrgShareholderList().size()>0){
			vo.getOrgShareholderList().forEach(older -> {
				older.setCreateTime(null);
				older.setCreateUserCode(null);
				older.setTenantId(InvocationInfoProxy.getTenantid());
				older.setUpdateTime(null);
				older.setUpdateUserCode(null);
				older.setPid(null);
				older.setRowState("add");
			});
		}
		vo.setChangeOldContent(vo.toString());
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情(注销使用)
     * @param id
     */
    @RequestMapping(value = "/queryCancellationDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrgApplyVO> queryCancellationDetail(Long changeId) {
    	SddjsOrgEntity entity = service.selectById(changeId);
    	OrgApplyVO vo = BeanMapper.map(entity, OrgApplyVO.class);
    	Long id = IdWorker.getId();
    	vo.setInUseOrgId(entity.getId());
    	vo.setApplyType("del");
    	vo.setOrgCode(entity.getCode());
    	vo.setCode(null);
    	vo.setId(id);
    	vo.setCreateTime(null);
    	vo.setCreateUserCode(null);
    	vo.setTenantId(InvocationInfoProxy.getTenantid());
    	vo.setUpdateTime(null);
    	vo.setUpdateUserCode(null);
    	vo.setBillState(null);
    	vo.setOrgApplyFileList(null);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
}
