/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.production.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.production.bean.ProductionEntity;
import com.ejianc.business.production.bean.ProductionTypeItemEntity;
import com.ejianc.business.production.service.IProductionService;
import com.ejianc.business.production.vo.CapitalVO;
import com.ejianc.business.production.vo.OrgApplyVOS;
import com.ejianc.business.production.vo.ProductionTypeItemVO;
import com.ejianc.business.production.vo.ProductionVO;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.OrgShareholderEntity;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.vo.OrgApplyVO;
import com.ejianc.business.sddjsorg.vo.OrgShareholderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"production"})
public class ProductionController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "sddjs-production";
    @Autowired
    private IProductionService service;
    @Autowired
    private IOrgApplyService orgApplyService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProductionVO> saveOrUpdate(@RequestBody ProductionVO saveorUpdateVO) {
        ProductionEntity entity = (ProductionEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ProductionEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProductionVO vo = (ProductionVO)BeanMapper.map((Object)((Object)entity), ProductionVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/noRegister"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> noRegister(Long applyId) {
        OrgApplyEntity applyEntity = (OrgApplyEntity)((Object)this.orgApplyService.selectById(applyId));
        applyEntity.setProductionState("noregister");
        this.orgApplyService.updateById((Object)applyEntity);
        return CommonResponse.success((String)"\u4e0d\u767b\u8bb0\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProductionVO> queryDetail(Long id) {
        ProductionEntity entity = (ProductionEntity)((Object)this.service.selectById(id));
        ProductionVO vo = (ProductionVO)BeanMapper.map((Object)((Object)entity), ProductionVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryOrgDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrgApplyVOS> queryOrgDetail(Long applyId) {
        OrgApplyEntity entity = (OrgApplyEntity)((Object)this.orgApplyService.selectById(applyId));
        List<OrgShareholderEntity> currencyEntities = this.service.queryApplyShareholderByApplyIdList(applyId, "\u73b0\u91d1");
        List<OrgShareholderEntity> noneCurrencyEntities = this.service.queryApplyShareholderByApplyIdList(applyId, null);
        OrgApplyVOS vo = (OrgApplyVOS)BeanMapper.map((Object)((Object)entity), OrgApplyVOS.class);
        vo.setCurrencyEntities(BeanMapper.mapList(currencyEntities, OrgShareholderVO.class));
        vo.setNoneCurrencyEntities(BeanMapper.mapList(currencyEntities, OrgShareholderVO.class));
        List<ProductionTypeItemEntity> productionTypeItemEntityList = this.service.queryProductionTypeItemList();
        List<OrgShareholderEntity> acquisitionEquityVOList = this.service.queryApplyShareholderByApplyIdAllList(applyId);
        vo.setAcquisitionEquityEntities(BeanMapper.mapList(acquisitionEquityVOList, OrgShareholderVO.class));
        vo.setConformanceContentEntities(BeanMapper.mapList(productionTypeItemEntityList, ProductionTypeItemVO.class));
        List<CapitalVO> capitalList = this.service.queryApplyShareholderByApplyIdSumCaptailName(applyId);
        vo.setCapitalEntities(capitalList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProductionVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryStayList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrgApplyVO>> queryOrgList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.orgApplyService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrgApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryAlreadyList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> queryAlreadyList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/assignTask"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> assignTask(Long applyId, Long userId, String userName) {
        return this.service.assignTask(applyId, userId, userName);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Production-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProductionData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProductionVO>> refProductionData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProductionVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

