package com.ejianc.business.capital.util;

import java.math.BigDecimal;

/**
 * @author CJ
 * @Description:
 * @date 2021/10/19 20:12
 */
public class MoneyUtils {

    /**
     * 汉字的数字
     */
    private static final String[] CN_NUMS = new String[]{"零", "壹", "贰", "叁", "肆", "伍", "陆", "柒", "捌", "玖"};

    /**
     * 基本单位
     */
    private static final String[] CN_INT_RADICE = new String[]{"", "拾", "佰", "仟"};

    /**
     * 对应整数部分扩展单位
     */
    private static final String[] CN_INT_UNITS = new String[]{"", "万", "亿", "兆"};

    /**
     * 对应小数部分单位
     */
    private static final String[] CN_DEC_UNINTS = new String[]{"角", "分", "毫", "厘"};

    private static final String CN_INTEGER = "整";
    private static final String CN_INT_LAST = "元";

    /**
     * 最大处理的数字
     */
    private static final BigDecimal MAX_HANDLER = new BigDecimal("99999999999999.9999");

    public static String getMnyUpCase(BigDecimal mny) {
        StringBuffer chineseStr = new StringBuffer();
        if(null == mny) {
            return "";
        }
        if(MAX_HANDLER.compareTo(mny) < 0) {
            //超出最大处理数字
            return "";
        }
        if(mny.signum() == 0) {
            chineseStr.append(CN_NUMS[0]).append(CN_INT_LAST).append(CN_INTEGER);
        } else {
            //转为字符串
            String mnyStr = mny.toString();
            BigDecimal integerPart = null;
            BigDecimal decimalPart = null;
            if(mnyStr.indexOf(".") > -1) {
                integerPart = new BigDecimal(mnyStr);
                decimalPart = BigDecimal.ZERO;
            } else {
                integerPart = new BigDecimal(mnyStr.split(".")[0]);
                decimalPart = new BigDecimal(mnyStr.split(".")[1].substring(0,4));
            }

            //整数部分
            if(mny.signum() > 0) {
                int zeroCount = 0;
                int curNum = 0;
                for(char numChar : integerPart.toString().toCharArray()) {
                    curNum = Integer.valueOf(numChar);
                    if(curNum == 0) {
                        zeroCount++;
                    } else {
                        if (zeroCount > 0) {
                            chineseStr.append(CN_NUMS[0]);
                        }
                        zeroCount = 0;
                        chineseStr.append(CN_NUMS[curNum]).append(CN_INT_RADICE[curNum / 4]);
                    }
                    if((curNum % 4 == 0) && zeroCount < 4) {
                        chineseStr.append(CN_INT_UNITS[curNum / 4]);
                    }
                }
                chineseStr.append(CN_INT_LAST);
            }

            //小数部分
            if(decimalPart.signum() > 0) {
                int idx = 0;
                int curNum = 0;
                for(char numChar : decimalPart.toString().toCharArray()) {
                    curNum = Integer.valueOf(numChar);
                    if(idx != 0) {
                        if(curNum != 0) {
                            chineseStr.append(CN_NUMS[curNum]).append(CN_DEC_UNINTS[idx]);
                        }
                    } else {
                        chineseStr.append(CN_NUMS[curNum]);
                        if(curNum != 0) {
                            chineseStr.append(CN_DEC_UNINTS[idx]);
                        }
                    }
                    idx++;
                }
            }

            if(chineseStr.length() > 0) {
                chineseStr.append(CN_NUMS[0]).append(CN_INT_LAST).append(CN_INTEGER);
            } else if(decimalPart.signum() == 0) {
                chineseStr.append(CN_INTEGER);
            }
        }

        return chineseStr.toString();
    }

}
