package com.ejianc.business.orgcenter.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 董监高人员
 *
 * @author CJ
 * @Description: 董监高人员
 * @date 2021/9/28 16:10
 */
@TableName(value = "ejc_sddjsorg_director")
public class DirectorEntity extends BaseEntity {

    private static final long serialVersionUID = -8136973661753248231L;

    /**
     * 人员编号
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 人员名称
     */
    @TableField(value = "director_name")
    private String directorName;

    /**
     * 所属组织名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 岗位名称
     */
    @TableField(value = "post_name")
    private String postName;

    /**
     * 是否内部员工：1-内部员工，2-外部人员
     */
    @TableField(value = "director_type")
    private Integer directorType;

    /**
     * 对应内部人员档案Id
     */
    @TableField(value = "source_id")
    private Long sourceId;

    /**
     * 起停用状态: 1-启用，0-停用
     */
    @TableField(value = "status")
    private Integer status;

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getDirectorName() {
        return directorName;
    }

    public void setDirectorName(String directorName) {
        this.directorName = directorName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }

    public Integer getDirectorType() {
        return directorType;
    }

    public void setDirectorType(Integer directorType) {
        this.directorType = directorType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
