package com.ejianc.business.orgcenter.mapper;

import com.ejianc.business.orgcenter.bean.DirectorEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2021/9/28 16:22
 */
@Mapper
public interface DirectorMapper extends BaseCrudMapper<DirectorEntity> {
    /**
     * 根据主键批量删除
     *
     * @param ids
     */
    void batchDelByIds(@Param(value = "ids") List<Long> ids);

    /**
     * 查询指定类型的董监高人员Id列表
     *
     * @param directorType
     * @return
     */
    List<Long> queryAllEmpIds(@Param(value = "directorType") Integer directorType);
}
