package com.ejianc.business.production.service.impl;

import com.ejianc.business.production.bean.ProductionEntity;
import com.ejianc.business.production.bean.ProductionOrgEntity;
import com.ejianc.business.production.service.IProductionOrgService;
import com.ejianc.business.production.service.IProductionService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("production") 
public class ProductionBpmServiceImpl implements ICommonBusinessService {

    @Autowired
	private IProductionService productionService;

    @Autowired
	private IProductionOrgService productionOrgService;
	private static final String BILL_CODE = "sddjs-production-org";//此处需要根据实际修改
	@Autowired
	private IBillCodeApi billCodeApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		ProductionEntity entity =productionService.getById(billId);
		ProductionOrgEntity orgEntity = new ProductionOrgEntity();
		CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
		if(billCode.isSuccess()) {
			orgEntity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
		}else{
			throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
		}
		orgEntity.setName(entity.getName());
		orgEntity.setUnifiedSocialCreditCode(entity.getUnifiedSocialCreditCode());
		orgEntity.setInReacrd(entity.getInReacrd());
		orgEntity.setOutCapitalOrg(Long.valueOf(entity.getOutCapitalOrg()));
		orgEntity.setOutCapitalOrgName(entity.getOutCapitalOrgName());
		orgEntity.setRelationToOutOrg(entity.getReductionCapitalId());
		orgEntity.setRelationToOutOrgName(entity.getRelationToOutOrgName());
		orgEntity.setBeOwner(entity.getBeOwner());
		orgEntity.setMainCapitalOrgId(entity.getMainCapitalOrgId());
		orgEntity.setRelationToOutOrgName(entity.getMainCapitalOrgName());
		orgEntity.setRegisterCountryId(entity.getRegisterCountryId());
		orgEntity.setRegisterCountryName(entity.getRegisterCountryName());
		orgEntity.setRegisterIn(entity.getRegisterIn());
		orgEntity.setRegisterAddress(entity.getRegisterAddress());
		orgEntity.setRegisterDate(entity.getRegisterDate());
		orgEntity.setCurrencyTypeId(entity.getCurrencyTypeId());
		orgEntity.setCurrencyTypeName(entity.getCurrencyTypeName());
		orgEntity.setRegisterCapital(entity.getRegisterCapital());
		orgEntity.setRegisterCapitalBig(entity.getRegisterCapitalBig());
		orgEntity.setOrgTypeId(entity.getOrgTypeId());
		orgEntity.setOrgTypeName(entity.getOrgTypeName());
		orgEntity.setRegulatoryBodiesId(Long.valueOf(entity.getRegulatoryBodiesId()));
		orgEntity.setRegulatoryBodies(entity.getRegulatoryBodies());
		orgEntity.setOrgFormId(entity.getOrgFormId());
		orgEntity.setOrgFormName(entity.getOrgFormName());
		orgEntity.setMajorIndustriesId(entity.getMajorIndustriesId());
		orgEntity.setMajorIndustries(entity.getMajorIndustries());
		orgEntity.setProductLevel(entity.getProductLevel());
		orgEntity.setMangerLevel(entity.getMangerLevel());
		orgEntity.setBeListed(entity.getBeListed());
		orgEntity.setMergeTable(entity.getMergeTable());
		orgEntity.setBeClosed(entity.getBeClosed());
		orgEntity.setProductionId(entity.getId());
		productionOrgService.save(orgEntity);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
