package com.ejianc.business.production.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.production.bean.InvestorsEntity;
import com.ejianc.business.production.bean.ProductionEntity;
import com.ejianc.business.production.mapper.ProductionMapper;
import com.ejianc.business.production.service.IProductionService;
import com.ejianc.business.production.vo.HistoryVO;
import com.ejianc.business.sddjsorg.bean.OrgApplyEntity;
import com.ejianc.business.sddjsorg.bean.OrgShareholderEntity;
import com.ejianc.business.sddjsorg.bean.SddjsOrgEntity;
import com.ejianc.business.sddjsorg.service.IOrgApplyService;
import com.ejianc.business.sddjsorg.service.ISddjsOrgService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.production.mapper.ProductionOrgMapper;
import com.ejianc.business.production.bean.ProductionOrgEntity;
import com.ejianc.business.production.service.IProductionOrgService;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 产权登记生成的公司-出资人情况
 * 
 * @author generator
 * 
 */
@Service("productionOrgService")
public class ProductionOrgServiceImpl extends BaseServiceImpl<ProductionOrgMapper, ProductionOrgEntity> implements IProductionOrgService{
    @Autowired
    private ProductionOrgMapper productionOrgMapper;
    private static final String BILL_CODE = "sddjs-production-org";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IOrgApplyService orgApplyService;
    @Autowired
    private ISddjsOrgService sddjsOrgService;

    /**
     * 根据产权id查询一条数据
     * @param productionId
     * @return
     */
    public ProductionOrgEntity getByProductionId(Long productionId) {
        QueryWrapper wrapper = new QueryWrapper<>();
        wrapper.eq("production_id",productionId);
        wrapper.eq("dr",0);
        ProductionOrgEntity entity = new ProductionOrgEntity();
        List<ProductionOrgEntity> list =productionOrgMapper.selectList(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            entity=list.get(0);
        }
        return entity;
    }

    /**
     * 变更时调用
     * @param entity
     */
    @Transactional
    public void saveOrUpdateOrgProduction(ProductionEntity entity) {
        //设立&和变更
        if(entity.getApplyType().equals("set") || entity.getApplyType().equals("change")){
             saveProductionOrg(entity);
        }

        //注销
        if(entity.getApplyType().equals("del")){
            updateCancellation(entity);
        }
    }

    /**
     * 添加产权公司信息数据
     * @param orgEntity
     * @param entity
     */
    @Transactional
    public void saveProductionOrg(ProductionEntity entity){
        ProductionOrgEntity orgEntity =this.getByProductionId(entity.getId());

        if(orgEntity.getId() == null){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                orgEntity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        ProductionEntity productionEntity=productionService.getById(entity.getId());
        List<HistoryVO> historyVOList = new ArrayList<HistoryVO>();
        if(orgEntity.getId() != null){
            historyVOList.add(updateHistory("企业名称",orgEntity.getName(),entity.getName()));
            historyVOList.add(updateHistory("统一社会信用代码",orgEntity.getUnifiedSocialCreditCode(),entity.getUnifiedSocialCreditCode()));
            historyVOList.add(updateHistory("是否在集团备案",orgEntity.getInReacrd()==true?"备案":"未备案",entity.getInReacrd()==true?"备案":"未备案"));
            historyVOList.add(updateHistory("国家出资企业名称",orgEntity.getOutCapitalOrgName(),entity.getOutCapitalOrgName()));
            historyVOList.add(updateHistory("与国家出资企业的关系名称",orgEntity.getRelationToOutOrgName(),entity.getRelationToOutOrgName()));
            historyVOList.add(updateHistory("是否国家出资企业业主",orgEntity.getBeOwner()==true?"是":"否",entity.getBeOwner()==true?"是":"否"));
            historyVOList.add(updateHistory("主要出资人名称",orgEntity.getMainCapitalOrgName(),entity.getMainCapitalOrgName()));
            historyVOList.add(updateHistory("注册国家名称",orgEntity.getRegisterCountryName(),entity.getRegisterCountryName()));
            historyVOList.add(updateHistory("注册地境",orgEntity.getRegisterIn()!= null?orgEntity.getRegisterIn():"",entity.getRegisterIn()!= null?entity.getRegisterIn():""));
            historyVOList.add(updateHistory("注册地",orgEntity.getRegisterAddress() != null?orgEntity.getRegisterAddress():"",entity.getRegisterAddress() != null?entity.getRegisterAddress():""));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            historyVOList.add(updateHistory("注册日期",sdf.format(orgEntity.getRegisterDate()!= null ?orgEntity.getRegisterDate():new Date()),sdf.format(entity.getDateIncorporation() != null?entity.getDateIncorporation():new Date())));
            historyVOList.add(updateHistory("注册资本币种名称",orgEntity.getCurrencyTypeName(),entity.getCurrencyTypeName()));
            historyVOList.add(updateHistory("企业类别名称",orgEntity.getOrgTypeName(),entity.getOrgTypeName()));
            historyVOList.add(updateHistory("注册资本",orgEntity.getCurrencyTypeName(),entity.getCurrencyTypeName()));
            historyVOList.add(updateHistory("注册资本大写",orgEntity.getRegisterCapitalBig()!= null?orgEntity.getRegisterCapitalBig():"" ,entity.getRegisterCapitalBig()!= null?entity.getRegisterCapitalBig():""));
            historyVOList.add(updateHistory("国资监管机构",orgEntity.getRegulatoryBodies(),entity.getRegulatoryBodies()));
            historyVOList.add(updateHistory("组织形式",orgEntity.getOrgFormName(),entity.getOrgFormName()));
            historyVOList.add(updateHistory("主要行业",orgEntity.getMajorIndustries()!= null?orgEntity.getMajorIndustries():"",entity.getMajorIndustries()!= null?entity.getMajorIndustries():""));
            historyVOList.add(updateHistory("企业产权级次",orgEntity.getProductLevel(),entity.getProductLevel()));
            historyVOList.add(updateHistory("企业管理级次",orgEntity.getMangerLevel(),entity.getMangerLevel()));
            historyVOList.add(updateHistory("是否上市公司",orgEntity.getBeListed() != null?(orgEntity.getBeListed()== true?"是":"否"):"",entity.getBeListed() != null?(entity.getBeListed()== true?"是":"否"):""));
            historyVOList.add(updateHistory("是否并表",orgEntity.getMergeTable()!=null?(orgEntity.getMergeTable()== true?"是":"否"):"",entity.getMergeTable() !=null ?(entity.getMergeTable()== true?"是":"否"):""));
            historyVOList.add(updateHistory("是否存在休眠/停业/歇业等情况",orgEntity.getBeClosed() != null ?(orgEntity.getBeClosed()== true?"是":"否"):"",entity.getBeClosed() != null?(entity.getBeClosed()== true?"是":"否"):""));
            JSONArray jsonArray = JSON.parseArray(JSON.toJSONString(historyVOList));
            productionEntity.setHistoryRecord(JSONArray.toJSONString(jsonArray));
            List<InvestorsEntity> investorsBeforeList=productionEntity.getInvestorsEntities();
            List<InvestorsEntity> investorsAfterList=entity.getInvestorsEntities();
            productionEntity.setInvestorsBefore(JSON.toJSONString(investorsBeforeList));
            productionEntity.setInvestorsAfter(JSON.toJSONString(investorsAfterList));
            productionService.updateById(productionEntity);
        }
        orgEntity.setName(entity.getName());
        orgEntity.setUnifiedSocialCreditCode(entity.getUnifiedSocialCreditCode());
        orgEntity.setInReacrd(entity.getInReacrd());
        if(StringUtils.isNotEmpty(entity.getOutCapitalOrg())){
            orgEntity.setOutCapitalOrg(Long.valueOf(entity.getOutCapitalOrg()));

        }
        orgEntity.setOutCapitalOrgName(entity.getOutCapitalOrgName());
        orgEntity.setRelationToOutOrg(entity.getReductionCapitalId());
        orgEntity.setRelationToOutOrgName(entity.getRelationToOutOrgName());
        orgEntity.setBeOwner(entity.getBeOwner());
        orgEntity.setMainCapitalOrgId(entity.getMainCapitalOrgId());
        orgEntity.setRelationToOutOrgName(entity.getMainCapitalOrgName());
        orgEntity.setRegisterCountryId(entity.getRegisterCountryId());
        orgEntity.setRegisterCountryName(entity.getRegisterCountryName());
        orgEntity.setRegisterIn(entity.getRegisterIn());
        orgEntity.setRegisterAddress(entity.getRegisterAddress());
        orgEntity.setRegisterDate(entity.getDateIncorporation());
        orgEntity.setCurrencyTypeId(entity.getCurrencyTypeId());
        orgEntity.setCurrencyTypeName(entity.getCurrencyTypeName());
        orgEntity.setRegisterCapital(entity.getRegisterCapital());
        orgEntity.setRegisterCapitalBig(entity.getRegisterCapitalBig());
        orgEntity.setOrgTypeId(entity.getOrgTypeId());
        orgEntity.setOrgTypeName(entity.getOrgTypeName());
        if(StringUtils.isNotEmpty(entity.getRegulatoryBodiesId())){
            orgEntity.setRegulatoryBodiesId(Long.valueOf(entity.getRegulatoryBodiesId()));
        }
        orgEntity.setRegulatoryBodies(entity.getRegulatoryBodies());
        orgEntity.setOrgFormId(entity.getOrgFormId());
        orgEntity.setOrgFormName(entity.getOrgFormName());
        orgEntity.setMajorIndustriesId(entity.getMajorIndustriesId());
        orgEntity.setMajorIndustries(entity.getMajorIndustries());
        orgEntity.setProductLevel(entity.getProductLevel());
        orgEntity.setMangerLevel(entity.getMangerLevel());
        orgEntity.setBeListed(entity.getBeListed());
        orgEntity.setMergeTable(entity.getMergeTable());
        orgEntity.setBeClosed(entity.getBeClosed());
        orgEntity.setProductionId(entity.getId());
        orgEntity.setUseStatus(true);


        OrgApplyEntity orgApply =orgApplyService.getById(entity.getSourceApplyId());
        OrgVO orgVO =saveOrg(orgEntity,orgApply);

        orgEntity.setOrgId(orgVO.getId());
        SddjsOrgEntity sddjsOrgEntity =sddjsOrgService.getById(orgApply.getInUseOrgId());
        sddjsOrgEntity.setOrgId(orgVO.getId());
        sddjsOrgService.saveOrUpdate(sddjsOrgEntity);
        List<ProductionEntity> productionList =productionService.queryProductionByApplyId(productionEntity.getSourceApplyId());
        if(productionEntity.getApplyType().equals("set") && productionList.size() <=1){
            orgApply.setProductionState("registered");//设置申请单已登记
            orgApplyService.saveOrUpdate(orgApply);
        }
        this.saveOrUpdate(orgEntity);
    }

    /**
     * 添加到组织机构
     * @param orgEntity
     */
    @Transactional
    public OrgVO saveOrg(ProductionOrgEntity orgEntity, OrgApplyEntity orgApply){
        //生成组织
        CommonResponse<OrgVO> responseOrgVo =orgApi.getOneById(orgEntity.getOrgId());

        OrgVO projectDepartment = new OrgVO();
        if (responseOrgVo.getData() != null){
            projectDepartment = responseOrgVo.getData();
        }else{
            projectDepartment.setId(IdWorker.getId());

        }
        projectDepartment.setParentId(orgApply.getDirectSuperiorOrgId());
        projectDepartment.setTenantId(InvocationInfoProxy.getTenantid());
        //projectDepartment.setEnterpriseId(entity.getEnterpriseId());
        projectDepartment.setIsParent(false);
        projectDepartment.setName(orgEntity.getName());
        projectDepartment.setShortName(orgEntity.getName());
        //projectDepartment.setSourceId(projectRegisterVO.getSourceId());
        projectDepartment.setState(1);
        //项目部类型
        projectDepartment.setOrgType(2);
        CommonResponse<OrgVO> commonResponse =orgApi.saveOrgInfo(projectDepartment);
        if(commonResponse.getCode() !=0){
            throw new BusinessException("推送组织结构异常");
        }
        return commonResponse.getData();

    }


    /**
     *  修改历史记录
     * @param name
     * @param before
     * @param after
     * @return
     */
    public HistoryVO updateHistory(String name,String after,String before){
        HistoryVO vo = new HistoryVO(name,before,after);
        if(!before.equals(after)){
            vo.setName(name);
            vo.setBefore(before);
            vo.setAfter(after);
        }else{
            vo.setName(name);
            vo.setBefore("");
            vo.setAfter("");
        }
        return vo;
    }

    /**
     * 注销
     * @param entity
     */
    public void updateCancellation(ProductionEntity entity){
        OrgApplyEntity orgApply =orgApplyService.getById(entity.getSourceApplyId());

        CommonResponse<OrgVO> responseOrgVo =orgApi.getOneById(entity.getOrgId());
        OrgVO projectDepartment = new OrgVO();
        if (responseOrgVo.getData() != null){
            projectDepartment = responseOrgVo.getData();
            projectDepartment.setState(0);//停用
            orgApi.saveOrgInfo(projectDepartment);
        }

        QueryWrapper wrapper = new QueryWrapper<>();
        wrapper.eq("org_id",orgApply.getInUseOrgId());
        List<ProductionOrgEntity> list =this.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            ProductionOrgEntity orgEntity = list.get(0);
            orgEntity.setUseStatus(false);
            this.saveOrUpdate(orgEntity);
        }

    }
}
